/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.util.*;
import java.lang.reflect.Type;

/**
 * Set^PropertyEditorNXB<p>
 * J}؂̕java.util.Set^̃IuWFNgɕϊBJ}Zp[^ł͂ȂƂĎw肵ꍇ́A""ŃGXP[vB<br>
 * ŏƍŌ̋󔒂ƉsŐ󔒂̓gB
 * 󔒂́A{@link java.lang.Character#isWhitespace(char)}Ŕ肳B
 * AA󔒂𕶎̑Oɕtꍇɂ́A"ň͂ނƃgȂB"𕶎̗[ɈӐ}Iɕtꍇɂ́A"dɏd˂ċLqB<br>
 * "&lt;!--""--&gt;"Ɉ͂܂ꂽ̓RgƉ߂ꖳB<br>
 * "${""}"Ɉ͂܂ꂽ́ÃVXevpeBƒuB<br>
 * "${\t}"A"${\n}"A"${\r}"A"${\f}"́AGXP[vV[PXƂĒuB<br>
 * "u"n܂ÚAjR[hƂĒuB<br>
 * <p>
 * F<br>
 * &nbsp;&nbsp;A,B, C  <br>
 * &nbsp;&nbsp;C, D,E ,&lt;!--F,<br>
 * &nbsp;&nbsp;G,--&gt;"H ",""I""<br>
 * <br>
 * &nbsp;̂悤ȕ<br>
 * <br>
 * &nbsp;&nbsp;Set set = new LinkedHashSet();<br>
 * &nbsp;&nbsp;set.add("A");<br>
 * &nbsp;&nbsp;set.add("B");<br>
 * &nbsp;&nbsp;set.add(" CC");<br>
 * &nbsp;&nbsp;set.add(" D");<br>
 * &nbsp;&nbsp;set.add("E ");<br>
 * &nbsp;&nbsp;set.add("H ");<br>
 * &nbsp;&nbsp;set.add("\"I\"");<br>
 * <br>
 * &nbsp;̂悤ɕϊB<br>
 *
 * @author M.Takata
 */
public class SetEditor extends ParameterizedTypePropertyEditorSupport
 implements java.io.Serializable{
    
    private static final long serialVersionUID = -6590306576350919831L;
    
    private final StringArrayEditor stringArrayEditor = new StringArrayEditor();
    
    /**
     * w肳ꂽ͂ăvpeBlݒ肷B<p>
     *
     * @param text ͂镶
     */
    @Override
    public void setAsText(String text){
        if(text == null){
            setValue(null);
            return;
        }
        stringArrayEditor.setAsText(text);
        final String[] stringArray = (String[])stringArrayEditor.getValue();
        if(stringArray != null){
            Set<Object> set = new LinkedHashSet<Object>();
            for(String str : stringArray){
                Object valObj = str;
                if(parameterizedType != null){
                    Type[] types = parameterizedType.getActualTypeArguments();
                    if(types != null && types.length == 1){
                        valObj = getValue(types[0], str);
                    }
                }
                set.add(valObj);
            }
            setValue(set);
        }
    }
    
    /**
     * vpeB擾B<p>
     *
     * @return vpeB
     */
    @Override
    public String getAsText(){
        @SuppressWarnings("unchecked")
        final Set<Object> set = (Set<Object>)getValue();
        if(set == null){
            return null;
        }
        final StringBuilder buf = new StringBuilder();
        int i = 0;
        for(Object val : set){
            if(parameterizedType != null){
                Type[] types = parameterizedType.getActualTypeArguments();
                if(types != null && types.length == 1){
                    val = getAsText(types[0], val);
                }
            }
            String str = val == null ? null : val.toString();
            if(str != null){
                str = str.replaceAll(",", "\\\\,");
            }
            buf.append(str);
            if(i != set.size() - 1){
                buf.append(',');
            }
            i++;
        }
        return buf.toString();
    }
}
