/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.lang.reflect.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * ORvpeBB<p>
 * Q̃vpeBNullłȂ̃vpeBɃANZX邽߂{@link Property}B<br>
 * ȉ̂悤ȃvpeBɃANZX^CvZ[tȃR[hB<br>
 * <pre>
 *   Object propValue = bean.getHoge() != null ? bean.getHoge() : bean.getFuga();
 * </pre>
 * ORvpeBgŁÃR[h<br>
 * <pre>
 *   OrPropery prop = new OrPropery(new SimpleProperty("hoge"), new SimpleProperty("fuga"));
 *   Object propValue = prop.getProperty(obj);
 * </pre>
 * ƂR[hɒu鎖łB<br>
 * ̃R[h́A璷ɂȂĂ邪AΏۂƂȂBeaň^⃁\bh^CvZ[tɏȂIȃR[hɂȂĂB<br>
 * <p>
 * ̃lXgvpeBł́Aȉ̂悤BeañvpeBɑ΂ANZX@pӂĂB<br>
 * <table border="1">
 *   <tr bgcolor="#CCCCFF"><th rowspan="2">ANZX@</th><th>Java\</th><th rowspan="2">vpeB\</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>vpeB擾</th></tr>
 *   <tr><td>ORvpeB</td><td>bean.getHoge() != null ? bean.getHoge() : bean.getFuga()</td><td>hoge|fuga</td></tr>
 * </table>
 * ORΏۂ̂Q̃vpeB́A{@link Property}C^tF[XĂΗǂB<br>
 *
 * @author M.Takata
 */
public class OrProperty implements Property, Comparable<Property>, java.io.Serializable{
    
    private static final long serialVersionUID = 4557829281768367883L;
    private static final String MSG_00001 = "Illegal OrProperty : ";
    private static final String MSG_00002 = "Arguments is null.";
    
    /**
     * vpeBB<p>
     */
    protected Property firstProperty;
    
    /**
     * vpeBB<p>
     */
    protected Property secondProperty;
    
    /**
     * nullQƂ̃vpeB擾gpƂꍇɁAOthrow邩ǂ̃tOB<p>
     * truȅꍇ́AOthrowȂBftHǵAfalseB<br>
     */
    protected boolean isIgnoreNullProperty;
    
    /**
     * ORvpeB𐶐B<p>
     */
    public OrProperty(){
    }
    
    /**
     * w肵Q̃vpeBORvpeB𐶐B<p>
     *
     * @param first vpeB
     * @param second vpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public OrProperty(Property first, Property second)
     throws IllegalArgumentException{
        if(first == null || second == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        firstProperty = first;
        secondProperty = second;
    }
    
    /**
     * vpeBݒ肷B<p>
     * 
     * @param prop vpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public void setFirstProperty(Property prop) throws IllegalArgumentException{
        if(prop == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        firstProperty = prop;
    }
    
    /**
     * vpeB擾B<p>
     * 
     * @return vpeB
     */
    public Property getFirstProperty(){
        return firstProperty;
    }
    
    /**
     * lXgvpeB擾B<p>
     * 
     * @return lXgvpeB
     */
    public Property getNestedFirstProperty(){
        if(firstProperty instanceof OrProperty){
            return ((OrProperty)firstProperty).getNestedFirstProperty();
        }else{
            return firstProperty;
        }
    }
    
    /**
     * vpeBݒ肷B<p>
     * 
     * @param prop vpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public void setSecondProperty(Property prop)
     throws IllegalArgumentException{
        if(prop == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        secondProperty = prop;
    }
    
    /**
     * vpeB擾B<p>
     * 
     * @return vpeB
     */
    public Property getSecondProperty(){
        return secondProperty;
    }
    
    /**
     * w肵vpeB͂B<p>
     * Ŏw\ȕ́A<br>
     * &nbsp;vpeB|vpeB<br>
     * łB<br>
     *
     * @param prop vpeB
     * @exception IllegalArgumentException w肳ꂽvpeB̃vpeBIuWFNg͂łȂꍇ
     */
    @Override
    public void parse(String prop) throws IllegalArgumentException{
        final int index = prop.indexOf('|');
        if(index == -1 || index == 0 || index == prop.length() - 1){
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        firstProperty = PropertyFactory.createProperty(prop.substring(0, index).trim());
        secondProperty = PropertyFactory.createProperty(
            prop.substring(index + 1).trim()
        );
    }
    
    @Override
    public Class<?> getPropertyType(Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        Object firstObj = null;
        try{
            firstObj = firstProperty.getProperty(obj);
        }catch(NoSuchPropertyException e){}
        if(firstObj != null){
            return firstProperty.getPropertyType(obj);
        }else{
            return secondProperty.getPropertyType(obj);
        }
    }
    
    @Override
    public Type getPropertyGenericType(Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        Object firstObj = null;
        try{
            firstObj = firstProperty.getProperty(obj);
        }catch(NoSuchPropertyException e){}
        if(firstObj != null){
            return firstProperty.getPropertyGenericType(obj);
        }else{
            return secondProperty.getPropertyGenericType(obj);
        }
    }
    
    @Override
    public boolean isReadable(Object obj){
        try{
            firstProperty.getProperty(obj);
            secondProperty.getProperty(obj);
        }catch(NoSuchPropertyException e){
            return false;
        }catch(InvocationTargetException e){
            return false;
        }
        return true;
    }
    
    @Override
    public boolean isWritable(Object obj, Class<?> clazz){
        return false;
    }
    
    /**
     * w肵IuWFNgÃvpeB\vpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @return vpeBl
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public Object getProperty(Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        Object firstObj = null;
        try{
            firstObj = firstProperty.getProperty(obj);
        }catch(NoSuchPropertyException e){}
        if(firstObj == null){
            return secondProperty.getProperty(obj);
        }else{
            return firstObj;
        }
    }
    
    /**
     * T|[gȂB<p>
     *
     * @param obj ΏۂƂȂBean
     * @param value ݒ肷vpeBl
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public void setProperty(Object obj, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        throw new UnsupportedOperationException();
    }
    
    /**
     * T|[gȂB<p>
     *
     * @param obj ΏۂƂȂBean
     * @param type vpeB̌^
     * @param value ݒ肷vpeBl
     * @exception NullNestPropertyException lXgvpeBAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public void setProperty(Object obj, Class<?> type, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        throw new UnsupportedOperationException();
    }
    
    /**
     * ̃vpeB\vpeB擾B<p>
     *
     * @return vpeB|vpeB
     */
    @Override
    public String getPropertyName(){
        return firstProperty.getPropertyName()
            + '|' + secondProperty.getPropertyName();
    }
    
    @Override
    public void setIgnoreNullProperty(boolean isIgnore){
        isIgnoreNullProperty = isIgnore;
        if(firstProperty != null){
            firstProperty.setIgnoreNullProperty(isIgnoreNullProperty);
        }
        if(secondProperty != null){
            secondProperty.setIgnoreNullProperty(isIgnoreNullProperty);
        }
    }
    
    @Override
    public boolean isIgnoreNullProperty(){
        return isIgnoreNullProperty;
    }
    
    /**
     * AɃvpeBJԂqԂB<p>
     *
     * @return AɃvpeBJԂq
     */
    public Iterator<Property> iterator(){
        final List<Property> list = new ArrayList<Property>();
        OrProperty nested = this;
        do{
            list.add(0, nested.getSecondProperty());
            Property prop = getFirstProperty();
            if(prop instanceof OrProperty){
                nested = (OrProperty)prop;
            }else{
                list.add(0, prop);
                nested = null;
            }
        }while(nested != null);
        
        return list.iterator();
    }
    
    /**
     * ̃lXgvpeB̕\擾B<p>
     *
     * @return NestedProperty{vpeB.lXgvpeB}
     */
    @Override
    public String toString(){
        return "OrProperty{" + firstProperty.toString()
            + '|' + secondProperty.toString() + '}';
    }
    
    /**
     * ̃IuWFNgƑ̃IuWFNgǂ܂B <p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return Ɏw肳ꂽIuWFNgƂ̃IuWFNgꍇ trueAłȂꍇ falseB
     */
    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(!(obj instanceof OrProperty)){
            return false;
        }
        final OrProperty comp = (OrProperty)obj;
        if(firstProperty == null && comp.firstProperty != null
            || firstProperty != null && comp.firstProperty == null){
            return false;
        }else if(firstProperty != null && comp.firstProperty != null
            && !firstProperty.equals(comp.firstProperty)){
            return false;
        }
        if(secondProperty == null && comp.secondProperty == null){
            return true;
        }else if(secondProperty == null){
            return false;
        }else{
            return secondProperty.equals(comp.secondProperty);
        }
    }
    
    /**
     * nbVl擾B<p>
     *
     * @return nbVl
     */
    @Override
    public int hashCode(){
        return (firstProperty == null ? 0 : firstProperty.hashCode()) + (secondProperty == null ? 0 : secondProperty.hashCode()) + 3;
    }
    
    /**
     * ̃IuWFNgƎw肳ꂽIuWFNg̏rB<p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return ̃IuWFNgw肳ꂽIuWFNg菬ꍇ͕̐Aꍇ̓[A傫ꍇ͐̐
     */
    @SuppressWarnings("unchecked")
    @Override
    public int compareTo(Property obj){
        if(obj == null){
            return 1;
        }
        if(!(obj instanceof OrProperty)){
            return 1;
        }
        final OrProperty comp = (OrProperty)obj;
        if(firstProperty == null && comp.firstProperty != null){
            return -1;
        }else if(firstProperty != null && comp.firstProperty == null){
            return 1;
        }else if(firstProperty != null && comp.firstProperty != null){
            if(firstProperty instanceof Comparable){
                final int val = ((Comparable<Property>)firstProperty).compareTo(comp.firstProperty);
                if(val != 0){
                    return val;
                }
            }else{
                return -1;
            }
        }
        if(secondProperty == null && comp.secondProperty == null){
            return 0;
        }else if(secondProperty == null){
            return -1;
        }else{
            if(secondProperty instanceof Comparable){
                return ((Comparable<Property>)secondProperty).compareTo(comp.secondProperty);
            }else{
                return -1;
            }
        }
    }
}
