/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.io.*;

import jp.ossc.nimbus.core.*;

/**
 * w肳ꂽvpeB݂ȂOB<p>
 *
 * @author M.Takata
 * @see Property
 */
public class NoSuchPropertyException extends Exception implements Serializable{
    
    private static final long serialVersionUID = 5772189868420840538L;
    
    /**
     * G[ΏۂƂȂBeañNXIuWFNgB<p>
     */
    protected transient Class<?> clazz;
    
    /**
     * G[ΏۂƂȂvpeBB<p>
     */
    protected final String property;
    
    /**
     * G[ΏۂƂȂBeañNXAvpeBO𐶐B<p>
     *
     * @param clazz G[ΏۂƂȂBeañNX
     * @param property G[ΏۂƂȂvpeB
     */
    public NoSuchPropertyException(Class<?> clazz, String property){
        this(clazz, property, (Throwable)null);
    }
    
    /**
     * G[ΏۂƂȂBeañNXAvpeBAOO𐶐B<p>
     *
     * @param clazz G[ΏۂƂȂBeañNX
     * @param property G[ΏۂƂȂvpeB
     * @param th O
     */
    public NoSuchPropertyException(
        Class<?> clazz,
        String property,
        Throwable th
    ){
        super(
            "No such property. class=" + clazz + ", property=" + property,
            th
        );
        this.clazz = clazz;
        this.property = property;
    }
    
    /**
     * G[ΏۂƂȂBeañNXAvpeBAbZ[WO𐶐B<p>
     *
     * @param clazz G[ΏۂƂȂBeañNX
     * @param property G[ΏۂƂȂvpeB
     * @param cause bZ[W
     */
    public NoSuchPropertyException(
        Class<?> clazz,
        String property,
        String cause
    ){
        super(
            "No such property. class=" + clazz + ", property=" + property + " : Cause " + cause
        );
        this.clazz = clazz;
        this.property = property;
    }
    
    /**
     * G[ΏۂƂȂBeañNX擾B<p>
     *
     * @return G[ΏۂƂȂBeañNX
     */
    public Class<?> getTargetObjectClass(){
        return clazz;
    }
    
    /**
     * G[ΏۂƂȂvpeB擾B<p>
     *
     * @return G[ΏۂƂȂvpeB
     */
    public String getProperty(){
        return property;
    }
    
    private void writeObject(ObjectOutputStream out) throws IOException{
        out.defaultWriteObject();
        out.writeObject(clazz.getName());
    }
    
    private void readObject(ObjectInputStream in)
     throws IOException, ClassNotFoundException{
        in.defaultReadObject();
        final String className = (String)in.readObject();
        clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
    }
}
