/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import static org.testng.Assert.*;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * {@link ServiceStateChangeEvent}eXgP[XB<p>
 * 
 * @author M.Takata
 */
public class ServiceStateChangeEventTest{
    
    @Test(groups = {"jp.ossc.nimbus.core.ServiceStateChangeEvent#ServiceStateChangeEvent(jp.ossc.nimbus.core.Service)",
                    "Normal"})
    public void testServiceStateChangeEvent() throws Exception{
        Service service = new MyService();
        ServiceStateChangeEvent event = new ServiceStateChangeEvent(service);
        assertEquals(event.getService(), service);
        assertNull(event.getThrowable());
    }
    
    @DataProvider(name = "ServiceStateChangeEvent")
    public Object[][] dataServiceStateChangeEvent(){
        return new Object[][]{
            {new MyService(), null},
            {new MyService(), new Exception("eXg")}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.ServiceStateChangeEvent#ServiceStateChangeEvent(jp.ossc.nimbus.core.Service,java.lang.Throwable)",
                    "Normal"},
          dataProvider = "ServiceStateChangeEvent")
    public void testServiceStateChangeEvent(Service service, Throwable th) throws Exception{
        ServiceStateChangeEvent event = new ServiceStateChangeEvent(service, th);
        assertEquals(event.getService(), service);
        assertEquals(event.getThrowable(), th);
    }
    
    @Test(groups = {"jp.ossc.nimbus.core.ServiceStateChangeEvent#ServiceStateChangeEvent(jp.ossc.nimbus.core.Service)",
                    "Error"},
          expectedExceptions = {IllegalArgumentException.class})
    public void testServiceStateChangeEventError() throws Exception{
        new ServiceStateChangeEvent(null);
    }
    
    @DataProvider(name = "ServiceStateChangeEvent2")
    public Object[][] dataServiceStateChangeEvent2(){
        return new Object[][]{
            {null, null},
            {null, new Exception("eXg")}
        };
    }
    
    @Test(groups = {"jp.ossc.nimbus.core.ServiceStateChangeEvent#ServiceStateChangeEvent(jp.ossc.nimbus.core.Service,java.lang.Throwable)",
                    "Error"},
          expectedExceptions = {IllegalArgumentException.class},
          dataProvider = "ServiceStateChangeEvent2")
    public void testServiceStateChangeEventError2(Service service, Throwable th) throws Exception{
        new ServiceStateChangeEvent(service, th);
    }
    
    public static class MyService implements Service{
        
        private String serviceManagerName;
        private String serviceName;
        private State state = State.DESTROYED;
        
        @Override
        public String getServiceManagerName(){
            return serviceManagerName;
        }
        @Override
        public void setServiceManagerName(String name) {
            serviceManagerName = name;
        }
        @Override
        public String getServiceName(){
            return serviceName;
        }
        @Override
        public void setServiceName(String name) {
            serviceName = name;
        }
        @Override
        public ServiceName getServiceNameObject() {
            return serviceManagerName != null && serviceName != null ? new ServiceName(serviceManagerName, serviceName) : null;
        }
        @Override
        public State getState(){
            return state;
        }
        @Override
        public void create(){
            state = State.CREATED;
        }
        @Override
        public void start(){
            state = State.STARTED;
        }
        @Override
        public void stop(){
            state = State.STOPPED;
        }
        @Override
        public void destroy(){
            state = State.DESTROYED;
        }
    }
}
