/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import static org.testng.Assert.*;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;
import org.w3c.dom.Element;

import static jp.ossc.nimbus.TestUtility.*;
import jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData;

/**
 * {@link jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData LogCategoryMetaData}eXgP[XB<p>
 * 
 * @author M.Takata
 */
public class LogCategoryMetaDataTest{

    @DataProvider(name = "LogCategoryMetaData")
    public Object[][] dataLogCategoryMetaData(){
        return new Object[][]{
            {null},
            {new DefaultLogMetaData(null)},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData#LogCategoryMetaData(jp.ossc.nimbus.core.MetaData)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "LogCategoryMetaData")
    public void testLogCategoryMetaData(MetaData parent){
        LogCategoryMetaData metaData = new LogCategoryMetaData(parent);
        assertEquals(metaData.getParent(), parent);
    }

    @DataProvider(name = "SetOutput")
    public Object[][] dataSetOutput(){
        return new Object[][]{
            {true},
            {false}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData#setOutput(boolean)",
                    "jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData#isOutput()",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#LogCategoryMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "SetOutput")
    public void testSetOutput(boolean output){
        LogCategoryMetaData metaData = new LogCategoryMetaData(null);
        metaData.setOutput(output);
        assertEquals(metaData.isOutput(), output);
    }

    @DataProvider(name = "ImportXML")
    public Object[][] dataImportXML() throws Exception{
        return new Object[][]{
            {null, "debug", createElement("<debug output=\"true\"/>"), true},
            {null, null, createElement("<debug output=\"true\"/>"), true},
            {new DefaultLogMetaData(null), "debug", createElement("<debug output=\"true\"/>"), true},
            {new DefaultLogMetaData(null), "debug", createElement("<debug output=\"false\"/>"), false},
            {new DefaultLogMetaData(null), "debug", createElement("<debug/>"), false},
            {new DefaultLogMetaData(null), "debug", createElement("<debug unknown=\"fuga\"/>"), false},
            {new DefaultLogMetaData(null), "debug", createElement("<debug><unknown/></debug>"), false},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData#LogCategoryMetaData(jp.ossc.nimbus.core.MetaData,java.lang.String)",
                    "jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData#importXML(org.w3c.dom.Element)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#isOutput\\(\\)"},
          dataProvider = "ImportXML")
    public void testImportXML(MetaData parent, String name, Element element, boolean output) throws DeploymentException{
        LogCategoryMetaData metaData = new LogCategoryMetaData(parent, name);
        assertEquals(metaData.getParent(), parent);
        metaData.importXML(element);
        assertEquals(metaData.isOutput(), output);
    }

    @DataProvider(name = "ImportXMLError")
    public Object[][] dataImportXMLError() throws Exception{
        return new Object[][]{
            {null, null, null},
            {new DefaultLogMetaData(null), "debug", createElement("<hoge/>")},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData#importXML(org.w3c.dom.Element)",
                    "Error"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          expectedExceptions = {NullPointerException.class, DeploymentException.class},
          dataProvider = "ImportXMLError")
    public void testImportXMLError(MetaData parent, String name, Element element) throws DeploymentException{
        LogCategoryMetaData metaData = new LogCategoryMetaData(parent, name);
        metaData.importXML(element);
    }

    @DataProvider(name = "ToXML")
    public Object[][] dataToXML() throws Exception{
        return new Object[][]{
            {createElement("<debug/>"), "<debug output=\"false\"/>"},
            {createElement("<debug></debug>"), "<debug output=\"false\"/>"},
            {createElement("<debug output=\"true\"/>"), "<debug output=\"true\"/>"},
            {createElement("<debug output=\"false\"/>"), "<debug output=\"false\"/>"},
            {createElement("<error output=\"true\"/>"), "<error output=\"true\"/>"},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData#toXML(java.lang.StringBuilder)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#LogCategoryMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#importXML\\(org\\.w3c\\.dom\\.Element\\)"},
          dataProvider = "ToXML")
    public void testToXML(Element element, String expected) throws DeploymentException{
        LogCategoryMetaData metaData = new LogCategoryMetaData(null);
        metaData.importXML(element);
        StringBuilder buf = new StringBuilder();
        metaData.toXML(buf);
        assertEquals(buf.toString(), expected);
    }
}
