/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.Date;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.beanflow.*;


/**
 * BeanFlowXPW[쐬T[rXB<p>
 * XPW[̍쐬L̔BeanFlowɈϏB<br>
 *
 * @author M.Takata
 */
public class BeanFlowConditionScheduleMakerService
 extends DefaultScheduleMakerService
 implements BeanFlowConditionScheduleMakerServiceMBean{
    
    private static final long serialVersionUID = 9128789021473711234L;
    protected ServiceName beanFlowFactoryServiceName;
    protected BeanFlowFactory beanFlowFactory;
    
    protected String flowName;
    
    // BeanFlowConditionScheduleMakerServiceMBeanJavaDoc
    public void setBeanFlowFactoryServiceName(ServiceName name){
        beanFlowFactoryServiceName = name;
    }
    // BeanFlowConditionScheduleMakerServiceMBeanJavaDoc
    public ServiceName getBeanFlowFactoryServiceName(){
        return beanFlowFactoryServiceName;
    }
    
    // BeanFlowConditionScheduleMakerServiceMBeanJavaDoc
    public void setFlowName(String name){
        flowName = name;
    }
    // BeanFlowConditionScheduleMakerServiceMBeanJavaDoc
    public String getFlowName(){
        return flowName;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService() throws Exception{
        
        if(beanFlowFactoryServiceName != null){
            beanFlowFactory = (BeanFlowFactory)ServiceManagerFactory
                .getServiceObject(beanFlowFactoryServiceName);
        }
        if(beanFlowFactory == null){
            throw new IllegalArgumentException("BeanFlowFactory is null.");
        }
    }
    
    /**
     * {@link BeanFlowFactory}ݒ肷B<p>
     *
     * @param factory BeanFlowFactory
     */
    public void setBeanFlowFactory(BeanFlowFactory factory){
        beanFlowFactory = factory;
    }
    
    /**
     * {@link BeanFlowFactory}擾B<p>
     *
     * @return BeanFlowFactory
     */
    public BeanFlowFactory getBeanFlowFactory(){
        return beanFlowFactory;
    }
    
    /**
     * ̓tŁAXPW[쐬Kv邩ǂ𔻒肷B<p>
     * {@link #setFlowName(String)}Őݒ肳ꂽBeanFlow܂́A{@link ScheduleMaster#getScheduleType()}Ŏ擾XPW[ʖBeanFlowsāA̖߂lŃXPW[̍쐬L𔻒fB<br>
     * BeanFloẅɂ́AzŁÃ\bḧłdatemasternB<br>
     *
     * @param date 쐬
     * @param master XPW[}X^
     * @return truȅꍇAKv
     * @exception ScheduleMakeException Ɏsꍇ
     */
    protected boolean isNecessaryMake(Date date, ScheduleMaster master)
     throws ScheduleMakeException{
        final String conditionFlowName = flowName == null ? master.getScheduleType() : flowName;
        BeanFlow flow = null;
        try{
            flow = beanFlowFactory.createFlow(
                conditionFlowName
            );
        }catch(BeanFlowException e){
            throw new ScheduleMakeException(e);
        }
        
        boolean result = false;
        try{
            Object ret = flow.execute(new Object[]{date, master});
            if(ret instanceof Boolean){
                result = ((Boolean)ret).booleanValue();
            }else{
                throw new ScheduleMakeException("Return of BeanFlow is not boolean : " + ret);
            }
        }catch(Exception e){
            throw new ScheduleMakeException(e);
        }
        return result;
    }
}