/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import java.io.IOException;

import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.io.Externalizer;

/**
 * 񉻃LbVT[rXB<p>
 * ȉɁALbVIuWFNg𒼗񉻂ăɕێLbVT[rX̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="SerializedMemoryCache"
 *                  code="jp.ossc.nimbus.service.cache.SerializedMemoryCacheService"/&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class SerializedMemoryCacheService<E> extends AbstractCacheService<E>
 implements java.io.Serializable, SerializedMemoryCacheServiceMBean<E>{
    
    private static final long serialVersionUID = -360981346639234924L;
    
    private ServiceName externalizerServiceName;
    private Externalizer<E> externalizer;
    
    private ServiceName persistCacheServiceName;
    
    public void setPersistCacheServiceName(ServiceName name){
        persistCacheServiceName = name;
    }
    public ServiceName getPersistCacheServiceName(){
        return persistCacheServiceName;
    }
    
    public void setExternalizerServiceName(ServiceName name){
        externalizerServiceName = name;
    }
    public ServiceName getExternalizerServiceName(){
        return externalizerServiceName;
    }
    
    public void setExternalizer(Externalizer<E> ext){
        externalizer = ext;
    }
    public Externalizer<E> getExternalizer(){
        return externalizer;
    }
    
    @SuppressWarnings("unchecked")
    public void startService() throws Exception{
        if(externalizerServiceName != null){
            externalizer = ServiceManagerFactory
                .getServiceObject(externalizerServiceName);
        }
        if(persistCacheServiceName != null){
            Cache<E> persistCache = ServiceManagerFactory.getServiceObject(persistCacheServiceName);
            CachedReference<E>[] refs = persistCache.toArray(new CachedReference[persistCache.size()]);
            for(int i = 0; i < refs.length; i++){
                add(refs[i].get());
            }
        }
    }
    
    @SuppressWarnings("unchecked")
    public void stopService() throws Exception{
        if(persistCacheServiceName != null){
            Cache<E> persistCache = ServiceManagerFactory.getServiceObject(persistCacheServiceName);
            persistCache.clear();
            CachedReference<E>[] refs = toArray(new CachedReference[persistCache.size()]);
            for(int i = 0; i < refs.length; i++){
                persistCache.add(refs[i].get());
            }
        }
    }
    
    /**
     * w肳ꂽIuWFNg̃LbVQƂ𐶐B<p>
     *
     * @param obj LbVIuWFNg
     * @return LbVQ
     */
    protected CachedReference<E> createCachedReference(E obj){
        try{
            return externalizer == null ? new SerializeCachedReference<E>(obj)
                : new SerializeCachedReference<E>(obj, externalizer);
        }catch(IOException e){
            throw new IllegalArgumentException(e.toString());
        }
    }
}
