/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;
import jp.ossc.nimbus.service.context.*;
import jp.ossc.nimbus.service.sequence.*;
import jp.ossc.nimbus.service.codemaster.*;

/**
 * XbhReLXgC^[Zv^B<p>
 *
 * @author M.Takata
 */
public class ThreadContextInitializeInterceptorService
 extends ServletFilterInterceptorService
 implements ThreadContextInitializeInterceptorServiceMBean{
    
    private static final long serialVersionUID = -3154621046378825548L;
    
    protected ServiceName threadContextServiceName;
    protected Context<Object, Object> threadContext;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected ServiceName codeMasterFinderServiceName;
    protected CodeMasterFinder codeMasterFinder;
    protected Map<String, String> contextValueServiceNames;
    protected Map<String, ServiceName> contextValueServiceNameMap;
    protected Properties contextValueRequestParameter;
    protected Map<String, Object> contextValueMapping;
    
    protected boolean isOutputContextPath = true;
    protected boolean isOutputServletPath = true;
    protected boolean isOutputSessionID = true;
    protected boolean isNewSession = false;
    protected boolean isOutputThreadName = true;
    protected boolean isOutputThreadGroupName = true;
    protected boolean isInitializeRecursiveCall = true;
    protected boolean isClear = true;
    
    protected ThreadLocal<CallStack> callStack;
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setThreadContextServiceName(ServiceName name){
        threadContextServiceName = name;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public ServiceName getThreadContextServiceName(){
        return threadContextServiceName;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setCodeMasterFinderServiceName(ServiceName name){
        codeMasterFinderServiceName = name;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public ServiceName getCodeMasterFinderServiceName(){
        return codeMasterFinderServiceName;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setSequenceServiceName(ServiceName name){
        sequenceServiceName = name;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public ServiceName getSequenceServiceName(){
        return sequenceServiceName;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setContextValueServiceNames(Map<String, String> names){
        contextValueServiceNames = names;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public Map<String, String> getContextValueServiceNames(){
        return contextValueServiceNames;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setContextValueRequestParameter(Properties map){
        contextValueRequestParameter = map;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public Properties getContextValueRequestParameter(){
        return contextValueRequestParameter;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setContextValueMapping(Map<String, Object> mapping){
        contextValueMapping = mapping;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public Map<String, Object> getContextValueMapping(){
        return contextValueMapping;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setContextValue(String key, Object value){
        if(contextValueMapping == null){
            contextValueMapping = new HashMap<String, Object>();
        }
        contextValueMapping.put(key, value);
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public Object getContextValue(String key){
        if(contextValueMapping == null){
            return null;
        }
        return contextValueMapping.get(key);
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setOutputContextPath(boolean isOutput){
        isOutputContextPath = isOutput;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public boolean isOutputContextPath(){
        return isOutputContextPath;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setOutputServletPath(boolean isOutput){
        isOutputServletPath = isOutput;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public boolean isOutputServletPath(){
        return isOutputServletPath;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setOutputSessionID(boolean isOutput){
        isOutputSessionID = isOutput;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public boolean isOutputSessionID(){
        return isOutputSessionID;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setOutputThreadName(boolean isOutput){
        isOutputThreadName = isOutput;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public boolean isOutputThreadName(){
        return isOutputThreadName;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setOutputThreadGroupName(boolean isOutput){
        isOutputThreadGroupName = isOutput;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public boolean isOutputThreadGroupName(){
        return isOutputThreadGroupName;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setNewSession(boolean isNew){
        isNewSession = isNew;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public boolean isNewSession(){
        return isNewSession;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public boolean isInitializeRecursiveCall(){
        return isInitializeRecursiveCall;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setInitializeRecursiveCall(boolean isInitialize){
        isInitializeRecursiveCall = isInitialize;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public boolean isClear(){
        return isClear;
    }
    
    // ThreadContextInitializeInterceptorServiceMBeanJavaDoc
    public void setClear(boolean isClear){
        this.isClear = isClear;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService() throws Exception{
        if(threadContextServiceName == null){
            throw new IllegalArgumentException(
                "threadContextServiceName must be specified."
            );
        }
        threadContext = ServiceManagerFactory
            .getServiceObject(threadContextServiceName);
        if(sequenceServiceName != null){
            sequence = ServiceManagerFactory
                .getServiceObject(sequenceServiceName);
        }
        if(codeMasterFinderServiceName != null){
            codeMasterFinder = ServiceManagerFactory
                .getServiceObject(codeMasterFinderServiceName);
        }
        if(!isInitializeRecursiveCall){
            callStack = new ThreadLocal<CallStack>(){
                protected CallStack initialValue(){
                    return new CallStack();
                }
            };
        }
        if(contextValueServiceNames != null){
            contextValueServiceNameMap = new HashMap<String, ServiceName>();
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(getServiceManagerName());
            for(Map.Entry<String, String> entry : contextValueServiceNames.entrySet()){
                editor.setAsText(entry.getValue());
                contextValueServiceNameMap.put(entry.getKey(), (ServiceName)editor.getValue());
            }
        }
    }
    
    /**
     * T[rX̒~sB<p>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    public void stopService() throws Exception{
        callStack = null;
    }
    
    /**
     * XbhReLXgāÃC^[Zv^ĂяoB<p>
     * T[rXJnĂȂꍇ́AɎ̃C^[Zv^ĂяoB<br>
     *
     * @param context ĂяõReLXg
     * @param chain ̃C^[Zv^Ăяo߂̃`F[
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇA܂͂̃C^[Zv^ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    public Object invokeFilter(
        ServletFilterInvocationContext context,
        InterceptorChain chain
    ) throws Throwable{
        if(getState() == State.STARTED
            && (callStack == null
                 || ((CallStack)callStack.get()).stackIndex == 0)){
            
            final ServletRequest request = context.getServletRequest();
            if(isClear){
                threadContext.clear();
            }
            
            if(sequence != null){
                final String requestId = sequence.increment();
                threadContext.put(ThreadContextKey.REQUEST_ID, requestId);
            }
            
            if(contextValueServiceNameMap != null){
                for(Map.Entry<String, ServiceName> entry : contextValueServiceNameMap.entrySet()){
                    threadContext.put(
                        entry.getKey(),
                        ServiceManagerFactory.getServiceObject(
                            entry.getValue()
                        )
                    );
                }
            }
            
            if(contextValueRequestParameter != null
                 && contextValueRequestParameter.size() != 0){
                for(Map.Entry<Object, Object> entry : contextValueRequestParameter.entrySet()){
                    final String key = (String)entry.getKey();
                    final String parameterName = (String)entry.getValue();
                    String[] params = request.getParameterValues(parameterName);
                    if(params != null){
                        if(params.length == 1){
                            threadContext.put(
                                key,
                                params[0]
                            );
                        }else{
                            threadContext.put(
                                key,
                                params
                            );
                        }
                    }
                }
            }
            
            if(contextValueMapping != null
                && contextValueMapping.size() != 0){
                threadContext.putAll(contextValueMapping);
            }
            
            if(request instanceof HttpServletRequest){
                final HttpServletRequest httpReq = (HttpServletRequest)request;
                
                if(isOutputContextPath){
                    threadContext.put(
                        ThreadContextKey.CONTEXT_PATH,
                        httpReq.getContextPath()
                    );
                }
                if(isOutputServletPath){
                    threadContext.put(
                        ThreadContextKey.SERVLET_PATH,
                        httpReq.getServletPath()
                    );
                }
                final HttpSession session = httpReq.getSession(isNewSession);
                if(isOutputSessionID){
                    if(session != null){
                        threadContext.put(
                            ThreadContextKey.SESSION_ID,
                            session.getId()
                        );
                    }
                }
            }
            
            final Thread thread = Thread.currentThread();
            if(isOutputThreadName){
                threadContext.put(
                    ThreadContextKey.THREAD_NAME,
                    thread.getName()
                );
            }
            if(isOutputThreadGroupName){
                final ThreadGroup threadGroup = thread.getThreadGroup();
                threadContext.put(
                    ThreadContextKey.THREAD_GROUP_NAME,
                    threadGroup.getName()
                );
            }
            if(codeMasterFinder != null){
                final Map<String, Object> codeMasters = codeMasterFinder.getCodeMasters();
                threadContext.put(ThreadContextKey.CODEMASTER, codeMasters);
            }
        }
        try{
            if(callStack != null){
                ((CallStack)callStack.get()).stackIndex++;
            }
            return chain.invokeNext(context);
        }finally{
            if(callStack != null){
                ((CallStack)callStack.get()).stackIndex--;
                if(isClear && ((CallStack)callStack.get()).stackIndex == 0){
                    threadContext.clear();
                }
            }else{
                if(isClear){
                    threadContext.clear();
                }
            }
        }
    }
    
    /**
     * XbhReLXgĂяoX^bNB<p>
     *
     * @author M.Takata
     */
    protected static class CallStack{
        
        /**
         * XbhReLXgC^[Zv^qŌĂяoꂽꍇɁA̓q̐[CfbNXB<p>
         */
        public int stackIndex;
    }
}
