/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.Locale;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link DefaultExceptionHandlerService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see DefaultExceptionHandlerService
 */
public interface DefaultExceptionHandlerServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * OW[iɏo͂ۂ̃W[iL[̃ftHglB<p>
     */
    public static final String DEFAULT_EXCEPTION_JOURNAL_KEY = "Exception";
    
    /**
     * OW[iɏo͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rXݒ肷B<p>
     * ݒ肵Ȃꍇ́AW[io͂ȂB<br>
     *
     * @param name JournalT[rX̃T[rX
     */
    public void setJournalServiceName(ServiceName name);
    
    /**
     * OW[iɏo͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rX擾B<p>
     *
     * @return JournalT[rX̃T[rX
     */
    public ServiceName getJournalServiceName();
    
    /**
     * OW[iɏo͂ۂ̃W[ĩL[ݒ肷B<p>
     * ftHgł́A{@link #DEFAULT_EXCEPTION_JOURNAL_KEY}B<br>
     *
     * @param key ÕW[iL[
     */
    public void setExceptionJournalKey(String key);
    
    /**
     * OW[iɏo͂ۂ̃W[ĩL[擾B<p>
     *
     * @return ÕW[iL[
     */
    public String getExceptionJournalKey();
    
    /**
     * OOɏo͂ۂ̃bZ[WIDݒ肷B<p>
     * ݒ肵Ȃꍇ́AOo͂ȂB<br>
     *
     * @param id OOɏo͂ۂ̃bZ[WID
     */
    public void setLogMessageCode(String id);
    
    /**
     * OOɏo͂ۂ̃bZ[WID擾B<p>
     *
     * @return OOɏo͂ۂ̃bZ[WID
     */
    public String getLogMessageCode();
    
    /**
     * OOɏo͂ۂ̖ߍ݃p[^ݒ肷B<p>
     *
     * @param args OOɏo͂ۂ̖ߍ݃p[^
     */
    public void setLogMessageArguments(String[] args);
    
    /**
     * OOɏo͂ۂ̖ߍ݃p[^擾B<p>
     *
     * @return OOɏo͂ۂ̖ߍ݃p[^
     */
    public String[] getLogMessageArguments();
    
    /**
     * OOɏo͂ۂɁAÕX^bNg[XOɏo͂邩ǂݒ肷B<p>
     * ftHgł́AtrueB<br>
     *
     * @param isOutput ÕX^bNg[XOɏo͂ꍇtrue
     */
    public void setOutputStackTraceLog(boolean isOutput);
    
    /**
     * OOɏo͂ۂɁAÕX^bNg[XOɏo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAÕX^bNg[XOɏo͂
     */
    public boolean isOutputStackTraceLog();
    
    /**
     * Othrow邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isThrow throwꍇ́Atrue
     */
    public void setThrowException(boolean isThrow);
    
    /**
     * Othrow邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Athrow
     */
    public boolean isThrowException();
    
    /**
     * ߂lݒ肷B<p>
     *  
     * @param value ߂l
     */
    public void setReturnValue(Object value);
    
    /**
     * throwOݒ肷B<p>
     * 
     * @param th throwO
     */
    public void setThrowable(Throwable th);
    
    /**
     * throwO擾B<p>
     * 
     * @return throwO
     */
    public Throwable getThrowable();
    
    /**
     * throwONXݒ肷B<p>
     * 
     * @param clazz throwONX
     */
    public void setThrowableClass(Class<?> clazz);
    
    /**
     * throwONX擾B<p>
     * 
     * @return throwONX
     */
    public Class<?> getThrowableClass();
    
    /**
     * throwÕbZ[Wݒ肷B<p>
     * 
     * @param message bZ[W
     */
    public void setThrowableMessage(String message);
    
    /**
     * throwÕbZ[W擾B<p>
     * 
     * @return bZ[W
     */
    public String getThrowableMessage();
    
    /**
     * throwÕbZ[WL[ݒ肷B<p>
     * ݒ肳ꂽbZ[WL[ŁÃT[rXɐݒ肳ꂽ{@link jp.ossc.nimbus.service.message.MessageRecordFactory MessageRecordFactory}烁bZ[W擾B<br>
     * 
     * @param key bZ[WL[
     */
    public void setThrowableMessageKey(String key);
    
    /**
     * throwÕbZ[WL[擾B<p>
     * 
     * @return bZ[WL[
     */
    public String getThrowableMessageKey();
    
    /**
     * throwÕbZ[WP[ݒ肷B<p>
     * ݒ肳ꂽbZ[WP[ŁÃT[rXɐݒ肳ꂽ{@link jp.ossc.nimbus.service.message.MessageRecordFactory MessageRecordFactory}烁bZ[W擾B<br>
     * 
     * @param locale bZ[WP[
     */
    public void setThrowableMessageLocale(Locale locale);
    
    /**
     * throwÕbZ[WP[擾B<p>
     * 
     * @return bZ[WP[
     */
    public Locale getThrowableMessageLocale();
    
    /**
     * throwÕbZ[Wߍ݃p[^ݒ肷B<p>
     * ݒ肳ꂽbZ[Wߍ݃p[^ŁÃT[rXɐݒ肳ꂽ{@link jp.ossc.nimbus.service.message.MessageRecordFactory MessageRecordFactory}烁bZ[W擾B<br>
     * 
     * @param args bZ[Wߍ݃p[^
     */
    public void setThrowableMessageArgs(Object[] args);
    
    /**
     * throwÕbZ[Wߍ݃p[^擾B<p>
     * 
     * @return bZ[Wߍ݃p[^
     */
    public Object[] getThrowableMessageArgs();
    
    /**
     * throwꂽObv邩ǂݒ肷B<p>
     * ftHǵAtrueŃbvB<br>
     * 
     * @param isWrap bvꍇ́Atrue
     */
    public void setWrapThrowable(boolean isWrap);
    
    /**
     * throwꂽObv邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇAbv
     */
    public boolean isWrapThrowable();
}
