/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.net;

import java.util.*;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;

import jp.ossc.nimbus.beans.*;

/**
 * T[o\Pbgt@NgB<p>
 * ̃t@Ng琶T[o\PbǵA{@link #setServerSocketProperty(String, Object)}ŁA\ߐݒ肳ꂽvpeBݒ肳B<br>
 *
 * @author M.Takata
 */
public class ServerSocketFactory extends javax.net.ServerSocketFactory implements java.rmi.server.RMIServerSocketFactory{
    
    protected Map<Property, Object> serverSocketProperties;
    protected Map<String, Object> socketProperties;
    
    public static javax.net.ServerSocketFactory getDefault(){
        return new ServerSocketFactory();
    }
    
    @Override
    public java.net.ServerSocket createServerSocket() throws IOException{
        return applyServerSocketProperties(new ServerSocket());
    }
    
    @Override
    public java.net.ServerSocket createServerSocket(int port) throws IOException{
        return applyServerSocketProperties(new ServerSocket(port));
    }
    
    @Override
    public java.net.ServerSocket createServerSocket(int port, int backlog) throws IOException{
        return applyServerSocketProperties(new ServerSocket(port, backlog));
    }
    
    @Override
    public java.net.ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException{
        return applyServerSocketProperties(new ServerSocket(port, backlog, bindAddr));
    }
    
    /**
     * {@link ServerSocket}ɃvpeBݒ肷B<p>
     *
     * @param props vpeB}bv
     */
    public void setServerSocketProperties(Map<String, Object> props){
        if(props == null || props.size() == 0){
            if(serverSocketProperties != null){
                serverSocketProperties = null;
            }
            return;
        }
        for(Map.Entry<String, Object> entry : props.entrySet()){
            setServerSocketProperty(entry.getKey(), entry.getValue());
        }
    }
    
    /**
     * {@link ServerSocket}ɃvpeBݒ肷B<p>
     *
     * @param name vpeB
     * @param value l
     */
    public void setServerSocketProperty(String name, Object value){
        if(serverSocketProperties == null){
            serverSocketProperties = new LinkedHashMap<Property, Object>();
        }
        final Property prop = PropertyFactory.createProperty(name);
        serverSocketProperties.put(prop, value);
    }
    
    /**
     * {@link ServerSocket}̃vpeB擾B<p>
     *
     * @param name vpeB
     * @return l
     */
    public Object getServerSocketProperty(String name){
        if(serverSocketProperties == null){
            return null;
        }
        for(Map.Entry<Property, Object> entry : serverSocketProperties.entrySet()){
            if(entry.getKey().getPropertyName().equals(name)){
                return entry.getValue();
            }
        }
        return null;
    }
    
    public ServerSocket applyServerSocketProperties(
        ServerSocket serverSocket
    ) throws IOException{
        try{
            if(socketProperties != null && socketProperties.size() != 0){
                for(Map.Entry<String, Object> entry : socketProperties.entrySet()){
                    serverSocket.setSocketProperty(
                        entry.getKey(),
                        entry.getValue()
                    );
                }
            }
            if(serverSocketProperties != null && serverSocketProperties.size() != 0){
                for(Map.Entry<Property, Object> entry : serverSocketProperties.entrySet()){
                    entry.getKey().setProperty(serverSocket, entry.getValue());
                }
            }
        }catch(InvocationTargetException e){
            Throwable target = e.getTargetException();
            if(target instanceof IOException){
                throw (IOException)target;
            }else if(target instanceof RuntimeException){
                throw (RuntimeException)target;
            }else if(target instanceof Error){
                throw (Error)target;
            }else{
                throw new UndeclaredThrowableException(target);
            }
        }catch(NoSuchPropertyException e){
            throw new UndeclaredThrowableException(e);
        }
        return serverSocket;
    }
}