/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.net.*;
import java.io.File;
import java.lang.reflect.Array;

/**
 * Core[eBeBB<p>
 * 
 * @author M.Takata
 */
public class Utility{
    /**
     * VXevpeBQƊJnB<p>
     */
    public static final String SYSTEM_PROPERTY_START = "${";
    /**
     * VXevpeBQƏIB<p>
     */
    public static final String SYSTEM_PROPERTY_END = "}";
    /**
     * VXevpeBQƂ̃ftHglZp[^B<p>
     */
    public static final String SYSTEM_PROPERTY_DEFAULT_VALUE_SEPARATOR = ":";
    
    /**
     * ftHg̃T[rX`t@CURLVXevpeBŎw肷邽߂̃vpeBB<p>
     */
    private static final String DEFAULT_SERVICE_FILE_PROPERTY_KEY
         = "jp.ossc.nimbus.service.url";
    
    /**
     * ftHg̃T[rX`t@CB<p>
     */
    private static final String DEFAULT_SERVICE_FILE
         = "nimbus-service.xml";
    
    private static final String ARRAY_CLASS_SUFFIX = "[]";
    
    /**
     * T[rX`URL̃ftHg̒l擾B<p>
     * ftHgURĽ́Aȉ̏ōsB<br>
     * <ol>
     *   <li>VXevpeBjp.ossc.nimbus.service.urlŎw肳ꂽlA{@link #convertServicePathToURL(String)}URLɕϊl</li>
     *   <li>̃NX̃NXt@C[hꂽNXpXォAnimbus-service.xml{@link ClassLoader#getResource(String)}Ń\[XƂĎ擾URL</li>
     * </ol>
     * 
     * @return ftHgURL
     */
    public static URL getDefaultServiceURL(){
        final String urlString = System.getProperty(
            DEFAULT_SERVICE_FILE_PROPERTY_KEY
        );
        
        URL url = null;
        if(urlString != null){
            try{
                url = convertServicePathToURL(urlString);
            }catch(IllegalArgumentException e){
            }
            if(url != null){
                return url;
            }
        }
        
        url = Utility.class.getClassLoader().getResource(
            DEFAULT_SERVICE_FILE
        );
        return url;
    }
    
    /**
     * w肳ꂽT[rX`̃pXURLɕϊB<p>
     * ȉ̏ŁAϊsB<br>
     * <ol>
     *   <li>w肳ꂽpXnullA܂͋󕶎̏ꍇA{@link #getDefaultServiceURL()}Ŏ擾URL</li>
     *   <li>w肳ꂽpX[Jt@CƂđ݂ꍇA[JpXURLɕϊURL</li>
     *   <li>w肳ꂽpX̃NX[hNX[_̃\[XƂđ݂ꍇAURL</li>
     *   <li>LSĂɓĂ͂܂ȂꍇAOthrowB</li>
     * </ol>
     * 
     * @param path T[rX`̃pX
     * @return T[rX`URL
     * @exception IllegalArgumentException w肳ꂽpathsȏꍇ
     */
    public static URL convertServicePathToURL(String path)
     throws IllegalArgumentException{
        if(path == null || path.length() == 0){
            return getDefaultServiceURL();
        }
        
        URL url = null;
        final File localFile = new File(path);
        if(localFile.exists()){
            if(!localFile.isFile()){
                throw new IllegalArgumentException(
                    "ServicePath must be file : " + localFile
                );
            }
            try{
                url = localFile.toURI().toURL();
            }catch(MalformedURLException e){
                // ̗O͔Ȃ͂
            }
        }else{
            final ClassLoader classLoader
                 = Thread.currentThread().getContextClassLoader();
            final URL resource = classLoader.getResource(path);
            if(resource != null){
                url = resource;
            }
        }
        if(url == null){
            throw new IllegalArgumentException(
                "ServicePath not found : " + path
            );
        }
        return url;
    }
    
    /**
     * w肳ꂽ̃vpeBQƕVXevpeB̒lɒuB<p>
     *
     * @param str 
     * @param applyDefault vpeBQƕ̃ftHglKp邩ǂ
     * @return vpeBQƕVXevpeB̒lɒu
     */
    public static String replaceSystemProperty(String str, boolean applyDefault){
        String result = str;
        if(result == null){
            return null;
        }
        final int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if(startIndex == -1){
            return result;
        }
        final int endIndex = result.indexOf(SYSTEM_PROPERTY_END);
        if(endIndex == -1 || startIndex > endIndex){
            return result;
        }
        String propStr = result.substring(
            startIndex + SYSTEM_PROPERTY_START.length(),
            endIndex
        );
        final int defaultValueIndex = propStr.indexOf(SYSTEM_PROPERTY_DEFAULT_VALUE_SEPARATOR);
        String defaultValue = null;
        if(defaultValueIndex != -1){
            propStr = propStr.substring(0, defaultValueIndex);
            defaultValue = propStr.substring(defaultValueIndex + 1);
        }
        String prop = applyDefault ? defaultValue : null;
        if(propStr != null && propStr.length() != 0){
            prop = System.getProperty(propStr);
        }
        if(prop == null){
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length())
             + replaceSystemProperty(
                result.substring(endIndex + SYSTEM_PROPERTY_END.length()),
                applyDefault
             );
        }else{
            result = result.substring(0, startIndex) + prop
                 + result.substring(endIndex + SYSTEM_PROPERTY_END.length());
        }
        if(result.indexOf(SYSTEM_PROPERTY_START) != -1){
            return replaceSystemProperty(result, applyDefault);
        }
        return result;
    }
    
    /**
     * w肳ꂽ̃vpeBQƕ}l[WvpeB̒lɒuB<p>
     *
     * @param manager T[rX}l[W
     * @param str 
     * @param applyDefault vpeBQƕ̃ftHglKp邩ǂ
     * @return vpeBQƕ}l[WvpeB̒lɒu
     */
    public static String replaceManagerProperty(
        ServiceManager manager,
        String str,
        boolean applyDefault
    ){
        String result = str;
        if(result == null){
            return null;
        }
        final int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if(startIndex == -1){
            return result;
        }
        final int endIndex = result.indexOf(SYSTEM_PROPERTY_END);
        if(endIndex == -1 || startIndex > endIndex){
            return result;
        }
        String propStr = result.substring(
            startIndex + SYSTEM_PROPERTY_START.length(),
            endIndex
        );
        final int defaultValueIndex = propStr.indexOf(SYSTEM_PROPERTY_DEFAULT_VALUE_SEPARATOR);
        String defaultValue = null;
        if(defaultValueIndex != -1){
            propStr = propStr.substring(0, defaultValueIndex);
            defaultValue = propStr.substring(defaultValueIndex + 1);
        }
        String prop = applyDefault ? defaultValue : null;
        if(propStr != null && propStr.length() != 0){
            prop = manager.getProperty(propStr);
        }
        if(prop == null){
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length())
             + replaceManagerProperty(
                manager,
                result.substring(endIndex + SYSTEM_PROPERTY_END.length()),
                applyDefault
             );
        }else{
            result = result.substring(0, startIndex) + prop
                 + result.substring(endIndex + SYSTEM_PROPERTY_END.length());
        }
        if(result.indexOf(SYSTEM_PROPERTY_START) != -1){
            return replaceManagerProperty(manager, result, applyDefault);
        }
        return result;
    }
    
    /**
     * w肳ꂽ̃vpeBQƕ}l[WvpeB̒lɒuB<p>
     *
     * @param ManagerMetaData }l[W^f[^
     * @param str 
     * @param applyDefault vpeBQƕ̃ftHglKp邩ǂ
     * @return vpeBQƕ}l[WvpeB̒lɒu
     */
    public static String replaceManagerProperty(
        ManagerMetaData manager,
        String str,
        boolean applyDefault
    ){
        String result = str;
        if(result == null){
            return null;
        }
        final int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if(startIndex == -1){
            return result;
        }
        final int endIndex = result.indexOf(SYSTEM_PROPERTY_END);
        if(endIndex == -1 || startIndex > endIndex){
            return result;
        }
        String propStr = result.substring(
            startIndex + SYSTEM_PROPERTY_START.length(),
            endIndex
        );
        final int defaultValueIndex = propStr.indexOf(SYSTEM_PROPERTY_DEFAULT_VALUE_SEPARATOR);
        String defaultValue = null;
        if(defaultValueIndex != -1){
            propStr = propStr.substring(0, defaultValueIndex);
            defaultValue = propStr.substring(defaultValueIndex + 1);
        }
        String prop = applyDefault? defaultValue : null;
        if(propStr != null && propStr.length() != 0){
            prop = manager.getProperty(propStr);
        }
        if(prop == null){
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length())
             + replaceManagerProperty(
                manager,
                result.substring(endIndex + SYSTEM_PROPERTY_END.length()),
                applyDefault
             );
        }else{
            result = result.substring(0, startIndex) + prop
                 + result.substring(endIndex + SYSTEM_PROPERTY_END.length());
        }
        if(result.indexOf(SYSTEM_PROPERTY_START) != -1){
            return replaceManagerProperty(manager, result, applyDefault);
        }
        return result;
    }
    
    /**
     * w肳ꂽ̃vpeBQƕT[rX[h\vpeB̒lɒuB<p>
     *
     * @param config T[rX[_RtBO
     * @param str 
     * @param applyDefault vpeBQƕ̃ftHglKp邩ǂ
     * @return vpeBQƕT[rX[h\vpeB̒lɒu
     */
    public static String replaceServiceLoderConfig(
        ServiceLoaderConfig config,
        String str,
        boolean applyDefault
    ){
        if(config == null){
            return str;
        }
        String result = str;
        if(result == null){
            return null;
        }
        final int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if(startIndex == -1){
            return result;
        }
        final int endIndex = result.indexOf(SYSTEM_PROPERTY_END);
        if(endIndex == -1 || startIndex > endIndex){
            return result;
        }
        String propStr = result.substring(
            startIndex + SYSTEM_PROPERTY_START.length(),
            endIndex
        );
        final int defaultValueIndex = propStr.indexOf(SYSTEM_PROPERTY_DEFAULT_VALUE_SEPARATOR);
        String defaultValue = null;
        if(defaultValueIndex != -1){
            propStr = propStr.substring(0, defaultValueIndex);
            defaultValue = propStr.substring(defaultValueIndex + 1);
        }
        String prop = applyDefault ? defaultValue : null;
        if(propStr != null && propStr.length() != 0){
            prop = config.getProperty(propStr);
        }
        if(prop == null){
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length())
             + replaceServiceLoderConfig(
                 config,
                 result.substring(endIndex + SYSTEM_PROPERTY_END.length()),
                 applyDefault
             );
        }else{
            result = result.substring(0, startIndex) + prop
                 + result.substring(endIndex + SYSTEM_PROPERTY_END.length());
        }
        if(result.indexOf(SYSTEM_PROPERTY_START) != -1){
            return replaceServiceLoderConfig(config, result, applyDefault);
        }
        return result;
    }
    
    /**
     * w肳ꂽ̃vpeBQƕT[ovpeB̒lɒuB<p>
     *
     * @param str 
     * @param applyDefault vpeBQƕ̃ftHglKp邩ǂ
     * @return vpeBQƕT[ovpeB̒lɒu
     */
    public static String replaceServerProperty(String str, boolean applyDefault){
        String result = str;
        if(result == null){
            return null;
        }
        final int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if(startIndex == -1){
            return result;
        }
        final int endIndex = result.indexOf(SYSTEM_PROPERTY_END);
        if(endIndex == -1 || startIndex > endIndex){
            return result;
        }
        String propStr = result.substring(
            startIndex + SYSTEM_PROPERTY_START.length(),
            endIndex
        );
        final int defaultValueIndex = propStr.indexOf(SYSTEM_PROPERTY_DEFAULT_VALUE_SEPARATOR);
        String defaultValue = null;
        if(defaultValueIndex != -1){
            propStr = propStr.substring(0, defaultValueIndex);
            defaultValue = propStr.substring(defaultValueIndex + 1);
        }
        String prop = applyDefault ? defaultValue : null;
        if(propStr != null && propStr.length() != 0){
            prop = ServiceManagerFactory.getProperty(propStr);
        }
        if(prop == null){
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length())
             + replaceServerProperty(
                result.substring(endIndex + SYSTEM_PROPERTY_END.length()),
                applyDefault
             );
        }else{
            result = result.substring(0, startIndex) + prop
                 + result.substring(endIndex + SYSTEM_PROPERTY_END.length());
        }
        if(result.indexOf(SYSTEM_PROPERTY_START) != -1){
            return replaceServerProperty(result, applyDefault);
        }
        return result;
    }
    
    /**
     * ϐvpeB擾B<p>
     * {@link System#getProperty(String)} &gt; {@link ServiceLoaderConfig#getProperty(String)} &gt; {@link ServiceManager#getProperty(String)} &gt; {@link ServiceManagerFactory#getProperty(String)}
     *
     * @param name vpeB
     * @param config ServiceLoaderConfig
     * @param manager ServiceManager
     * @param metaData ^f[^
     */
    public static String getProperty(
        String name,
        ServiceLoaderConfig config,
        ServiceManager manager,
        MetaData metaData
    ){
        String prop = System.getProperty(name);
        if(prop != null){
            return prop;
        }
        if(config != null){
            prop = config.getProperty(name);
            if(prop != null){
                return prop;
            }
        }
        if(manager != null){
            prop = manager.getProperty(name);
            if(prop != null){
                return prop;
            }
        }
        NimbusMetaData serverData = null;
        if(metaData != null){
            ManagerMetaData mngData = null;
            MetaData parent = metaData;
            do{
                if(parent == null){
                    break;
                }else if(mngData == null
                     && parent instanceof ManagerMetaData){
                    mngData = (ManagerMetaData)parent;
                }else if(serverData == null
                     && parent instanceof NimbusMetaData){
                    serverData = (NimbusMetaData)parent;
                    break;
                }
            }while((parent = parent.getParent()) != null);
            if(mngData != null){
                prop = mngData.getProperty(name);
                if(prop != null){
                    return prop;
                }
            }
        }
        prop = ServiceManagerFactory.getProperty(name);
        if(prop != null){
            return prop;
        }
        if(serverData != null){
            prop = serverData.getProperty(name);
            if(prop != null){
                return prop;
            }
        }
        return prop;
    }
    
    public static <T> Class<T> convertStringToClass(String typeStr)
     throws ClassNotFoundException{
        return Utility.<T>convertStringToClass(typeStr, false);
    }
    
    /**
     * 񂩂NXɕϊB<p>
     *
     * @param typeStr SCNX
     * @param isWrapp v~eBu^̃bpɕϊ邩̃tO
     */
    @SuppressWarnings("unchecked")
    public static <T> Class<T> convertStringToClass(
        String typeStr,
        boolean isWrapp
    ) throws ClassNotFoundException{
        Class<?> type = null;
        if(typeStr != null){
            if(Byte.TYPE.getName().equals(typeStr)){
                type = isWrapp ? Byte.class : Byte.TYPE;
            }else if(Character.TYPE.getName().equals(typeStr)){
                type = isWrapp ? Character.class : Character.TYPE;
            }else if(Short.TYPE.getName().equals(typeStr)){
                type = isWrapp ? Short.class : Short.TYPE;
            }else if(Integer.TYPE.getName().equals(typeStr)){
                type = isWrapp ? Integer.class : Integer.TYPE;
            }else if(Long.TYPE.getName().equals(typeStr)){
                type = isWrapp ? Long.class : Long.TYPE;
            }else if(Float.TYPE.getName().equals(typeStr)){
                type = isWrapp ? Float.class : Float.TYPE;
            }else if(Double.TYPE.getName().equals(typeStr)){
                type = isWrapp ? Double.class : Double.TYPE;
            }else if(Boolean.TYPE.getName().equals(typeStr)){
                type = isWrapp ? Boolean.class : Boolean.TYPE;
            }else{
                if(typeStr.endsWith(ARRAY_CLASS_SUFFIX)
                    && typeStr.length() > 2){
                    final Class<?> elementType = convertStringToClass(
                        typeStr.substring(0, typeStr.length() - 2),
                        false
                    );
                    type = Array.newInstance(elementType, 0).getClass();
                }else{
                    type = Class.forName(
                        typeStr,
                        true,
                        NimbusClassLoader.getInstance()
                    );
                }
            }
        }
        return (Class<T>)type;
    }
}
