/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import java.net.*;
import java.util.*;
import org.xml.sax.*;

/**
 * NimbuspEntityResolverB<p>
 * OGeBeB̌Jʎq"-//Nimbus//DTD Nimbus 2.0//JA"ɑ΂āA<a href="nimbus-service_2_0.xsd">"jp/ossc/nimbus/core/nimbus-service_2_0.xsd"</a><br>
 * }bsOEntityResolverłB
 *
 * @author M.Takata
 */
public class NimbusEntityResolver implements EntityResolver{
    
    private static Map<String, String> entities = Collections.<String, String>synchronizedMap(new HashMap<String, String>());
    
    static{
        registerEntity(
            "-//Nimbus//DTD Nimbus 2.0//JA",
            "jp/ossc/nimbus/core/nimbus-service_2_0.dtd"
        );
    }
    
    /**
     * w肵OGeBeB̌Jʎqɑ΂āAGeBeB̃\[Xo^B<p>
     *
     * @param publicId OGeBeB̌Jʎq
     * @param resource GeBeB̃\[X
     */
    public static void registerEntity(String publicId, String resource){
        entities.put(publicId, resource);
    }
    
    /**
     * w肵OGeBeB̌Jʎq̓o^B<p>
     *
     * @param publicId OGeBeB̌Jʎq
     */
    public static void unregisterEntity(String publicId){
        entities.remove(publicId);
    }
    
    /**
     * w肵OGeBeB̌Jʎqo^Ă邩ׂB<p>
     *
     * @param publicId OGeBeB̌Jʎq
     * @return o^ĂꍇAtrue
     */
    public static boolean isRegisteredEntity(String publicId){
        return entities.containsKey(publicId);
    }
    
    /**
     * AvP[VOGeBeBł悤ɂB<p>
     * w肳ꂽJʎq{@link #registerEntity(String, String)}œo^ꂽJʎqłꍇ́Ao^ꂽ\[XŃNXpXォGeBeBt@CBłȂꍇ́AVXeʎqŎw肳ꂽURLŃGeBeBt@CB<br>
     * 
     * @param publicId QƂOGeBeB̌JʎqB񋟂Ȃꍇ null
     * @param systemId QƂOGeBeB̃VXeʎq
     */
    @Override
    public InputSource resolveEntity(String publicId, String systemId){
        if(publicId == null || !entities.containsKey(publicId)){
            return resolveEntity(systemId);
        }
        final String entity = entities.get(publicId);
        if(entity == null){
            return resolveEntity(systemId);
        }
        final InputStream entityStream = loadClasspathResource(entity);
        if(entityStream == null){
            return resolveEntity(systemId);
        }
        final InputSource inputSource = new InputSource(entityStream);
        return inputSource;
    }
    
    private InputSource resolveEntity(String systemId){
        if(systemId == null){
            return null;
        }
        final String entity = entities.get(systemId);
        InputStream entityStream = null;
        if(entity != null){
            entityStream = loadClasspathResource(entity);
        }
        if(entityStream == null){
            try{
                final URL url = new URL(systemId);
                entityStream = url.openStream();
            }catch(MalformedURLException e){
                return null;
            }catch(IOException e){
                return null;
            }
        }
        return new InputSource(entityStream);
    }
    
    private InputStream loadClasspathResource(String resource){
        final ClassLoader loader
             = Thread.currentThread().getContextClassLoader();
        return loader.getResourceAsStream(resource);
    }
}
