/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import org.w3c.dom.*;


/**
 * &lt;default-log&gt;vf^f[^B<p>
 * T[rX`t@C&lt;nimbus&gt;̎qvf&lt;default-log&gt;vfɋLqꂽei[郁^f[^ReiłB<p>
 *
 * @author M.Takata
 * @see <a href="nimbus-service_2_0.xsd">T[rX`t@CXL[}`</a>
 */
public class DefaultLogMetaData extends MetaData implements Serializable{
    
    private static final long serialVersionUID = 154759319695696184L;
    
    /**
     * &lt;log&gt;vf̗vfB<p>
     */
    public static final String DEFAULT_LOG_TAG_NAME = "default-log";
    
    /**
     * &lt;debug&gt;vf̗vfB<p>
     */
    private static final String DEBUG_TAG_NAME = "debug";
    
    /**
     * &lt;information&gt;vf̗vfB<p>
     */
    private static final String INFORMATION_TAG_NAME = "information";
    
    /**
     * &lt;warning&gt;vf̗vfB<p>
     */
    private static final String WARNING_TAG_NAME = "warning";
    
    /**
     * &lt;error&gt;vf̗vfB<p>
     */
    private static final String ERROR_TAG_NAME = "error";
    
    /**
     * &lt;fatal&gt;vf̗vfB<p>
     */
    private static final String FATAL_TAG_NAME = "fatal";
    
    /**
     * OJeSvfoutput̑B<p>
     */
    private static final String OUTPUT_ATTRIBUTE_NAME = "output";
    
    /**
     * &lt;debug&gt;vf̃^f[^B<p>
     *
     * @see #getDebug()
     */
    private LogCategoryMetaData debug;
    
    /**
     * &lt;information&gt;vf̃^f[^B<p>
     *
     * @see #getInformation()
     */
    private LogCategoryMetaData information;
    
    /**
     * &lt;warning&gt;vf̃^f[^B<p>
     *
     * @see #getWarning()
     */
    private LogCategoryMetaData warning;
    
    /**
     * &lt;error&gt;vf̃^f[^B<p>
     *
     * @see #getError()
     */
    private LogCategoryMetaData error;
    
    /**
     * &lt;fatal&gt;vf̃^f[^B<p>
     *
     * @see #getFatal()
     */
    private LogCategoryMetaData fatal;
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * DefaultLogMetaData̐evf́A&lt;nimbus&gt;vf\ServerMetaDatałB<br>
     * 
     * @param parent evf̃^f[^
     * @see NimbusMetaData
     */
    public DefaultLogMetaData(MetaData parent){
        super(parent);
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf&lt;debug&gt;vfŎw肳ꂽOJeS̃^f[^擾B<p>
     * &lt;debug&gt;vfw肳ĂȂꍇ́AnullԂB<br>
     *
     * @return &lt;debug&gt;vfŎw肳ꂽOJeS̃^f[^
     */
    public LogCategoryMetaData getDebug(){
        return debug;
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf&lt;debug&gt;vfŎw肳ꂽOJeS̃^f[^ݒ肷B<p>
     *
     * @param data &lt;debug&gt;vfŎw肳ꂽOJeS̃^f[^
     */
    public void setDebug(LogCategoryMetaData data){
        debug = data;
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf&lt;information&gt;vfŎw肳ꂽOJeS̃^f[^擾B<p>
     * &lt;information&gt;vfw肳ĂȂꍇ́AnullԂB<br>
     *
     * @return &lt;information&gt;vfŎw肳ꂽOJeS̃^f[^
     */
    public LogCategoryMetaData getInformation(){
        return information;
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf&lt;information&gt;vfŎw肳ꂽOJeS̃^f[^ݒ肷B<p>
     *
     * @param data &lt;information&gt;vfŎw肳ꂽOJeS̃^f[^
     */
    public void setInformation(LogCategoryMetaData data){
        information = data;
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf&lt;warning&gt;vfŎw肳ꂽOJeS̃^f[^擾B<p>
     * &lt;warning&gt;vfw肳ĂȂꍇ́AnullԂB<br>
     *
     * @return &lt;warning&gt;vfŎw肳ꂽOJeS̃^f[^
     */
    public LogCategoryMetaData getWarning(){
        return warning;
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf&lt;warning&gt;vfŎw肳ꂽOJeS̃^f[^ݒ肷B<p>
     *
     * @return &lt;warning&gt;vfŎw肳ꂽOJeS̃^f[^
     */
    public void setWarning(LogCategoryMetaData data){
        warning = data;
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf&lt;error&gt;vfŎw肳ꂽOJeS̃^f[^擾B<p>
     * &lt;error&gt;vfw肳ĂȂꍇ́AnullԂB<br>
     *
     * @return &lt;error&gt;vfŎw肳ꂽOJeS̃^f[^
     */
    public LogCategoryMetaData getError(){
        return error;
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf&lt;error&gt;vfŎw肳ꂽOJeS̃^f[^ݒ肷B<p>
     *
     * @param data &lt;error&gt;vfŎw肳ꂽOJeS̃^f[^
     */
    public void setError(LogCategoryMetaData data){
        error = data;
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf&lt;fatal&gt;vfŎw肳ꂽOJeS̃^f[^擾B<p>
     * &lt;fatal&gt;vfw肳ĂȂꍇ́AnullԂB<br>
     *
     * @return &lt;fatal&gt;vfŎw肳ꂽOJeS̃^f[^
     */
    public LogCategoryMetaData getFatal(){
        return fatal;
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf&lt;fatal&gt;vfŎw肳ꂽOJeS̃^f[^ݒ肷B<p>
     *
     * @param data &lt;fatal&gt;vfŎw肳ꂽOJeS̃^f[^
     */
    public void setFatal(LogCategoryMetaData data){
        fatal = data;
    }
    
    /**
     * &lt;log&gt;vfElementp[XāAg̏sB<p>
     *
     * @param element &lt;log&gt;vfElement
     * @exception DeploymentException &lt;log&gt;vf̉͂Ɏsꍇ
     */
    @Override
    public void importXML(Element element) throws DeploymentException{
        super.importXML(element);
        
        if(!element.getTagName().equals(DEFAULT_LOG_TAG_NAME)){
            throw new DeploymentException(
                "Tag must be " + DEFAULT_LOG_TAG_NAME + " : "
                 + element.getTagName()
            );
        }
        final Element debugElement
             = getOptionalChild(element, DEBUG_TAG_NAME);
        if(debugElement != null){
            debug = new LogCategoryMetaData(this);
            debug.importXML(debugElement);
        }
        final Element informationElement
             = getOptionalChild(element, INFORMATION_TAG_NAME);
        if(informationElement != null){
            information = new LogCategoryMetaData(this);
            information.importXML(informationElement);
        }
        final Element warningElement
             = getOptionalChild(element, WARNING_TAG_NAME);
        if(warningElement != null){
            warning = new LogCategoryMetaData(this);
            warning.importXML(warningElement);
        }
        final Element errorElement
             = getOptionalChild(element, ERROR_TAG_NAME);
        if(errorElement != null){
            error = new LogCategoryMetaData(this);
            error.importXML(errorElement);
        }
        final Element fatalElement
             = getOptionalChild(element, FATAL_TAG_NAME);
        if(fatalElement != null){
            fatal = new LogCategoryMetaData(this);
            fatal.importXML(fatalElement);
        }
    }
    
    @Override
    public StringBuilder toXML(StringBuilder buf){
        appendComment(buf);
        buf.append('<').append(DEFAULT_LOG_TAG_NAME).append('>');
        boolean isAppend = false;
        if(debug != null){
            isAppend = true;
            buf.append(LINE_SEPARATOR);
            buf.append(
                addIndent(debug.toXML(new StringBuilder()))
            );
        }
        if(information != null){
            isAppend = true;
            buf.append(LINE_SEPARATOR);
            buf.append(
                addIndent(information.toXML(new StringBuilder()))
            );
        }
        if(warning != null){
            isAppend = true;
            buf.append(LINE_SEPARATOR);
            buf.append(
                addIndent(warning.toXML(new StringBuilder()))
            );
        }
        if(error != null){
            isAppend = true;
            buf.append(LINE_SEPARATOR);
            buf.append(
                addIndent(error.toXML(new StringBuilder()))
            );
        }
        if(fatal != null){
            isAppend = true;
            buf.append(LINE_SEPARATOR);
            buf.append(
                addIndent(fatal.toXML(new StringBuilder()))
            );
        }
        if(isAppend){
            buf.append(LINE_SEPARATOR);
        }
        buf.append("</").append(DEFAULT_LOG_TAG_NAME).append('>');
        return buf;
    }
    
    /**
     * &lt;debug&gt;vf𐶐B<p>
     *
     * @return &lt;debug&gt;vf̃^f[^
     */
    public LogCategoryMetaData createDebugLogCategoryMetaData(){
        return new LogCategoryMetaData(this, DEBUG_TAG_NAME);
    }
    
    /**
     * &lt;information&gt;vf𐶐B<p>
     *
     * @return &lt;information&gt;vf̃^f[^
     */
    public LogCategoryMetaData createInformationLogCategoryMetaData(){
        return new LogCategoryMetaData(this, INFORMATION_TAG_NAME);
    }
    
    /**
     * &lt;warning&gt;vf𐶐B<p>
     *
     * @return &lt;warning&gt;vf̃^f[^
     */
    public LogCategoryMetaData createWarningLogCategoryMetaData(){
        return new LogCategoryMetaData(this, WARNING_TAG_NAME);
    }
    
    /**
     * &lt;error&gt;vf𐶐B<p>
     *
     * @return &lt;error&gt;vf̃^f[^
     */
    public LogCategoryMetaData createErrorLogCategoryMetaData(){
        return new LogCategoryMetaData(this, ERROR_TAG_NAME);
    }
    
    /**
     * &lt;fatal&gt;vf𐶐B<p>
     *
     * @return &lt;fatal&gt;vf̃^f[^
     */
    public LogCategoryMetaData createFatalLogCategoryMetaData(){
        return new LogCategoryMetaData(this, FATAL_TAG_NAME);
    }
    
    /**
     * &lt;default-log&gt;vf̎qvf̃OJeS̃^f[^B<p>
     * T[rX`t@C&lt;default-log&gt;vf̎qvf&lt;debug&gt;A&lt;information&gt;A&lt;warning&gt;A&lt;error&gt;A&lt;fatal&gt;vfɋLqꂽei[郁^f[^Rei̊NXłB<p>
     *
     * @author M.Takata
     * @see <a href="nimbus-service_1_0.dtd">T[rX`t@CDTD</a>
     */
    public static class LogCategoryMetaData
     extends MetaData implements Serializable{
        
        private static final long serialVersionUID = 7428020116195385080L;
        
        /**
         * ̗vf̖OB<p>
         */
        private String tagName;
        
        /**
         * output̒lB<p>
         * YJeS̃Oo͂邩ǂtOB<br>
         *
         * @see #isOutput()
         */
        private boolean isOutput;
        
        /**
         * evf̃^f[^CX^X𐶐B<p>
         * LogCategoryMetaData̐evf́A&lt;log&gt;vf\DefaultLogMetaDatałB<br>
         * 
         * @param parent evf̃^f[^
         * @see DefaultLogMetaData
         */
        public LogCategoryMetaData(MetaData parent){
            super(parent);
        }
        
        /**
         * evf̃^f[^CX^X𐶐B<p>
         * LogCategoryMetaData̐evf́A&lt;log&gt;vf\DefaultLogMetaDatałB<br>
         * 
         * @param parent evf̃^f[^
         * @param name ̗vf̖O
         * @see DefaultLogMetaData
         */
        public LogCategoryMetaData(MetaData parent, String name){
            super(parent);
            tagName = name;
        }
        
        /**
         * OJeSvfoutput̒l擾B<p>
         * outputȗĂꍇ́AfalseԂB<br>
         * 
         * @return OJeSvfoutput̒l
         */
        public boolean isOutput(){
            return isOutput;
        }
        
        /**
         * OJeSvfoutput̒lݒ肷B<p>
         * 
         * @param isOutput OJeSvfoutput̒l
         */
        public void setOutput(boolean isOutput){
            this.isOutput = isOutput;
        }
        
        /**
         * OJeSvfElementp[XāAg̏sB<p>
         *
         * @param element OJeSvfElement
         * @exception DeploymentException OJeSvf̉͂Ɏsꍇ
         */
        @Override
        public void importXML(Element element) throws DeploymentException{
            super.importXML(element);
            if(tagName == null){
                tagName = element.getTagName();
            }else if(!element.getTagName().equals(tagName)){
                throw new DeploymentException(
                    "Tag must be " + tagName + " : "
                     + element.getTagName()
                );
            }
            final String output = getOptionalAttribute(
                element,
                OUTPUT_ATTRIBUTE_NAME
            );
            if(output != null){
                isOutput = Boolean.valueOf(output).booleanValue();
            }
        }
        
        @Override
        public StringBuilder toXML(StringBuilder buf){
            appendComment(buf);
            buf.append('<').append(tagName);
            buf.append(' ').append(OUTPUT_ATTRIBUTE_NAME)
                .append("=\"").append(isOutput).append("\"");
            buf.append("/>");
            return buf;
        }
    }
}
