/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import java.util.*;
import java.beans.PropertyEditor;
import java.io.Serializable;

import jp.ossc.nimbus.beans.*;
import jp.ossc.nimbus.core.*;

/**
 * {@link PropertyEditor}Ro[^B<p>
 * 
 * @author M.Takata
 */
public class PropertyEditorConverter implements FormatConverter, Serializable{
    
    private static final long serialVersionUID = 1236107411843329600L;
    
    /**
     * ϊʁB<p>
     */
    protected int convertType;
    
    /**
     * tH[}bgB<p>
     */
    protected Class<?> type;
    
    /**
     * {@link PropertyEditor}̃}bvB<p>
     */
    protected Map<Class<?>, Class<? extends PropertyEditor>> editorMap;
    
    /**
     * java.lang.String^IuWFNgϊsRo[^𐶐B<p>
     */
    public PropertyEditorConverter(){
        this(OBJECT_TO_STRING, String.class.getName());
    }
    
    /**
     * w肳ꂽϊʂ̃Ro[^𐶐B<p>
     *
     * @param type ϊ
     * @param className ϊIuWFNg̊SCNX
     * @see #OBJECT_TO_STRING
     * @see #STRING_TO_OBJECT
     */
    public PropertyEditorConverter(int type, String className){
        convertType = type;
        setFormat(className);
    }
    
    /**
     * ϊʂݒ肷B<p>
     *
     * @param type ϊ
     * @see #getConvertType()
     * @see #OBJECT_TO_STRING
     * @see #STRING_TO_OBJECT
     */
    public void setConvertType(int type){
        convertType = type;
    }
    
    /**
     * ϊʂ擾B<p>
     *
     * @return ϊ
     * @see #setConvertType(int)
     */
    public int getConvertType(){
        return convertType;
    }
    
    /**
     * ϊIuWFNg̃NXݒ肷B<p>
     *
     * @param className ϊIuWFNg̊SCNX
     */
    @Override
    public void setFormat(String className){
        try{
            type = Utility.convertStringToClass(className);
        }catch(ClassNotFoundException e){
            throw new IllegalArgumentException(e.getMessage());
        }
    }
    
    /**
     * ϊIuWFNg̃NX擾B<p>
     *
     * @return ϊIuWFNg̊SCNX
     * @see #setFormat(String)
     */
    public String getFormat(){
        return type == null ? java.lang.String.class.getName() : type.getName();
    }
    
    /**
     * {@link PropertyEditor}o^B<p>
     *
     * @param clazz ҏW^
     * @param editorClass PropertyEditoř^
     */
    public void registerEditor(Class<?> clazz, Class<? extends PropertyEditor> editorClass){
        if(editorMap == null){
            editorMap = Collections.synchronizedMap(new HashMap<Class<?>, Class<? extends PropertyEditor>>());
        }
        editorMap.put(clazz, editorClass);
    }
    
    /**
     * {@link PropertyEditor}B<p>
     * 
     * @param clazz ҏW^
     * @return PropertyEditor
     */
    protected PropertyEditor findEditor(Class<?> clazz){
        final Class<? extends PropertyEditor> editorClass = editorMap == null ? null : editorMap.get(clazz);
        if(editorClass != null){
            try{
                return editorClass.newInstance();
            }catch(ClassCastException e){
            }catch(InstantiationException e){
            }catch(IllegalAccessException e){
            }
        }
        return NimbusPropertyEditorManager.findEditor(clazz);
    }
    
    /**
     * w肳ꂽIuWFNgϊB<p>
     *
     * @param obj ϊΏۂ̃IuWFNg
     * @return ϊ̃IuWFNg
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public Object convert(Object obj) throws ConvertException{
        if(obj == null){
            return null;
        }
        final Class<?> inType = obj.getClass();
        PropertyEditor editor = null;
        switch(convertType){
        case STRING_TO_OBJECT:
            String str = null;
            if(obj instanceof String){
                str = (String)obj;
            }else{
                str = obj.toString();
            }
            editor = findEditor(type);
            if(editor == null){
                throw new ConvertException(
                    "PropertyEditor not found. type=" + type.getName()
                );
            }
            try{
                editor.setAsText(str);
                return editor.getValue();
            }catch(Exception e){
                throw new ConvertException(e);
            }
        case OBJECT_TO_STRING:
            if(obj instanceof String){
                return obj;
            }
            editor = findEditor(inType);
            if(editor == null){
                throw new ConvertException(
                    "PropertyEditor not found. type=" + inType.getName()
                );
            }
            try{
                editor.setValue(obj);
                return editor.getAsText();
            }catch(Exception e){
                throw new ConvertException(e);
            }
        default:
            throw new ConvertException(
                "Invalid convert type : " + convertType
            );
        }
    }
}
