/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.Date;
import java.io.File;

/**
 * WzMobNAbvǗB<p>
 * 
 * @author M.Takata
 */
public interface ConcentrateBackupManager{
    
    /**
     * w肳ꂽt@CobNAbvB<br>
     *
     * @param group obNAbvO[v
     * @param date obNAbvt
     * @param key obNAbvL[
     * @param files obNAbvΏۂ̃t@Cz
     * @param compressed obNAbvΏۂ̊et@CkĂ邩ǂtOz
     * @return obNAbv
     * @exception ConcentrateBackupException obNAbvɈُ킪ꍇ
     */
    public Object backup(String group, Date date, String key, File[] files, boolean[] compressed) throws ConcentrateBackupException;
    
    /**
     * obNAbvSč폜B<p>
     *
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean clear() throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvO[ṽobNAbvSč폜B<p>
     *
     * @param group obNAbvO[v
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean remove(String group) throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvt̃obNAbvSč폜B<p>
     *
     * @param date obNAbvt
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean remove(Date date) throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvO[vobNAbvt̃obNAbvSč폜B<p>
     *
     * @param group obNAbvO[v
     * @param date obNAbvt
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean remove(String group, Date date) throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvt܂ł̃obNAbvSč폜B<p>
     *
     * @param date obNAbvt
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean removeTo(Date date) throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvO[vobNAbvt܂ł̃obNAbvSč폜B<p>
     *
     * @param group obNAbvO[v
     * @param date obNAbvt
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean removeTo(String group, Date date) throws ConcentrateBackupException;
    
    /**
     * w肵obNAbvO[vAobNAbvtAobNAbvL[̃obNAbvSč폜B<p>
     *
     * @param group obNAbvO[v
     * @param date obNAbvt
     * @param key obNAbvL[
     * @return 폜łꍇ́Atrue
     * @exception ConcentrateBackupException obNAbv폜Ɉُ킪ꍇ
     */
    public boolean remove(String group, Date date, String key) throws ConcentrateBackupException;
}
