/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish.local;

import java.util.Set;
import java.util.Map;

import jp.ossc.nimbus.core.*;

/**
 * {@link ConnectionFactoryService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface ConnectionFactoryServiceMBean extends ServiceBaseMBean{
    
    public static final String MSG_ID_SEND_ERROR            = "PCFT_00001";
    public static final String MSG_ID_SEND_ERROR_RETRY_OVER = "PCFT_00002";
    public static final String MSG_ID_SERVER_CLOSE          = "PCFT_00008";
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgJNDIݒ肷B<p>
     * ftHǵA{@link jp.ossc.nimbus.service.publish.ClientConnectionFactory#DEFAULT_JNDI_NAME}B<br>
     *
     * @param name JNDI
     */
    public void setJndiName(String name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgJNDI擾B<p>
     *
     * @return JNDI
     */
    public String getJndiName();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgoCh{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name RepositoryT[rX̃T[rX
     */
    public void setJndiRepositoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgoCh{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rX擾B<p>
     * 
     * @return RepositoryT[rX̃T[rX
     */
    public ServiceName getJndiRepositoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgRMIʐM|[gԍݒ肷B<p>
     *
     * @param port |[gԍ
     */
    public void setRMIPort(int port);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnectionFactory ClientConnectionFactory}[gIuWFNgRMIʐM|[gԍ擾B<p>
     *
     * @return |[gԍ
     */
    public int getRMIPort();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnection ClientConnection}ID𐶐{@link jp.ossc.nimbus.service.sequnce.Sequence Sequence}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name SequenceT[rX̃T[rX
     */
    public void setSequenceServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ClientConnection ClientConnection}ID𐶐{@link jp.ossc.nimbus.service.sequnce.Sequence Sequence}T[rX̃T[rX擾B<p>
     * 
     * @return SequenceT[rX̃T[rX
     */
    public ServiceName getSequenceServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#send(Message)}œMۂɁAeM֕ɑMsXbh̐ݒ肷B<p>
     * ftHg1ŁAeM֒ɑMsB<br>
     *
     * @param threadSize Xbh
     */
    public void setSendThreadSize(int threadSize);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#send(Message)}œMۂɁAeM֕ɑMsXbh̐擾B<p>
     *
     * @return Xbh
     */
    public int getSendThreadSize();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#send(Message)}œMۂɁA񑗐Ms߂{@link jp.ossc.nimbus.service.queue.Queue Queue}̃T[rXݒ肷B<p>
     * {@link #setSendThreadSize(int)}ɁA2ȏw肵Ȃꍇ́A񑗐MȂ߁AQueue͎gpȂB<br>
     * 2ȏw肵ꍇŁȂw肵Ȃꍇ́AQueue𐶐B<br>
     *
     * @param name 񑗐MpQueueT[rX
     */
    public void setSendQueueServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#send(Message)}œMۂɁA񑗐Ms߂{@link jp.ossc.nimbus.service.queue.Queue Queue}̃T[rX擾B<p>
     *
     * @return 񑗐MpQueueT[rX
     */
    public ServiceName getSendQueueServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#sendAsynch(Message)}Ŕ񓯊MۂɁAeM֕ɑMsXbh̐ݒ肷B<p>
     * ftHg0ŁA񓯊MT|[gȂB<br>
     *
     * @param threadSize Xbh
     */
    public void setAsynchSendThreadSize(int threadSize);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#sendAsynch(Message)}Ŕ񓯊MۂɁAeM֕ɑMsXbh̐擾B<p>
     *
     * @return Xbh
     */
    public int getAsynchSendThreadSize();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#sendAsynch(Message)}Ŕ񓯊MۂɁA񑗐Ms߂{@link jp.ossc.nimbus.service.queue.Queue Queue}̃t@NgT[rXݒ肷B<p>
     * {@link #setAsynchSendThreadSize(int)}ɁA1ȏw肵Ȃꍇ́A񓯊MT|[gȂ߁AQueue͎gpȂB<br>
     * 1ȏw肵ꍇŁȂw肵Ȃꍇ́AQueue𐶐B<br>
     *
     * @param name 񑗐MpQueueT[rX
     */
    public void setAsynchSendQueueFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnection#sendAsynch(Message)}Ŕ񓯊MۂɁA񑗐Ms߂{@link jp.ossc.nimbus.service.queue.Queue Queue}̃t@NgT[rX擾B<p>
     *
     * @return 񑗐MpQueueT[rX
     */
    public ServiceName getAsynchSendQueueFactoryServiceName();
    
    /**
     * MpPbg̃obt@Ԃݒ肷B<p>
     * {@link jp.ossc.nimbus.service.publish.ClientConnection#startReceive(long)}őkĎM邽߂ɁAMőMobt@ɁAMpPbg𑗐Mǂ̂炢̊ԎcĂݒ肷B<br>
     * ftHǵA5000[ms]B<br>
     *
     * @param time obt@[ms]
     */
    public void setSendBufferTime(long time);
    
    /**
     * MpPbg̃obt@Ԃ擾B<p>
     *
     * @return obt@[ms]
     */
    public long getSendBufferTime();
    
    /**
     * MG[ꍇɏo͂郍ObZ[WIDݒ肷B<br>
     * ftHǵAȂŃOo͂ȂB<br>
     * 
     * @param id ObZ[WID
     */
    public void setServerSendErrorMessageId(String id);
    
    /**
     * MG[ꍇɏo͂郍ObZ[WID擾B<br>
     * 
     * @return ObZ[WID
     */
    public String getServerSendErrorMessageId();
    
    /**
     * MG[AK̃gC񐔃gCĂȂꍇɏo͂郍ObZ[WIDݒ肷B<br>
     * ftHǵAȂŃOo͂ȂB<br>
     * 
     * @param id ObZ[WID
     */
    public void setServerSendErrorRetryOverMessageId(String id);
    
    /**
     * MG[AK̃gC񐔃gCĂȂꍇɏo͂郍ObZ[WID擾B<br>
     * 
     * @return ObZ[WID
     */
    public String getServerSendErrorRetryOverMessageId();
    
    /**
     * T[oIꍇɏo͂郍ObZ[WIDݒ肷B<p>
     *
     * @param id ObZ[WID
     */
    public void setClientServerCloseMessageId(String id);
    
    /**
     * T[oIꍇɏo͂郍ObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getClientServerCloseMessageId();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnectionListener ServerConnectionListener}̃T[rXݒ肷B<p>
     *
     * @param names ServerConnectionListener̃T[rX̔z
     */
    public void setServerConnectionListenerServiceNames(ServiceName[] names);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.ServerConnectionListener ServerConnectionListener}̃T[rX擾B<p>
     *
     * @return ServerConnectionListener̃T[rX̔z
     */
    public ServiceName[] getServerConnectionListenerServiceNames();
    
    /**
     * M擾B<p>
     *
     * @return M
     */
    public long getSendCount();
    
    /**
     * MZbgB<p>
     */
    public void resetSendCount();
    
    /**
     * ڑ̃NCAgID̏W擾B<br>
     *
     * @return NCAgID̏W
     */
    public Set<Object> getClients();
    
    /**
     * ڑ̃NCAg̐擾B<br>
     *
     * @return NCAg̐
     */
    public int getClientSize();
    
    /**
     * ڑ̃NCAgŔzMsΏۂƂȂNCAgID̏W擾B<br>
     *
     * @return NCAgID̏W
     */
    public Set<Object> getEnabledClients();
    
    /**
     * ڑ̃NCAgŔzMsȂΏۂƂȂNCAgID̏W擾B<br>
     *
     * @return NCAgID̏W
     */
    public Set<Object> getDisabledClients();
    
    /**
     * w肳ꂽID̃NCAg̔zMLɂB<p>
     * |[gԍ̎w肪0ȉ̏ꍇ́A|[gԍ͔CӂƂ݂ȂB<br>
     *
     * @param id NCAgID
     */
    public void enabledClient(Object id);
    
    /**
     * w肳ꂽID̃NCAg̔zM𖳌ɂB<p>
     * |[gԍ̎w肪0ȉ̏ꍇ́A|[gԍ͔CӂƂ݂ȂB<br>
     *
     * @param id NCAgID
     */
    public void disabledClient(Object id);
    
    /**
     * ڑ̃NCAg̑M擾B<br>
     *
     * @return NCAg̑MBL[NCAgIDAlM̃}bv
     */
    public Map<Object,Long> getSendCountsByClient();
    
    /**
     * ڑ̃NCAg̑MZbgB<br>
     */
    public void resetSendCountsByClient();
    
    /**
     * w肳ꂽID̃NCAgo^ĂTuWFNg擾B<p>
     *
     * @param id NCAgID
     * @return TuWFNg̏W
     */
    public Set<String> getSubjects(Object id);
    
    /**
     * w肳ꂽID̃NCAgAw肳ꂽTuWFNgɑ΂ēo^ĂL[擾B<p>
     *
     * @param id NCAgID
     * @param subject TuWFNg
     * @return L[̏W
     */
    public Set<String> getKeys(Object id, String subject);
}