/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.*;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.jndi.*;

/**
 * JMSbZ[Wvf[Tt@NgB<p>
 * javax.jms.SessionbvAMessageProducer̐ȗB<br>
 * QueueTopĩC^tF[XꂽJMS 1.1ɑΉĂ܂BJMS 1.1ȑÕo[WŎgpꍇɂ́ATuNX{@link JMSQueueSenderFactoryService}A{@link JMSTopicPublisherFactoryService}gpĉB<br>
 * 
 * @author M.Takata
 */
public class JMSMessageProducerFactoryService extends ServiceBase
 implements JMSMessageProducerFactory, JMSMessageProducerFactoryServiceMBean{
    
    private static final long serialVersionUID = 8090980996008836232L;
    
    protected ServiceName jmsSessionFactoryServiceName;
    protected JMSSessionFactory jmsSessionFactory;
    
    protected ServiceName destinationFinderServiceName;
    protected JndiFinder destinationFinder;
    
    protected String destinationName;
    protected Destination destination;
    
    protected Session session;
    protected boolean isSessionCreate;
    protected boolean isCloseSession;
    
    // JMSMessageProducerFactoryServiceMBeanJavaDoc
    public void setJMSSessionFactoryServiceName(ServiceName name){
        jmsSessionFactoryServiceName = name;
    }
    // JMSMessageProducerFactoryServiceMBeanJavaDoc
    public ServiceName getJMSSessionFactoryServiceName(){
        return jmsSessionFactoryServiceName;
    }
    
    // JMSMessageProducerFactoryServiceMBeanJavaDoc
    public void setDestinationFinderServiceName(ServiceName name){
        destinationFinderServiceName = name;
    }
    // JMSMessageProducerFactoryServiceMBeanJavaDoc
    public ServiceName getDestinationFinderServiceName(){
        return destinationFinderServiceName;
    }
    
    // JMSMessageProducerFactoryServiceMBeanJavaDoc
    public void setDestinationName(String name){
        destinationName = name;
    }
    // JMSMessageProducerFactoryServiceMBeanJavaDoc
    public String getDestinationName(){
        return destinationName;
    }
    
    // JMSMessageProducerFactoryServiceMBeanJavaDoc
    public void setSessionCreate(boolean isCreate){
        isSessionCreate = isCreate;
    }
    // JMSMessageProducerFactoryServiceMBeanJavaDoc
    public boolean isSessionCreate(){
        return isSessionCreate;
    }
    
    // JMSMessageProducerFactoryServiceMBeanJavaDoc
    public void setCloseSession(boolean isClose){
        isCloseSession = isClose;
    }
    // JMSMessageProducerFactoryServiceMBeanJavaDoc
    public boolean isCloseSession(){
        return isCloseSession;
    }
    
    /**
     * {@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rXݒ肷B<p>
     * Őݒ肳ꂽJndiFinderT[rXgāAJNDIT[ojavax.jms.DestinationlookupB<br>
     *
     * @param destinationFinder JndiFinderT[rX
     */
    public void setJndiFinder(JndiFinder destinationFinder) {
        this.destinationFinder = destinationFinder;
    }
    
    /**
     * {@link JMSSessionFactory}T[rXݒ肷B<p>
     * SessionCreatetruȅꍇAT[rX̊JnɁAŐݒ肳ꂽJMSSessionFactoryT[rXgāASession𐶐ێB<br>
     *
     * @param jmsSessionFactory JMSSessionFactoryT[rX
     */
    public void setJMSSessionFactory(JMSSessionFactory jmsSessionFactory) {
        this.jmsSessionFactory = jmsSessionFactory;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception JnɎsꍇ
     */
    public void startService() throws Exception{
        
        if(jmsSessionFactoryServiceName != null){
            jmsSessionFactory = (JMSSessionFactory)ServiceManagerFactory
                .getServiceObject(jmsSessionFactoryServiceName);
        }
        
        if(destinationFinderServiceName != null){
            destinationFinder
                 = (JndiFinder)ServiceManagerFactory
                    .getServiceObject(destinationFinderServiceName);
            if(destinationName == null){
                destination = (Destination)destinationFinder.lookup();
            }else{
                destination = (Destination)destinationFinder
                    .lookup(destinationName);
            }
        }
        
        if(isSessionCreate){
            if(jmsSessionFactory == null){
                throw new IllegalArgumentException(
                    "jmsSessionFactoryServiceName must be specified."
                );
            }
            session = jmsSessionFactory.getSession();
        }
    }
    
    /**
     * T[rX̒~sB<p>
     *
     * @exception Exception ~Ɏsꍇ
     */
    public void stopService() throws Exception{
        if(isCloseSession && session != null){
            try{
                session.close();
            }catch(JMSException e){
            }
        }
        
        destination = null;
    }
    
    // JMSMessageProducerFactoryJavaDoc
    public Session getSession(){
        return session;
    }
    
    // JMSMessageProducerFactoryJavaDoc
    public Destination getDestination(){
        return destination;
    }
    
    // JMSMessageProducerFactoryJavaDoc
    public JMSSessionFactory getSessionFactory(){
        return jmsSessionFactory;
    }
    
    // JMSMessageProducerFactoryJavaDoc
    public MessageProducer createProducer()
     throws JMSMessageProducerCreateException{
        return createProducer(destination);
    }
    
    // JMSMessageProducerFactoryJavaDoc
    public MessageProducer createProducer(Destination dest)
     throws JMSMessageProducerCreateException{
        Session session = this.session;
        if(session == null){
            try{
                session = jmsSessionFactory.getSession();
            }catch(JMSSessionCreateException e){
                throw new JMSMessageProducerCreateException(e);
            }
        }
        return createProducer(session, dest);
    }
    
    // JMSMessageProducerFactoryJavaDoc
    public MessageProducer createProducer(Session session, Destination dest)
     throws JMSMessageProducerCreateException{
        if(session == null){
            throw new JMSMessageProducerCreateException("Session is null.");
        }
        if(dest == null){
            throw new JMSMessageProducerCreateException("Destination is null.");
        }
        try{
            return session.createProducer(dest);
        }catch(JMSException e){
            throw new JMSMessageProducerCreateException(e);
        }
    }
 }
