/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.graph;

import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYDataset;

import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;

/**
 * XYvbgt@NgT[rXB<p>
 *
 * @author k2-taniguchi
 */
public class XYPlotFactoryService extends ServiceBase
    implements XYPlotFactoryServiceMBean, PlotFactory {
    
    private static final long serialVersionUID = 7687375902291200266L;
    
    /** vbg */
    private String name;
    /** f[^ZbgT[rX̔z */
    private ServiceName[] dsFactoryServiceNames;
    /** L[Ƀf[^ZbgAlɃf[^Zbgt@Ng̃}bv */
    private Map<String, DatasetFactory> dsFactoryMap;

    /** T[rX̔z */
    private ServiceName[] domainAxisServiceNames;
    /** cT[rX̔z */
    private ServiceName[] rangeAxisServiceNames;
    /** L[ɉAlɉCfbNX */
    private Map<String, Integer> domainAxisIndexMap;
    /** L[ɏcAlɏcCfbNX */
    private Map<String, Integer> rangeAxisIndexMap;
    /** ڐ蒲 */
    protected TickUnitAdjuster[] adjusters;
    /** ڐ蒲߃T[rX */
    protected ServiceName[] tickUnitAdjusterServiceNames;

    /** ev[gpvbg */
    protected XYPlot tmpPlot;
    /** vpeB : f[^Zbg=_[ */
    private Properties dsRendererNames;
    /** vpeB : f[^Zbg= */
    private Properties dsDomainAxisNames;
    /** vpeB : f[^Zbg=c */
    private Properties dsRangeAxisNames;

    // XYPlotFactoryServiceMBeanJavaDoc
    public void setDatasetFactoryServiceNames(ServiceName[] names) {
        dsFactoryServiceNames = names;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public ServiceName[] getDatasetFactoryServiceNames() {
        return dsFactoryServiceNames;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public void setDatasetRendererServiceNames(Properties names) {
        dsRendererNames = names;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public Properties getDatasetRendererServiceNames() {
        return dsRendererNames;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public void setDatasetDomainAxisNames(Properties names) {
        dsDomainAxisNames = names;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public Properties getDatasetDomainAxisNames() {
        return dsDomainAxisNames;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public void setDatasetRangeAxisNames(Properties names) {
        dsRangeAxisNames = names;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public Properties getDatasetRangeAxisNames() {
        return dsRangeAxisNames;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public void setDomainAxisServiceNames(ServiceName[] serviceNames) {
        domainAxisServiceNames = serviceNames;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public ServiceName[] getDomainAxisServiceNames() {
        return domainAxisServiceNames;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public void setRangeAxisServiceNames(ServiceName[] serviceNames) {
        rangeAxisServiceNames = serviceNames;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public ServiceName[] getRangeAxisServiceNames() {
        return rangeAxisServiceNames;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public void setTickUnitAdjusters(TickUnitAdjuster[] adjusters) {
        this.adjusters = adjusters;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public TickUnitAdjuster[] getTickUnitAdjusters() {
        return adjusters;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public void setTickUnitAdjusterServiceNames(ServiceName[] names){
        tickUnitAdjusterServiceNames = names;
    }

    // XYPlotFactoryServiceMBeanJavaDoc
    public ServiceName[] getTickUnitAdjusterNames(){
        return tickUnitAdjusterServiceNames;
    }

    // ServiceBaseJavaDoc
    public void createService() throws Exception {
        dsFactoryMap = new LinkedHashMap<String, DatasetFactory>();
        domainAxisIndexMap = new HashMap<String, Integer>();
        rangeAxisIndexMap = new HashMap<String, Integer>();

        tmpPlot = new XYPlot(
                      null,
                      new NumberAxis(),
                      new NumberAxis(),
                      new XYLineAndShapeRenderer(true, false)
                  );
    }

    // ServiceBaseJavaDoc
    public void startService() throws Exception {
        if (name == null || name.length() == 0) {
            // T[rX`Őݒ肳Ȃꍇ
            name = getServiceName();
        }

        if (dsFactoryServiceNames == null
            || dsFactoryServiceNames.length == 0) {
            throw new IllegalArgumentException(
                "DatasetFactory ServiceNames must be specified."
            );
        }

        for (int i = 0; i < dsFactoryServiceNames.length; i++) {
            // ̃vbgɊ֘Af[^Zbgt@NgT[rX擾
            DatasetFactory dsFactory = ServiceManagerFactory.getServiceObject(dsFactoryServiceNames[i]);

            if (dsFactory == null) {
                throw new IllegalArgumentException(
                    "DatasetFactory[" + dsFactoryServiceNames[i].getServiceName() + "] is null."
                );
            } else {
                // L[Ƀf[^ZbgAlɃf[^Zbgt@Ng
                dsFactoryMap.put(dsFactory.getName(), dsFactory);
            }
        }

        // 
        if (domainAxisServiceNames != null && domainAxisServiceNames.length > 0) {
            for (int i = 0; i < domainAxisServiceNames.length; i++) {
                domainAxisIndexMap.put(
                    domainAxisServiceNames[i].getServiceName(), new Integer(i)
                );
            }
        }

        // c
        if (rangeAxisServiceNames != null && rangeAxisServiceNames.length > 0) {
            for (int i = 0; i < rangeAxisServiceNames.length; i++) {
                rangeAxisIndexMap.put(
                    rangeAxisServiceNames[i].getServiceName(), new Integer(i)
                );
            }
        }
        
        if(tickUnitAdjusterServiceNames != null
             && tickUnitAdjusterServiceNames.length != 0){
            adjusters = new TickUnitAdjuster[tickUnitAdjusterServiceNames.length];
            for(int i = 0; i < adjusters.length; i++){
                adjusters[i] = (TickUnitAdjuster)ServiceManagerFactory
                    .getServiceObject(tickUnitAdjusterServiceNames[i]);
            }
        }
    }

    // ServiceBaseJavaDoc
    public void stopService() throws Exception {
        dsFactoryMap.clear();
        domainAxisIndexMap.clear();
        rangeAxisIndexMap.clear();
    }

    // ServiceBaseJavaDoc
    public void destroyService() throws Exception {
        dsFactoryMap = null;
        domainAxisIndexMap = null;
        rangeAxisIndexMap = null;

        tmpPlot = null;
    }
    
    protected XYPlot newXYPlot(){
        return new XYPlot(
                    null,
                    (domainAxisServiceNames == null || domainAxisServiceNames.length == 0) ? new NumberAxis() : null,
                    (rangeAxisServiceNames == null || rangeAxisServiceNames.length == 0) ? new NumberAxis() : null,
                    (dsRendererNames == null || dsRendererNames.size() == 0) ? new XYLineAndShapeRenderer(true, false) : null
                );
    }

    /**
     * ev[gpvbglRs[vbg쐬B<p>
     *
     * @return XYvbg
     */
    protected XYPlot copyXYPlot() {
        XYPlot xyPlot = newXYPlot();

        xyPlot.setAxisOffset(tmpPlot.getAxisOffset());
        xyPlot.setBackgroundAlpha(tmpPlot.getBackgroundAlpha());
        xyPlot.setBackgroundImage(tmpPlot.getBackgroundImage());
        xyPlot.setBackgroundImageAlignment(tmpPlot.getBackgroundImageAlignment());
        xyPlot.setBackgroundPaint(tmpPlot.getBackgroundPaint());
        xyPlot.setDatasetRenderingOrder(tmpPlot.getDatasetRenderingOrder());

        if (tmpPlot.getDomainAxisCount() > 0) {
            for (int i = 0; i < tmpPlot.getDomainAxisCount(); i++) {
                try {
                    if(tmpPlot.getDomainAxis(i) != null){
                        xyPlot.setDomainAxis(i, (ValueAxis) tmpPlot.getDomainAxis(i).clone());
                    }
                } catch (CloneNotSupportedException e) {
                }
            }
        }

        xyPlot.setDomainAxisLocation(tmpPlot.getDomainAxisLocation());
        xyPlot.setDomainCrosshairLockedOnData(tmpPlot.isDomainCrosshairLockedOnData());
        xyPlot.setDomainCrosshairPaint(tmpPlot.getDomainCrosshairPaint());
        xyPlot.setDomainCrosshairStroke(tmpPlot.getDomainCrosshairStroke());
        xyPlot.setDomainCrosshairValue(tmpPlot.getDomainCrosshairValue());
        xyPlot.setDomainCrosshairVisible(tmpPlot.isDomainCrosshairVisible());
        xyPlot.setDomainGridlinePaint(tmpPlot.getDomainGridlinePaint());
        xyPlot.setDomainGridlineStroke(tmpPlot.getDomainCrosshairStroke());
        xyPlot.setDomainGridlinesVisible(tmpPlot.isDomainGridlinesVisible());
        xyPlot.setDomainTickBandPaint(tmpPlot.getDomainTickBandPaint());
        xyPlot.setDrawingSupplier(tmpPlot.getDrawingSupplier());
        xyPlot.setFixedDomainAxisSpace(tmpPlot.getFixedDomainAxisSpace());
        xyPlot.setFixedLegendItems(tmpPlot.getFixedLegendItems());
        xyPlot.setFixedRangeAxisSpace(tmpPlot.getFixedRangeAxisSpace());
        xyPlot.setForegroundAlpha(tmpPlot.getForegroundAlpha());
        xyPlot.setInsets(tmpPlot.getInsets());
        xyPlot.setNoDataMessage(tmpPlot.getNoDataMessage());
        xyPlot.setNoDataMessageFont(tmpPlot.getNoDataMessageFont());
        xyPlot.setNoDataMessagePaint(tmpPlot.getNoDataMessagePaint());
        xyPlot.setOrientation(tmpPlot.getOrientation());
        xyPlot.setOutlinePaint(tmpPlot.getOutlinePaint());
        xyPlot.setOutlineStroke(tmpPlot.getOutlineStroke());
        xyPlot.setQuadrantOrigin(tmpPlot.getQuadrantOrigin());

        for (int i = 0; i < 4; i++) {
            // QuadrantPaint̓TCY4̔zŕێĂ܂B
            xyPlot.setQuadrantPaint(i, tmpPlot.getQuadrantPaint(i));
        }

        if (tmpPlot.getRangeAxisCount() > 0) {
            for (int i = 0; i < tmpPlot.getRangeAxisCount(); i++) {
                try {
                    if(tmpPlot.getRangeAxis(i) != null){
                        xyPlot.setRangeAxis(i, (ValueAxis) tmpPlot.getRangeAxis(i).clone());
                    }
                } catch (CloneNotSupportedException e) {
                }
            }
        }

        xyPlot.setRangeAxisLocation(tmpPlot.getRangeAxisLocation());
        xyPlot.setRangeCrosshairLockedOnData(tmpPlot.isRangeCrosshairLockedOnData());
        xyPlot.setRangeCrosshairPaint(tmpPlot.getRangeCrosshairPaint());
        xyPlot.setRangeCrosshairStroke(tmpPlot.getRangeCrosshairStroke());
        xyPlot.setRangeCrosshairValue(tmpPlot.getRangeCrosshairValue());
        xyPlot.setRangeCrosshairVisible(tmpPlot.isRangeCrosshairVisible());
        xyPlot.setRangeGridlinePaint(tmpPlot.getRangeGridlinePaint());
        xyPlot.setRangeGridlineStroke(tmpPlot.getRangeGridlineStroke());
        xyPlot.setRangeGridlinesVisible(tmpPlot.isRangeGridlinesVisible());
        xyPlot.setRangeTickBandPaint(tmpPlot.getRangeTickBandPaint());
        xyPlot.setRangeZeroBaselinePaint(tmpPlot.getRangeZeroBaselinePaint());
        xyPlot.setRangeZeroBaselineStroke(tmpPlot.getRangeZeroBaselineStroke());
        xyPlot.setRangeZeroBaselineVisible(tmpPlot.isRangeZeroBaselineVisible());
        xyPlot.setSeriesRenderingOrder(tmpPlot.getSeriesRenderingOrder());
        xyPlot.setWeight(tmpPlot.getWeight());

        return xyPlot;
    }

    /**
     * ̃vbgAvbgv̂1̃vbgɃ}[WB<p>
     *
     * @param plotConditions vbg̔z
     * @return 1Ƀ}[Wvbg
     */
    protected XYPlotConditionImpl mergeXYPlotCondition(PlotCondition[] plotConditions) {
        if (plotConditions == null || plotConditions.length == 0) {
            return null;
        }

        XYPlotConditionImpl xyPlotCondition = null;
        if (plotConditions.length == 1) {
            xyPlotCondition = (XYPlotConditionImpl) plotConditions[0];
        } else {
            for (int i = 0; i < plotConditions.length; i++) {
                if (!name.equals(plotConditions[i].getName())
                    || !(plotConditions[i] instanceof XYPlotConditionImpl)) {
                    continue;
                }
                if(xyPlotCondition == null){
                    xyPlotCondition = new XYPlotConditionImpl();
                    xyPlotCondition.setName(name);
                }
                XYPlotConditionImpl plotCondition =  (XYPlotConditionImpl) plotConditions[i];
                Set<String> enableDatasetNameSet = plotCondition.getEnableDatasetNameSet();

                if (enableDatasetNameSet != null) {
                    xyPlotCondition.setEnableDatasetNameSet(enableDatasetNameSet);
                }

                LinkedHashSet<String> orders = plotCondition.getDatasetNameOrderSet();
                if (orders != null) {
                    xyPlotCondition.setDatasetNameOrderSet(orders);
                }

                Map<String, List<DatasetCondition>> map = plotCondition.getDatasetConditionMap();
                if (map != null) {
                    xyPlotCondition.addDatasetConditionMap(map);
                }

                Map<Integer, Boolean> map2 = plotCondition.getRangeAxisVisibleMap();
                if (map2 != null) {
                    xyPlotCondition.addRangeAxisVisibleMap(map2);
                }

                Map<Integer, String> map3 = plotCondition.getDomainAxisLabelFontNameMap();
                if (map3 != null) {
                    xyPlotCondition.addDomainAxisLabelFontNameMap(map3);
                }
                Map<Integer, Integer> map4 = plotCondition.getDomainAxisLabelFontStyleMap();
                if (map4 != null) {
                    xyPlotCondition.addDomainAxisLabelFontStyleMap(map4);
                }
                map4 = plotCondition.getDomainAxisLabelFontSizeMap();
                if (map4 != null) {
                    xyPlotCondition.addDomainAxisLabelFontSizeMap(map4);
                }

                map3 = plotCondition.getRangeAxisTickLabelFontNameMap();
                if (map3 != null) {
                    xyPlotCondition.addRangeAxisTickLabelFontNameMap(map3);
                }
                map4 = plotCondition.getRangeAxisTickLabelFontStyleMap();
                if (map4 != null) {
                    xyPlotCondition.addRangeAxisTickLabelFontStyleMap(map4);
                }
                map4 = plotCondition.getRangeAxisTickLabelFontSizeMap();
                if (map4 != null) {
                    xyPlotCondition.addRangeAxisTickLabelFontSizeMap(map4);
                }

                map3 = plotCondition.getDomainAxisLabelFontNameMap();
                if (map3 != null) {
                    xyPlotCondition.addDomainAxisLabelFontNameMap(map3);
                }
                map4 = plotCondition.getDomainAxisLabelFontStyleMap();
                if (map4 != null) {
                    xyPlotCondition.addDomainAxisLabelFontStyleMap(map4);
                }
                map4 = plotCondition.getDomainAxisLabelFontSizeMap();
                if (map4 != null) {
                    xyPlotCondition.addDomainAxisLabelFontSizeMap(map4);
                }

                map3 = plotCondition.getRangeAxisLabelFontNameMap();
                if (map3 != null) {
                    xyPlotCondition.addRangeAxisLabelFontNameMap(map3);
                }
                map4 = plotCondition.getRangeAxisLabelFontStyleMap();
                if (map4 != null) {
                    xyPlotCondition.addRangeAxisLabelFontStyleMap(map4);
                }
                map4 = plotCondition.getRangeAxisLabelFontSizeMap();
                if (map4 != null) {
                    xyPlotCondition.addRangeAxisLabelFontSizeMap(map4);
                }

                String fontName = plotCondition.getDefaultDomainAxisTickLabelFontName();
                if(fontName != null){
                    xyPlotCondition.setDefaultDomainAxisTickLabelFontName(fontName);
                }
                int fontStyle = plotCondition.getDefaultDomainAxisTickLabelFontStyle();
                if(fontStyle != Integer.MIN_VALUE){
                    xyPlotCondition.setDefaultDomainAxisTickLabelFontStyle(fontStyle);
                }
                int fontSize = plotCondition.getDefaultDomainAxisTickLabelFontSize();
                if(fontSize != Integer.MIN_VALUE){
                    xyPlotCondition.setDefaultDomainAxisTickLabelFontSize(fontSize);
                }

                fontName = plotCondition.getDefaultRangeAxisTickLabelFontName();
                if(fontName != null){
                    xyPlotCondition.setDefaultRangeAxisTickLabelFontName(fontName);
                }
                fontStyle = plotCondition.getDefaultRangeAxisTickLabelFontStyle();
                if(fontStyle != Integer.MIN_VALUE){
                    xyPlotCondition.setDefaultRangeAxisTickLabelFontStyle(fontStyle);
                }
                fontSize = plotCondition.getDefaultRangeAxisTickLabelFontSize();
                if(fontSize != Integer.MIN_VALUE){
                    xyPlotCondition.setDefaultRangeAxisTickLabelFontSize(fontSize);
                }

                fontName = plotCondition.getDefaultDomainAxisLabelFontName();
                if(fontName != null){
                    xyPlotCondition.setDefaultDomainAxisLabelFontName(fontName);
                }
                fontStyle = plotCondition.getDefaultDomainAxisLabelFontStyle();
                if(fontStyle != Integer.MIN_VALUE){
                    xyPlotCondition.setDefaultDomainAxisLabelFontStyle(fontStyle);
                }
                fontSize = plotCondition.getDefaultDomainAxisLabelFontSize();
                if(fontSize != Integer.MIN_VALUE){
                    xyPlotCondition.setDefaultDomainAxisLabelFontSize(fontSize);
                }

                fontName = plotCondition.getDefaultRangeAxisLabelFontName();
                if(fontName != null){
                    xyPlotCondition.setDefaultRangeAxisLabelFontName(fontName);
                }
                fontStyle = plotCondition.getDefaultRangeAxisLabelFontStyle();
                if(fontStyle != Integer.MIN_VALUE){
                    xyPlotCondition.setDefaultRangeAxisLabelFontStyle(fontStyle);
                }
                fontSize = plotCondition.getDefaultRangeAxisLabelFontSize();
                if(fontSize != Integer.MIN_VALUE){
                    xyPlotCondition.setDefaultRangeAxisLabelFontSize(fontSize);
                }
            }
        }

        return xyPlotCondition;
    }

    // PlotFactoryJavaDoc
    public Plot createPlot(PlotCondition[] plotConditions)
        throws PlotCreateException {

        // ̃vbg1Ƀ}[W
        XYPlotConditionImpl xyPlotCondition = mergeXYPlotCondition(plotConditions);
        if (xyPlotCondition == null) {
            return new XYPlot(
                        null,
                        new NumberAxis(),
                        new NumberAxis(),
                        new XYLineAndShapeRenderer(true, false)
                    );
        }

        // ev[g̃vbglRs[vbg쐬
        XYPlot xyPlot = copyXYPlot();
        // f[^ZbgXg
        List<DatasetFactory> dsFactoryList = new ArrayList<DatasetFactory>();
        // Lȃf[^Zbg擾
        String[] enableDsNames = xyPlotCondition.getEnableDatasetNames();
        // ݒ菇̃f[^Zbg擾
        String[] dsNamesOrder = xyPlotCondition.getDatasetNameOrder();
        // f[^Zbgɐݒ肳ꂽƂ̂ݓKp
        if (dsNamesOrder != null && dsNamesOrder.length > 0) {
            for (int j = 0; j < dsNamesOrder.length; j++) {
                // f[^Zbg
                String dsName = dsNamesOrder[j];
                boolean isEnabled = false;
                if(enableDsNames != null && enableDsNames.length > 0) {
                    for (int k = 0; k < enableDsNames.length; k++) {
                        if (dsName.equals(enableDsNames[k])) {
                            isEnabled = true;
                            break;
                        }
                    }

                    if (isEnabled) {
                        if (dsFactoryMap.containsKey(dsName)) {
                            // Lȃf[^Zbg
                            dsFactoryList.add(dsFactoryMap.get(dsName));
                        }
                    }

                }
            }
        } else {
            /*
             * f[^ZbgɃf[^ZbgALf[^Zbg
             * ݒ肳Ȃꍇ́AT[rX`̏Ńf[^Zbgݒ
             */
            dsFactoryList.addAll(dsFactoryMap.values());
        }

        for (int j = 0; j < dsFactoryList.size(); j++) {
            DatasetFactory dsFactory =
                dsFactoryList.get(j);

            String dsName = dsFactory.getName();
            DatasetCondition[] dsConditions =
                xyPlotCondition.getDatasetConditions();

            Dataset ds = null;
            try {
                ds = dsFactory.createDataset(dsConditions);
            } catch (DatasetCreateException e) {
                // f[^Zbgs
                throw new PlotCreateException(e);
            }

            // T[rXGfB^
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(getServiceManagerName());
            // f[^Zbg̃[v
            if (ds != null && (ds instanceof XYDataset)) {
                // f[^Zbg
                xyPlot.setDataset(j, (XYDataset) ds);

                // ̃f[^Zbg鉡
                if (dsDomainAxisNames != null && dsDomainAxisNames.size() > 0) {
                    String domainAxisName = dsDomainAxisNames.getProperty(dsName);
                    if (domainAxisName != null
                        && domainAxisIndexMap.containsKey(domainAxisName)
                    ) {
                        Integer domainAxisIndex = (Integer) domainAxisIndexMap.get(domainAxisName);
                        xyPlot.mapDatasetToDomainAxis(j, domainAxisIndex.intValue());
                    }
                }

                // ̃f[^Zbgc
                if (dsRangeAxisNames != null && dsRangeAxisNames.size() > 0) {
                    String rangeAxisName = dsRangeAxisNames.getProperty(dsName);
                    if (rangeAxisName != null && rangeAxisIndexMap.containsKey(rangeAxisName)) {
                        Integer rangeAxisIndex = (Integer) rangeAxisIndexMap.get(rangeAxisName);
                        xyPlot.mapDatasetToRangeAxis(j, rangeAxisIndex.intValue());
                    }
                }

                // _[
                XYItemRenderer renderer = null;
                if (dsRendererNames != null && dsRendererNames.size() > 0) {
                    String rendererNameStr = dsRendererNames.getProperty(dsName);
                    editor.setAsText(rendererNameStr);
                    ServiceName rendererName = (ServiceName) editor.getValue();

                    renderer =
                        (XYItemRenderer) ServiceManagerFactory.getServiceObject(rendererName);
                }
                if (renderer != null) {
                    xyPlot.setRenderer(j, renderer);
                } else {
                    xyPlot.setRenderer(j, new XYLineAndShapeRenderer(true, false));
                }
            }
        }

        // 
        if (domainAxisServiceNames != null && domainAxisServiceNames.length > 0) {
            for (int j = 0; j < domainAxisServiceNames.length; j++) {
                ValueAxis domainAxis =
                    (ValueAxis) ServiceManagerFactory.getServiceObject(domainAxisServiceNames[j]);

                // xtHg
                if (xyPlotCondition.getDefaultDomainAxisLabelFontName() != null
                    || xyPlotCondition.getDefaultDomainAxisLabelFontStyle() != Integer.MIN_VALUE
                    || xyPlotCondition.getDefaultDomainAxisLabelFontSize() != Integer.MIN_VALUE
                ) {
                    domainAxis.setLabelFont(
                        mergeFont(
                            domainAxis.getLabelFont(),
                            xyPlotCondition.getDefaultDomainAxisLabelFontName(),
                            xyPlotCondition.getDefaultDomainAxisLabelFontStyle(),
                            xyPlotCondition.getDefaultDomainAxisLabelFontSize()
                        )
                    );
                } else if (xyPlotCondition.getDomainAxisLabelFontName(j) != null
                            || xyPlotCondition.getDomainAxisLabelFontStyle(j) != Integer.MIN_VALUE
                            || xyPlotCondition.getDomainAxisLabelFontSize(j) != Integer.MIN_VALUE
                ) {
                    domainAxis.setLabelFont(
                        mergeFont(
                            domainAxis.getLabelFont(),
                            xyPlotCondition.getDomainAxisLabelFontName(j),
                            xyPlotCondition.getDomainAxisLabelFontStyle(j),
                            xyPlotCondition.getDomainAxisLabelFontSize(j)
                        )
                    );
                }

                // TickxtHg
                if (xyPlotCondition.getDefaultDomainAxisTickLabelFontName() != null
                    || xyPlotCondition.getDefaultDomainAxisTickLabelFontStyle() != Integer.MIN_VALUE
                    || xyPlotCondition.getDefaultDomainAxisTickLabelFontSize() != Integer.MIN_VALUE
                ) {
                    domainAxis.setTickLabelFont(
                        mergeFont(
                            domainAxis.getTickLabelFont(),
                            xyPlotCondition.getDefaultDomainAxisTickLabelFontName(),
                            xyPlotCondition.getDefaultDomainAxisTickLabelFontStyle(),
                            xyPlotCondition.getDefaultDomainAxisTickLabelFontSize()
                        )
                    );
                } else if (xyPlotCondition.getDomainAxisTickLabelFontName(j) != null
                            || xyPlotCondition.getDomainAxisTickLabelFontStyle(j) != Integer.MIN_VALUE
                            || xyPlotCondition.getDomainAxisTickLabelFontSize(j) != Integer.MIN_VALUE
                ) {
                    domainAxis.setTickLabelFont(
                        mergeFont(
                            domainAxis.getTickLabelFont(),
                            xyPlotCondition.getDomainAxisTickLabelFontName(j),
                            xyPlotCondition.getDomainAxisTickLabelFontStyle(j),
                            xyPlotCondition.getDomainAxisTickLabelFontSize(j)
                        )
                    );
                }

                xyPlot.setDomainAxis(j, domainAxis);
            }
        }

        // c
        if (rangeAxisServiceNames != null && rangeAxisServiceNames.length > 0) {
            for (int j = 0; j < rangeAxisServiceNames.length; j++) {
                ValueAxis rangeAxis =
                    (ValueAxis) ServiceManagerFactory.getServiceObject(rangeAxisServiceNames[j]);

                // cxtHg
                if (xyPlotCondition.getDefaultRangeAxisLabelFontName() != null
                    || xyPlotCondition.getDefaultRangeAxisLabelFontStyle() != Integer.MIN_VALUE
                    || xyPlotCondition.getDefaultRangeAxisLabelFontSize() !=  Integer.MIN_VALUE
                ) {
                    rangeAxis.setLabelFont(
                        mergeFont(
                            rangeAxis.getLabelFont(),
                            xyPlotCondition.getDefaultRangeAxisLabelFontName(),
                            xyPlotCondition.getDefaultRangeAxisLabelFontStyle(),
                            xyPlotCondition.getDefaultRangeAxisLabelFontSize()
                        )
                    );
                } else if (xyPlotCondition.getRangeAxisLabelFontName(j) != null
                            || xyPlotCondition.getRangeAxisLabelFontStyle(j) != Integer.MIN_VALUE
                            || xyPlotCondition.getRangeAxisLabelFontSize(j) !=  Integer.MIN_VALUE
                ) {
                    rangeAxis.setLabelFont(
                        mergeFont(
                            rangeAxis.getLabelFont(),
                            xyPlotCondition.getRangeAxisLabelFontName(j),
                            xyPlotCondition.getRangeAxisLabelFontStyle(j),
                            xyPlotCondition.getRangeAxisLabelFontSize(j)
                        )
                    );
                }

                // cTickxtHg
                if (xyPlotCondition.getDefaultRangeAxisTickLabelFontName() != null
                    || xyPlotCondition.getDefaultRangeAxisTickLabelFontStyle() != Integer.MIN_VALUE
                    || xyPlotCondition.getDefaultRangeAxisTickLabelFontSize() != Integer.MIN_VALUE
                ) {
                    rangeAxis.setTickLabelFont(
                        mergeFont(
                            rangeAxis.getTickLabelFont(),
                            xyPlotCondition.getDefaultRangeAxisTickLabelFontName(),
                            xyPlotCondition.getDefaultRangeAxisTickLabelFontStyle(),
                            xyPlotCondition.getDefaultRangeAxisTickLabelFontSize()
                        )
                    );
                } else if (xyPlotCondition.getRangeAxisTickLabelFontName(j) != null
                            || xyPlotCondition.getRangeAxisTickLabelFontStyle(j) != Integer.MIN_VALUE
                            || xyPlotCondition.getRangeAxisTickLabelFontSize(j) !=  Integer.MIN_VALUE
                ) {
                    rangeAxis.setTickLabelFont(
                        mergeFont(
                            rangeAxis.getTickLabelFont(),
                            xyPlotCondition.getRangeAxisTickLabelFontName(j),
                            xyPlotCondition.getRangeAxisTickLabelFontStyle(j),
                            xyPlotCondition.getRangeAxisTickLabelFontSize(j)
                        )
                    );
                }

                // c̉Ԑݒ
                if (xyPlotCondition.isRangeAxisVisible(j) != null) {
                    rangeAxis.setVisible(
                        xyPlotCondition.isRangeAxisVisible(j).booleanValue()
                    );
                }

                xyPlot.setRangeAxis(j, rangeAxis);
            }
        }

        if (adjusters != null) {
            // ڐ蒲
            for(int i = 0; i < adjusters.length; i++){
                adjusters[i].adjust(xyPlot);
            }
        }
        return xyPlot;
    }

    /**
     * w肳ꂽtHg
     * w肳ꂽ[tHgAtHgX^CAtHgTCY]}[WB<p>
     *
     * @param orgFont tHg
     * @param fontName tHg
     * @param fontStyle tHgX^C
     * @param fontSize tHgTCY
     * @return }[WtHg
     */
    protected Font mergeFont(
        Font orgFont,
        String fontName,
        int fontStyle,
        int fontSize
    ) {
        if (orgFont == null) {
            return new Font(fontName, fontStyle, fontSize);
        }

        String newName = orgFont.getName();
        int newStyle = orgFont.getStyle();
        int newSize = orgFont.getSize();
        if (fontName != null) {
            newName = fontName;
        }
        if (fontStyle != Integer.MIN_VALUE) {
            newStyle = fontStyle;
        }
        if (fontSize != Integer.MIN_VALUE) {
            newSize = fontSize;
        }
        return new Font(newName, newStyle, newSize);
    }

    // PlotFactoryJavaDoc
    public Plot getPlot() {
        return tmpPlot;
    }

    // PlotFactoryJavaDoc
    public void setName(String name) {
        this.name = name;
    }

    // PlotFactoryJavaDoc
    public String getName() {
        return name;
    }

}
