/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import java.util.*;

import jp.ossc.nimbus.core.ServiceBase;

/**
 * Last In First OutӂASYT[rXB<p>
 * ȉɁALIFOłӂΏۂƂȂLbVIuWFNg肷邠ӂASYT[rX̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="LIFOOverflowAlgorithm"
 *                  code="jp.ossc.nimbus.service.cache.LIFOOverflowAlgorithmService"/&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class LIFOOverflowAlgorithmService<E> extends ServiceBase
 implements OverflowAlgorithm<E>, CacheRemoveListener<E>, java.io.Serializable,
            LIFOOverflowAlgorithmServiceMBean{
    
    private static final long serialVersionUID = 2933104597491523323L;
    
    private List<CachedReference<E>> referenceList;
    
    // LIFOOverflowAlgorithmServiceMBeanJavaDoc
    @Override
    public int size(){
        return referenceList == null ? 0 : referenceList.size();
    }
    
    /**
     * T[rX̐sB<p>
     * CX^Xϐ̏sB
     *
     * @exception Exception T[rX̐Ɏsꍇ
     */
    @Override
    public void createService() throws Exception{
        referenceList = Collections.synchronizedList(new ArrayList<CachedReference<E>>());
    }
    
    /**
     * T[rX̔jsB<p>
     * CX^Xϐ̊JsB
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    @Override
    public void destroyService() throws Exception{
        reset();
        referenceList = null;
    }
    
    /**
     * LbVQƂǉB<p>
     * œnꂽLbVQƂێBɁA{@link CachedReference#addCacheRemoveListener(CacheRemoveListener)}ŁA{@link CacheRemoveListener}ƂĎgo^B<br>
     *
     * @param ref LbVQ
     */
    @Override
    public void add(CachedReference<E> ref){
        if(referenceList == null || ref == null){
            return;
        }
        synchronized(referenceList){
            if(!referenceList.contains(ref)){
                referenceList.add(ref);
                ref.addCacheRemoveListener(this);
            }
        }
    }
    
    /**
     * LbVQƂ폜B<p>
     * œnꂽLbVQƂŕێĂꍇ́AjBɁA{@link CachedReference#removeCacheRemoveListener(CacheRemoveListener)}ŁA{@link CacheRemoveListener}ƂĎgo^B<br>
     *
     * @param ref LbVQ
     */
    @Override
    public void remove(CachedReference<E> ref){
        if(referenceList == null || ref == null){
            return;
        }
        synchronized(referenceList){
            if(referenceList.contains(ref)){
                referenceList.remove(ref);
                ref.removeCacheRemoveListener(this);
            }
        }
    }
    
    /**
     * oŁAӂLbVQƂ肷B<p>
     * {@link #add(CachedReference)}œnꂽLbVQƂ̒AŌɒǉꂽLbVQƂAӂLbVQƂƂĕԂB<br>
     *
     * @return õASYŌ肳ꂽӂLbVQ
     */
    @Override
    public CachedReference<E> overflow(){
        if(referenceList == null){
            return null;
        }
        synchronized(referenceList){
            final int size = referenceList.size();
            if(size != 0){
                return referenceList.remove(size - 1);
            }
            return null;
        }
    }
    
    /**
     * oŁAӂLbVQƂ肷B<p>
     * {@link #add(CachedReference)}œnꂽLbVQƂ̒AŌɒǉꂽLbVQƂAӂLbVQƂƂĕԂB<br>
     *
     * @param size ӂꐔ
     * @return õASYŌ肳ꂽӂLbVQ
     */
    @SuppressWarnings("unchecked")
    public CachedReference<E>[] overflow(int size){
        if(referenceList == null || referenceList.size() == 0){
            return null;
        }
        synchronized(referenceList){
            if(referenceList.size() != 0){
                final CachedReference<E>[] result = new CachedReference[Math.min(referenceList.size(), size)];
                for(int i = 0; i < result.length; i++){
                    result[i] = referenceList.remove(referenceList.size() - 1);
                }
                return result;
            }
            return null;
        }
    }
    
    /**
     * ӂASYs邽߂ɕێĂB<p>
     * {@link #add(CachedReference)}œnꂽLbVQƂSĔjB<br>
     */
    @Override
    public void reset(){
        if(referenceList != null){
            referenceList.clear();
        }
    }
    
    /**
     * LbV폜ꂽLbVQƂ̒ʒm󂯂B<p>
     * {@link #remove(CachedReference)}ĂяoB<br>
     *
     * @param ref LbV폜ꂽLbVQ
     */
    @Override
    public void removed(CachedReference<E> ref){
        remove(ref);
    }
}
