/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import javax.servlet.*;
import javax.servlet.http.*;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.EditorFinder;
import jp.ossc.nimbus.service.journal.editor.JournalServletResponseWrapper;
import jp.ossc.nimbus.service.journal.editor.JournalHttpServletResponseWrapper;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.sequence.Sequence;

/**
 * ANZXW[iC^[Zv^B<p>
 *
 * @author M.Takata
 */
public class AccessJournalInterceptorService
 extends ServletFilterInterceptorService
 implements AccessJournalInterceptorServiceMBean{
    
    private static final long serialVersionUID = 2545303821021717162L;
    
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected ServiceName accessEditorFinderServiceName;
    protected EditorFinder accessEditorFinder;
    protected ServiceName requestEditorFinderServiceName;
    protected EditorFinder requestEditorFinder;
    protected ServiceName responseEditorFinderServiceName;
    protected EditorFinder responseEditorFinder;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected ServiceName contextServiceName;
    protected Context<Object, Object> context;
    protected boolean isResponseWrap;
    protected boolean isResponseBufferedOutput;
    protected boolean isBushingRequestBlock;
    protected String requestIdKey = DEFAULT_REQUEST_ID_KEY;
    
    protected String accessJournalKey = DEFAULT_ACCESS_JOURNAL_KEY;
    protected String requestJournalKey = DEFAULT_REQUEST_JOURNAL_KEY;
    protected String responseJournalKey = DEFAULT_RESPONSE_JOURNAL_KEY;
    protected String servletRequestJournalKey
         = DEFAULT_SERVLET_REQUEST_JOURNAL_KEY;
    protected String servletResponseJournalKey
         = DEFAULT_SERVLET_RESPONSE_JOURNAL_KEY;
    protected String httpSessionJournalKey
         = DEFAULT_HTTP_SESSION_JOURNAL_KEY;
    
    protected boolean isOutputRequestSession = false;
    protected boolean isOutputResponseSession = false;
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setAccessJournalKey(String key){
        accessJournalKey = key;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public String getAccessJournalKey(){
        return accessJournalKey;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setRequestJournalKey(String key){
        requestJournalKey = key;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public String getRequestJournalKey(){
        return requestJournalKey;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setResponseJournalKey(String key){
        responseJournalKey = key;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public String getResponseJournalKey(){
        return responseJournalKey;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setServletRequestJournalKey(String key){
        servletRequestJournalKey = key;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public String getServletRequestJournalKey(){
        return servletRequestJournalKey;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setServletResponseJournalKey(String key){
        servletResponseJournalKey = key;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public String getServletResponseJournalKey(){
        return servletResponseJournalKey;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setHttpSessionJournalKey(String key){
        httpSessionJournalKey = key;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public String getHttpSessionJournalKey(){
        return httpSessionJournalKey;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setJournalServiceName(ServiceName name){
        journalServiceName = name;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public ServiceName getJournalServiceName(){
        return journalServiceName;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setAccessEditorFinderServiceName(ServiceName name){
        accessEditorFinderServiceName = name;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public ServiceName getAccessEditorFinderServiceName(){
        return accessEditorFinderServiceName;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setRequestEditorFinderServiceName(ServiceName name){
        requestEditorFinderServiceName = name;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public ServiceName getRequestEditorFinderServiceName(){
        return requestEditorFinderServiceName;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setResponseEditorFinderServiceName(ServiceName name){
        responseEditorFinderServiceName = name;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public ServiceName getResponseEditorFinderServiceName(){
        return responseEditorFinderServiceName;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setSequenceServiceName(ServiceName name){
        sequenceServiceName = name;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public ServiceName getSequenceServiceName(){
        return sequenceServiceName;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setContextServiceName(ServiceName name){
        contextServiceName = name;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public ServiceName getContextServiceName(){
        return contextServiceName;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setResponseWrap(boolean isWrap){
        isResponseWrap = isWrap;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public boolean isResponseWrap(){
        return isResponseWrap;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setResponseBufferedOutput(boolean isBuffered){
        isResponseBufferedOutput = isBuffered;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public boolean isResponseBufferedOutput(){
        return isResponseBufferedOutput;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setBushingRequestBlock(boolean isBlock){
        isBushingRequestBlock = isBlock;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public boolean isBushingRequestBlock(){
        return isBushingRequestBlock;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setRequestIDKey(String key){
        requestIdKey = key;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public String getRequestIDKey(){
        return requestIdKey;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setOutputRequestSession(boolean isOutput){
        isOutputRequestSession = isOutput;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public boolean isOutputRequestSession(){
        return isOutputRequestSession;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public void setOutputResponseSession(boolean isOutput){
        isOutputResponseSession = isOutput;
    }
    
    // AccessJournalInterceptorServiceMBeanJavaDoc
    public boolean isOutputResponseSession(){
        return isOutputResponseSession;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService() throws Exception{
        if(journalServiceName == null){
            throw new IllegalArgumentException(
                "journalServiceName must be specified."
            );
        }
        journal = ServiceManagerFactory.getServiceObject(
            journalServiceName
        );
        
        if(accessEditorFinderServiceName != null){
            accessEditorFinder = ServiceManagerFactory
                .getServiceObject(
                    accessEditorFinderServiceName
                );
        }
        
        if(requestEditorFinderServiceName != null){
            requestEditorFinder = ServiceManagerFactory
                .getServiceObject(
                    requestEditorFinderServiceName
                );
        }
        
        if(responseEditorFinderServiceName != null){
            responseEditorFinder = ServiceManagerFactory
                .getServiceObject(
                    responseEditorFinderServiceName
                );
        }
        
        if(sequenceServiceName != null){
            sequence = ServiceManagerFactory
                .getServiceObject(
                    sequenceServiceName
                );
        }
        
        if(contextServiceName != null){
            context = ServiceManagerFactory
                .getServiceObject(
                    contextServiceName
                );
        }
    }
    
    /**
     * NGXg̃W[io͂āÃC^[Zv^ĂяoAX|X̃W[io͂B<p>
     * T[rXJnĂȂꍇ́AɎ̃C^[Zv^ĂяoB<br>
     *
     * @param context ĂяõReLXg
     * @param chain ̃C^[Zv^Ăяo߂̃`F[
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇA܂͂̃C^[Zv^ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    public Object invokeFilter(
        ServletFilterInvocationContext context,
        InterceptorChain chain
    ) throws Throwable{
        if(getState() != State.STARTED){
            return chain.invokeNext(context);
        }
        final ServletRequest request = context.getServletRequest();
        final ServletResponse response = context.getServletResponse();
        
        if(isBushingRequestBlock){
            final String recorded
                 = (String)request.getAttribute(ACCESS_JOURNAL_RECORDED);
            if(recorded != null){
                // W[iL^ς݂Ȃ̂ł̂܂܌㑱s
                return chain.invokeNext(context);
            }
            
            request.setAttribute(ACCESS_JOURNAL_RECORDED, "recorded");
        }
        try{
            journal.startJournal(accessJournalKey, accessEditorFinder);
            if(sequence != null){
                String sequenceId = sequence.increment();
                if(context != null){
                    this.context.put(requestIdKey, sequenceId);
                }
                journal.setRequestId(sequenceId);
            }else if(context != null){
                journal.setRequestId(
                    (String)this.context.get(requestIdKey)
                );
            }
            
            ServletResponse res = null;
            if(isResponseWrap){
                if(response instanceof HttpServletResponse){
                    final HttpServletResponse httpResponse
                         = (HttpServletResponse)response;
                    final JournalHttpServletResponseWrapper responsew
                         = new JournalHttpServletResponseWrapper(httpResponse);
                    responsew.setBufferedOutput(isResponseBufferedOutput);
                    res = responsew;
                }else{
                    final JournalServletResponseWrapper responsew
                         = new JournalServletResponseWrapper(response);
                    responsew.setBufferedOutput(isResponseBufferedOutput);
                    res = responsew;
                }
                context.setServletResponse(res);
            }else{
                res = response;
            }
            try{
                journal.startJournal(
                    requestJournalKey,
                    requestEditorFinder
                );
                journal.addInfo(servletRequestJournalKey, request);
                if(isOutputRequestSession
                     && (request instanceof HttpServletRequest)){
                    journal.addInfo(
                        httpSessionJournalKey,
                        ((HttpServletRequest)request).getSession(false)
                    );
                }
                return chain.invokeNext(context);
            }finally{
                journal.endJournal();
                try{
                    journal.startJournal(
                        responseJournalKey,
                        responseEditorFinder
                    );
                    journal.addInfo(servletResponseJournalKey, res);
                    if(isOutputResponseSession
                         && (request instanceof HttpServletRequest)){
                        journal.addInfo(
                            httpSessionJournalKey,
                            ((HttpServletRequest)request).getSession(false)
                        );
                    }
                    if(isResponseWrap && isResponseBufferedOutput){
                        if(res instanceof JournalHttpServletResponseWrapper){
                            final JournalHttpServletResponseWrapper responsew
                                 = (JournalHttpServletResponseWrapper)res;
                            responsew.flush();
                        }else{
                            final JournalServletResponseWrapper responsew
                                 = (JournalServletResponseWrapper)res;
                            responsew.flush();
                        }
                    }
                }finally{
                    journal.endJournal();
                }
            }
        }finally{
            journal.endJournal();
        }
    }
}