/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.*;

/**
 * {@link MethodAsynchronousInterceptorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see MethodAsynchronousInterceptorService
 */
public interface MethodAsynchronousInterceptorServiceMBean extends ServiceBaseMBean{
    
    /**
     * NGXgi[{@link jp.ossc.nimbus.service.queue.Queue Queue}T[rX̃T[rXݒ肷B<p>
     * ftHgŁA{@link jp.ossc.nimbus.service.queue.DefaultQueueService DefaultQueueService}𐶐AgpB
     *
     * @param name QueueT[rX̃T[rX
     */
    public void setRequestQueueServiceName(ServiceName name);
    
    /**
     * NGXgi[{@link jp.ossc.nimbus.service.queue.Queue Queue}T[rX̃T[rX擾B<p>
     *
     * @return QueueT[rX̃T[rX
     */
    public ServiceName getRequestQueueServiceName();
    
    /**
     * 񓯊Ăяo̖߂莞ԑ҂ꍇ̃^CAEgl[ms]ݒ肷B<p>
     *
     * @param timeout ^CAEg[ms]
     */
    public void setResponseTimeout(long timeout);
    
    /**
     * 񓯊Ăяo̖߂莞ԑ҂ꍇ̃^CAEgl[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getResponseTimeout();
    
    /**
     * 񓯊Ăяo̖߂莞ԑ҂āA߂肪ԂĂȂꍇɗOthrow邩ǂݒ肷B<p>
     * ftHgtrueB
     * 
     * @param isThrow 񓯊Ăяo̖߂莞ԑ҂Ė߂肪ԂĂȂꍇɗOthrowꍇtrue
     */
    public void setFailToWaitResponseTimeout(boolean isThrow);
    
    /**
     * 񓯊Ăяo̖߂莞ԑ҂āA߂肪ԂĂȂꍇɗOthrow邩ǂ𔻒肷B<p>
     * 
     * @return 񓯊Ăяo̖߂莞ԑ҂Ė߂肪ԂĂȂꍇɗOthrowꍇtrue
     */
    public boolean isFailToWaitResponseTimeout();
    
    /**
     * X|Xi[{@link jp.ossc.nimbus.service.queue.Queue Queue}T[rX̃T[rXݒ肷B<p>
     * {@link #setResponseTimeout(long)}ŗLȃ^CAEglݒ肳Ăꍇ́AftHg{@link jp.ossc.nimbus.service.queue.DefaultQueueService DefaultQueueService}𐶐AgpB^CAEglݒ肳ĂȂꍇ́AftHgł̓X|XL[͂ȂŁAX|X͎̂ĂB<br>
     *
     * @param name QueueT[rX̃T[rX
     */
    public void setResponseQueueServiceName(ServiceName name);
    
    /**
     * X|Xi[{@link jp.ossc.nimbus.service.queue.Queue Queue}T[rX̃T[rX擾B<p>
     *
     * @return QueueT[rX̃T[rX
     */
    public ServiceName getResponseQueueServiceName();
    
    /**
     * 񓯊sXbhݒ肷B<p>
     * ftHǵA1B
     *
     * @param size Xbh
     */
    public void setInvokerThreadSize(int size);
    
    /**
     * 񓯊sXbh擾B<p>
     *
     * @return Xbh
     */
    public int getInvokerThreadSize();
    
    /**
     * 񓯊sXbhf[Xbhǂݒ肷B<p>
     * ftHǵAtrueB
     *
     * @param isDaemon f[̏ꍇtrue
     */
    public void setInvokerThreadDaemon(boolean isDaemon);
    
    /**
     * 񓯊sXbhf[Xbhǂ𔻒肷B<p>
     *
     * @return truȅꍇf[
     */
    public boolean isInvokerThreadDaemon();
    
    /**
     * 񓯊s̃Xbh擾B<p>
     *
     * @return 񓯊s̃Xbh
     */
    public int getActiveInvokerThreadSize();
    
    /**
     * ĂяoXbh̖߂lƂāAL[̖߂lԂǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isReturn ߂lԂꍇtrue
     */
    public void setReturnResponse(boolean isReturn);
    
    /**
     * ĂяoXbh̖߂lƂāAL[̖߂lԂǂ𔻒肷B<p>
     *
     * @return truȅꍇA߂lԂ
     */
    public boolean isReturnResponse();
}
