/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.beans.*;

import jp.ossc.nimbus.core.*;

/**
 * {@link ServiceName}^PropertyEditorNXB<p>
 * "[T[rXo^}l[W]#[T[rX]"̕{@link ServiceName}^̃IuWFNgɕϊB<br>
 * [T[rX]"̂ݎw肳ꂽꍇ́A[T[rXo^}l[W]"Nimbus"Ƃ݂ȂB܂A{@link #setServiceManagerName(String)}ŃftHg̃}l[WݒłB̃ftHg̃}l[Wݒ肳Ăꍇ́A"#[T[rX]"̕񂪎w肳ꂽꍇɁA[T[rXo^}l[W]ƂēKpB<br>
 * "${""}"Ɉ͂܂ꂽ́ÃVXevpeBƒuB<br>
 * <p>
 * 1F<br>
 * &nbsp;&nbsp;Manager#Service<br>
 * <br>
 * &nbsp;&nbsp;̂悤ȕ<br>
 * <br>
 * &nbsp;&nbsp;new ServiceName("Manager", "Service")<br>
 * <br>
 * ̂悤ɕϊB<br>
 * <p>
 * 2F<br>
 * &nbsp;&nbsp;Service<br>
 * <br>
 * ̂悤ȕ<br>
 * <br>
 * &nbsp;&nbsp;new ServiceName("Service")<br>
 * <br>
 * ̂悤ɕϊB<br>
 * <p>
 * 3F<br>
 * &nbsp;&nbsp;#Service<br>
 * <br>
 * ̂悤ȕ񂪁A{@link #setServiceManagerName(String)}"Manager"Ɛݒ肵Ă΁A<br>
 * <br>
 * &nbsp;&nbsp;new ServiceName("Manager", "Service")<br>
 * <br>
 * ̂悤ɕϊB{@link #setServiceManagerName(String)}Ń}l[Wݒ肳ĂȂꍇ́AOthrowB<br>
 *
 * @author M.Takata
 */
public class ServiceNameEditor extends PropertyEditorSupport
 implements java.io.Serializable{
    
    private static final long serialVersionUID = -4707170513324274901L;
    
    private String managerName;
    
    /**
     * {@link jp.ossc.nimbus.core.ServiceManager ServiceManager}̖OȗĂT[rX{@link ServiceName}ɕϊꍇɁAgpServiceManager̖Oݒ肷B<p>
     *
     * @param name ServiceManager̖O
     */
    public void setServiceManagerName(String name){
        managerName = name;
    }
    
    /**
     * w肳ꂽ͂ăvpeBlݒ肷B<p>
     *
     * @param text ͂镶
     */
    @Override
    public void setAsText(String text){
        if(text == null){
            setValue(null);
            return;
        }
        final String tmpText = jp.ossc.nimbus.core.Utility.replaceSystemProperty(text, false);
        final int index = tmpText.indexOf('#');
        
        ServiceName serviceName = null;
        if(index == -1){
            serviceName = new ServiceName(tmpText);
        }else if(index == 0 && tmpText.length() > 1){
            if(managerName == null){
                throw new IllegalArgumentException(
                    "ServiceManagerName is null : " + text
                );
            }
            serviceName = new ServiceName(
                managerName,
                tmpText.substring(1)
            );
        }else if(tmpText.length() > index + 1){
            serviceName = new ServiceName(
                tmpText.substring(0, index),
                tmpText.substring(index + 1)
            );
        }else{
            throw new IllegalArgumentException(tmpText);
        }
        setValue(serviceName);
    }
    
    /**
     * vpeB擾B<p>
     *
     * @return vpeB
     */
    @Override
    public String getAsText(){
        final ServiceName name = (ServiceName)getValue();
        if(name == null){
            return null;
        }
        return name.toString();
    }
}
