/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.repository;

import jp.ossc.nimbus.core.*;

/**
 * {@link MBeanServerRepositoryService}MBeanC^tF[XB<p>
 *
 * @author M.Takata
 */
public interface MBeanServerRepositoryServiceMBean
 extends ServiceBaseMBean, Repository{
    
    /**
     * JMXT[õhCݒ肷B<p>
     * javax.management.MBeanServerFactory.findMBeanServer(String)̈ƂĎgpBftHǵAnullB<br>
     *
     * @param domain JMXT[õhC
     */
    public void setMBeanServerDomain(String domain);
    
    /**
     * JMXT[õhC擾B<p>
     *
     * @return JMXT[õhC
     */
    public String getMBeanServerDomain();
    
    /**
     * JMXT[õftHghCݒ肷B<p>
     * javax.management.MBeanServer.getDefaultDomain()ƔrāAJMXT[o肷BftHǵAnullB<br>
     *
     * @param domain JMXT[õftHghC
     */
    public void setMBeanServerDefaultDomain(String domain);
    
    /**
     * JMXT[õftHghC擾B<p>
     *
     * @return JMXT[õftHghC
     */
    public String getMBeanServerDefaultDomain();
    
    /**
     * JMXT[oXg̃CfbNXݒ肷B<p>
     * javax.management.MBeanServerFactory.findMBeanServer(String)̖߂lƂȂList̃CfbNXw肷BftHǵA0B<br>
     *
     * @param index JMXT[oXg̃CfbNX
     */
    public void setMBeanServerIndex(int index);
    
    /**
     * JMXT[oXg̃CfbNX擾B<p>
     *
     * @return JMXT[oXg̃CfbNX
     */
    public int getMBeanServerIndex();
    
    /**
     * MBeanJMXT[oɓo^ۂ̃hCݒ肷B<p>
     * ftHǵÃT[rXo^Ă}l[WB<br>
     *
     * @param domain hC
     */
    public void setObjectNameDomain(String domain);
    
    /**
     * MBeanJMXT[oɓo^ۂ̃hC擾B<p>
     *
     * @return hC
     */
    public String getObjectNameDomain();
    
    /**
     * JMXT[oȂɁAJMXT[o𐶐邩ǂݒ肷B<p>
     * ftHǵAfalseŐȂB<br>
     *
     * @param isCreate ꍇ́Atrue
     */
    public void setCreateMBeanServer(boolean isCreate);
    
    /**
     * JMXT[oȂɁAJMXT[o𐶐邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A
     */
    public boolean isCreateMBeanServer();
}
