/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.message;

import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * {@link DefaultMessageRecordFactoryService}T[rXMBeanC^tF[XB<p>
 *
 * @author H.Nakano
 */
public interface DefaultMessageRecordFactoryServiceMBean extends ServiceBaseMBean{
    
    /**
     * 閧ߍ݃bZ[W閧Ń}XN邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     * 
     * @param flg 閧Ń}XNꍇtrue
     */
    public void setSecretMode(boolean flg);
    
    /**
     * 閧ߍ݃bZ[W閧Ń}XN邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇA閧Ń}XN
     */
    public boolean isSecretMode();
    
    /**
     * 閧ݒ肷B<p>
     * ftHǵAnullŁAbZ[W`̂܂܂ŏo͂B<br>
     * 
     * @param secret 閧
     */
    public void setSecretString(String secret);
    
    /**
     * 閧擾B<p>
     * 
     * @return 閧
     */
    public String getSecretString();
    
    /**
     * bZ[W`t@C̔zufBNgݒ肷B<p>
     * w肵fBNg̒ɁAftHgP[p̃bZ[W`t@CzuB<br>
     * ۉΉꍇ́Aw肵fBNg̒ɃP[̃fBNg쐬āA̔zɑΉ郁bZ[W`t@CzuB<br>
     *
     * @param dirPaths fBNgpXz
     */
    public void setMessageDirPaths(String[] dirPaths);
    
    /**
     * bZ[W`t@C̔zufBNg擾B<p>
     *
     * @return fBNgpXz
     */
    public String[] getMessageDirPaths();
    
    /**
     * bZ[W`t@C̃NXpX̃\[XpXݒ肷B<p>
     * NXpXɃbZ[W`t@CzuB<br>
     * ۉΉꍇ́Agq̑OɃP[t^BivpeBt@CƓlj<br>
     * ftHgŁAjp.ossc.nimbus.resource.NimbusK܂ށB<br>
     * 
     * @param paths bZ[W`t@C̃NXpX̃\[XpXz
     */
    public void setMessageFiles(String[] paths);
    
    /**
     * bZ[W`t@C̃NXpX̃\[XpX擾B<p>
     * 
     * @return bZ[W`t@C̃NXpX̃\[XpXz
     */
    public String[] getMessageFiles();
    
    /**
     * bZ[W`̃t@Cgqݒ肷B<p>
     * ftHǵA"def"B<br>
     * 
     * @param name gqiex "hogeho")
     */
    public void setExtentionOfMessageFile(String name);
    
    /**
     * bZ[W`̃t@Cgq擾B<p>
     * 
     * @return gq
     */
    public String getExtentionOfMessageFile();
    
    /**
     * ǂݍ݂郁bZ[W`t@C̃P[ݒ肷B<p>
     * Őݒ肵ȂP[̃bZ[W`t@ĆA߂ẴP[̃bZ[WKvƂȂꍇɃ[hB
     * AAftHgP[́AT[rXJnɃ[hB<br>
     * 
     * @param locales P[z
     */
    public void setInitialLoadLocales(String[] locales);
    
    /**
     * ǂݍ݂郁bZ[W`t@C̃P[擾B<p>
     * 
     * @return P[z
     */
    public String[] getInitialLoadLocales();
    
    /**
     * bZ[W̏㏑`e邩ǂݒ肷B<p>
     *
     * @param isAllow eꍇAtrue
     */
    public void setAllowOverrideMessage(boolean isAllow);
    
    /**
     * bZ[W̏㏑`e邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAe
     */
    public boolean isAllowOverrideMessage();
    
    /**
     * IɃbZ[W`t@C̔zufBNgǉB<p>
     * ̃\bh́AT[rXJnɓIɃbZ[W`ǉꍇɎgpB<br>
     * 
     * @param dirPath  fBNgw蕶
     * @exception Exception bZ[W`̓I[hɎsꍇ
     */
    public void addMessageDirPath(String dirPath) throws Exception;
    
    /**
     * IɃbZ[W`t@C̔zufBNgǉB<p>
     * ̃\bh́AT[rXJnɓIɃbZ[W`ǉꍇɎgpB<br>
     * 
     * @param dirPaths  fBNgw蕶z
     * @exception Exception bZ[W`̓I[hɎsꍇ
     */
    public void addMessageDirPaths(String[] dirPaths) throws Exception;
    
    /**
     * IɃbZ[W`t@C̃NXpX̃\[XpXǉB<p>
     * ̃\bh́AT[rXJnɓIɃbZ[W`ǉꍇɎgpB<br>
     * 
     * @param path bZ[W`t@C̃NXpX̃\[XpX
     * @exception Exception bZ[W`̓I[hɎsꍇ
     */
    public void addMessageFile(String path) throws Exception;
    
    /**
     * IɃbZ[W`t@C̃NXpX̃\[XpXǉB<p>
     * ̃\bh́AT[rXJnɓIɃbZ[W`ǉꍇɎgpB<br>
     * 
     * @param paths bZ[W`t@C̃NXpX̃\[XpXz
     * @exception Exception bZ[W`̓I[hɎsꍇ
     */
    public void addMessageFiles(String[] paths) throws Exception;
    
    /**
     * bZ[Wꗗ擾B<p>
     * 
     * @return bZ[Wꗗ
     */
    public List<MessageRecord> getMessageList();
}
