/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.crypt;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.util.converter.*;

import java.io.UnsupportedEncodingException;
import java.security.*;
import java.security.spec.*;
import javax.crypto.*;

/**
 * JCE(Java Cryptographic Extension)gpāAÍ@\񋟂T[rXłB<p>
 *
 * @author M.Takata
 */
public class  CipherCryptService extends ServiceBase
 implements Crypt, StringConverter, ReversibleConverter, CipherCryptServiceMBean{
    
    private static final long serialVersionUID = 5230161454391953789L;
    
    private static final String CC___00001 = "CC___00001";
    private static final String CC___00002 = "CC___00002";
    private static final String CC___00003 = "CC___00003";
    
    protected String transformation = DEFAULT_TRANSFORMATION;
    protected Key key;
    protected Provider cipherProvider;
    protected String cipherProviderName;
    protected Provider messageDigestProvider;
    protected String messageDigestProviderName;
    protected AlgorithmParameters algorithmParameters;
    protected AlgorithmParameterSpec algorithmParameterSpec;
    protected SecureRandom secureRandom;
    protected String encoding = DEFAULT_ENCODING;
    protected String hashAlgorithm = DEFAULT_HASH_ALGORITHM;
    protected int convertType;
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setTransformation(String trans){
        transformation = trans;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public String getTransformation(){
        return transformation;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setKey(Key k){
        key = k;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public Key getKey(){
        return key;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setCipherProvider(Provider p){
        cipherProvider = p;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public Provider getCipherProvider(){
        return cipherProvider;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setCipherProviderName(String name){
        cipherProviderName = name;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public String getCipherProviderName(){
        return cipherProviderName;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setAlgorithmParameters(AlgorithmParameters params){
        algorithmParameters = params;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public AlgorithmParameters getAlgorithmParameters(){
        return algorithmParameters;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setAlgorithmParameterSpec(AlgorithmParameterSpec params){
        algorithmParameterSpec = params;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public AlgorithmParameterSpec getAlgorithmParameterSpec(){
        return algorithmParameterSpec;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setSecureRandom(SecureRandom random){
        secureRandom = random;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public SecureRandom getSecureRandom(){
        return secureRandom;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setEncoding(String enc){
        encoding = enc;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public String getEncoding(){
        return encoding;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setHashAlgorithm(String algorithm){
        hashAlgorithm = algorithm;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public String getHashAlgorithm(){
        return hashAlgorithm;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setMessageDigestProvider(Provider p){
        messageDigestProvider = p;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public Provider getMessageDigestProvider(){
        return messageDigestProvider;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setMessageDigestProviderName(String name){
        messageDigestProviderName = name;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public String getMessageDigestProviderName(){
        return messageDigestProviderName;
    }
    
    // CipherCryptServiceMBean JavaDoc
    @Override
    public void setConvertType(int type){
        convertType = type;
    }
    // CipherCryptServiceMBean JavaDoc
    @Override
    public int getConvertType(){
        return convertType;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    @Override
    public void startService() throws Exception{
        if(key != null){
            final String encodeStr = doEncodeInternal("test");
            final String decodeStr = doDecodeInternal(encodeStr);
            if(!"test".equals(decodeStr)){
                throw new IllegalArgumentException(
                    "This encryption cannot convert reversible."
                );
            }
        }
        if(hashAlgorithm != null){
            doHashInternal("test");
        }
        if(key == null && hashAlgorithm == null){
            throw new IllegalArgumentException(
                "It is necessary to specify either of key or hashAlgorithm."
            );
        }
    }
    
    // Crypt JavaDoc
    @Override
    public String doEncode(String str){
        try{
            return doEncodeInternal(str);
        }catch(NoSuchAlgorithmException e){
            // NȂ͂
            getLogger().write(CC___00001, e);
        }catch(NoSuchProviderException e){
            // NȂ͂
            getLogger().write(CC___00001, e);
        }catch(NoSuchPaddingException e){
            // NȂ͂
            getLogger().write(CC___00001, e);
        }catch(InvalidKeyException e){
            // NȂ͂
            getLogger().write(CC___00001, e);
        }catch(InvalidAlgorithmParameterException e){
            // NȂ͂
            getLogger().write(CC___00001, e);
        }catch(IllegalBlockSizeException e){
            // NȂ͂
            getLogger().write(CC___00001, e);
        }catch(BadPaddingException e){
            // NȂ͂
            getLogger().write(CC___00001, e);
        }catch(UnsupportedEncodingException e){
            // NȂ͂
            getLogger().write(CC___00001, e);
        }
        return str;
    }
    
    /**
     * ÍB<p>
     *
     * @param str ÍΏۂ̕
     * @return Í̕
     * @exception NoSuchAlgorithmException w肳ꂽASY݂Ȃꍇ
     * @exception NoSuchProviderException w肳ꂽvoC_݂Ȃꍇ
     * @exception NoSuchPaddingException w肳ꂽpfBO@\݂Ȃꍇ
     * @exception InvalidKeyException w肳ꂽȕǍAȂǂ̖Ȍłꍇ
     * @exception InvalidAlgorithmParameterException w肳ꂽASYp[^܂͕sK؂ȏꍇ
     * @exception IllegalBlockSizeException ubNÍɒ񋟂ꂽf[^̒Ȃꍇ
     * @exception BadPaddingException ̃pfBO@\̓f[^ɑ΂ė\Ă̂Ƀf[^K؂ɃpfBOȂꍇ
     * @exception UnsupportedEncodingException w肳ꂽGR[fBOT|[gĂȂꍇ
     */
    protected String doEncodeInternal(String str)
     throws NoSuchAlgorithmException, NoSuchProviderException,
            NoSuchPaddingException, InvalidKeyException,
            InvalidAlgorithmParameterException,
            IllegalBlockSizeException, BadPaddingException,
            UnsupportedEncodingException{
        if(transformation == null || key == null){
            throw new UnsupportedOperationException(
                "Transformation or key is not specified."
            );
        }
        
        if(str == null){
            return null;
        }
        
        final Cipher c = createCipher();
        
        intiCipher(c, Cipher.ENCRYPT_MODE);
        
        return toHexString(c.doFinal(str.getBytes(encoding)));
    }
    
    /**
     * javax.crypto.Cipher𐶐B<p>
     *
     * @return javax.crypto.Cipher
     * @exception NoSuchAlgorithmException w肳ꂽASY݂Ȃꍇ
     * @exception NoSuchProviderException w肳ꂽvoC_݂Ȃꍇ
     * @exception NoSuchPaddingException w肳ꂽpfBO@\݂Ȃꍇ
     */
    protected Cipher createCipher()
     throws NoSuchAlgorithmException, NoSuchProviderException,
            NoSuchPaddingException{
        if(cipherProvider != null){
            return Cipher.getInstance(transformation, cipherProvider);
        }else if(cipherProviderName != null){
            return Cipher.getInstance(transformation, cipherProviderName);
        }else{
            return Cipher.getInstance(transformation);
        }
    }
    
    /**
     * javax.crypto.CipherB<p>
     *
     * @param c javax.crypto.Cipher
     * @param opmode ̈Í̑샂[h 
     * @exception InvalidKeyException w肳ꂽȕǍAȂǂ̖Ȍłꍇ
     * @exception InvalidAlgorithmParameterException w肳ꂽASYp[^܂͕sK؂ȏꍇ
     */
    protected void intiCipher(Cipher c, int opmode)
     throws InvalidKeyException, InvalidAlgorithmParameterException{
        if(algorithmParameters != null){
            if(secureRandom == null){
                c.init(opmode, key, algorithmParameters);
            }else{
                c.init(
                    opmode,
                    key,
                    algorithmParameters,
                    secureRandom
                );
            }
        }else if(algorithmParameterSpec != null){
            if(secureRandom == null){
                c.init(opmode, key, algorithmParameterSpec);
            }else{
                c.init(
                    opmode,
                    key,
                    algorithmParameterSpec,
                    secureRandom
                );
            }
        }else if(secureRandom != null){
            c.init(opmode, key, secureRandom);
        }else{
            c.init(opmode, key);
        }
    }
    
    /**
     * w肳ꂽoCgz16i̕ɕϊB<p>
     *
     * @param bytes oCgz
     * @return 16i
     */
    protected static String toHexString(byte[] bytes){
        final StringBuilder buf = new StringBuilder();
        for(int i = 0, max = bytes.length; i < max; i++){
            int intValue = bytes[i];
            intValue &= 0x000000FF;
            final String str = Integer.toHexString(intValue).toUpperCase();
            if(str.length() == 1){
                buf.append('0');
            }
            buf.append(str);
        }
        return buf.toString();
    }
    
    // Crypt JavaDoc
    @Override
    public String doDecode(String str){
        try{
            return doDecodeInternal(str);
        }catch(NoSuchAlgorithmException e){
            // NȂ͂
            getLogger().write(CC___00002, e);
        }catch(NoSuchProviderException e){
            // NȂ͂
            getLogger().write(CC___00002, e);
        }catch(NoSuchPaddingException e){
            // NȂ͂
            getLogger().write(CC___00002, e);
        }catch(InvalidKeyException e){
            // NȂ͂
            getLogger().write(CC___00002, e);
        }catch(InvalidAlgorithmParameterException e){
            // NȂ͂
            getLogger().write(CC___00002, e);
        }catch(IllegalBlockSizeException e){
            // NȂ͂
            getLogger().write(CC___00002, e);
        }catch(BadPaddingException e){
            // NȂ͂
            getLogger().write(CC___00002, e);
        }catch(UnsupportedEncodingException e){
            // NȂ͂
            getLogger().write(CC___00002, e);
        }
        return str;
    }
    
    /**
     * B<p>
     *
     * @param str Ώۂ̕
     * @return ̕
     * @exception NoSuchAlgorithmException w肳ꂽASY݂Ȃꍇ
     * @exception NoSuchProviderException w肳ꂽvoC_݂Ȃꍇ
     * @exception NoSuchPaddingException w肳ꂽpfBO@\݂Ȃꍇ
     * @exception InvalidKeyException w肳ꂽȕǍAȂǂ̖Ȍłꍇ
     * @exception InvalidAlgorithmParameterException w肳ꂽASYp[^܂͕sK؂ȏꍇ
     * @exception IllegalBlockSizeException ubNÍɒ񋟂ꂽf[^̒Ȃꍇ
     * @exception BadPaddingException ̃pfBO@\̓f[^ɑ΂ė\Ă̂Ƀf[^K؂ɃpfBOȂꍇ
     * @exception UnsupportedEncodingException w肳ꂽGR[fBOT|[gĂȂꍇ
     */
    protected String doDecodeInternal(String str)
     throws NoSuchAlgorithmException, NoSuchProviderException,
            NoSuchPaddingException, InvalidKeyException,
            InvalidAlgorithmParameterException,
            IllegalBlockSizeException, BadPaddingException,
            UnsupportedEncodingException{
        if(str == null){
            return null;
        }
        
        final Cipher c = createCipher();
        
        intiCipher(c, Cipher.DECRYPT_MODE);
        
        return new String(c.doFinal(toBytes(str)), encoding);
    }
    
    /**
     * w肳ꂽ16i̕oCgzɕϊB<p>
     *
     * @param hex 16i
     * @return oCgz
     */
    protected static byte[] toBytes(String hex){
        final byte[] bytes = new byte[hex.length() / 2];
        for(int i = 0, max = hex.length(); i < max; i+=2){
            bytes[i / 2] = (byte)(Integer.parseInt(
                hex.substring(i, i + 2), 16) & 0x000000FF
            );
        }
        return bytes;
    }
    
    // Crypt JavaDoc
    @Override
    public String doHash(String str){
        try{
            return doHashInternal(str);
        }catch(NoSuchProviderException e){
            // NȂ͂
            getLogger().write(CC___00003, e);
        }catch(NoSuchAlgorithmException e){
            // NȂ͂
            getLogger().write(CC___00003, e);
        }catch(UnsupportedEncodingException e){
            // NȂ͂
            getLogger().write(CC___00003, e);
        }
        return str;
    }
    
    /**
     * nbVB<p>
     *
     * @param str nbVΏۂ̕
     * @return nbV̕
     * @exception NoSuchAlgorithmException w肳ꂽASY݂Ȃꍇ
     * @exception NoSuchProviderException w肳ꂽvoC_݂Ȃꍇ
     * @exception UnsupportedEncodingException w肳ꂽGR[fBOT|[gĂȂꍇ
     */
    protected String doHashInternal(String str)
     throws NoSuchProviderException, NoSuchAlgorithmException,
            UnsupportedEncodingException{
        if(hashAlgorithm == null){
            throw new UnsupportedOperationException(
                "HashAlgorithm is not specified."
            );
        }
        if(str == null){
            return null;
        }
        MessageDigest messageDigest = null;
        if(messageDigestProvider != null){
            messageDigest = MessageDigest.getInstance(
                hashAlgorithm,
                messageDigestProvider
            );
        }else if(messageDigestProviderName != null){
            messageDigest = MessageDigest.getInstance(
                hashAlgorithm,
                messageDigestProviderName
            );
        }else{
            messageDigest = MessageDigest.getInstance(hashAlgorithm);
        }
        
        return toHexString(
            messageDigest.digest(
                str.getBytes(encoding)
            )
        );
    }
    
    // ConverterJavaDoc
    @Override
    public Object convert(Object obj) throws ConvertException{
        if(obj == null){
            return null;
        }else{
            return convert(
                (String)(obj instanceof String ? obj : String.valueOf(obj))
            );
        }
    }
    
    // StringConverterJavaDoc
    @Override
    public String convert(String str) throws ConvertException{
        switch(convertType){
        case REVERSE_CONVERT:
            return doDecode(str);
        case POSITIVE_CONVERT:
        default:
            return doEncode(str);
        }
    }
    
}
