/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

/**
 * LbVQƁB<p>
 * LbVꂽIuWFNg̎QƂێIuWFNgB<br>
 * LbVꂽIuWFNg̎QƂǂ̂悤Ȍ`ŕێ邩́ÃC^tF[X̎NXɈˑB<br>
 *
 * @author M.Takata
 */
public interface CachedReference<E>{
    
    /**
     * LbVꂽIuWFNg擾B<p>
     * {@link #get(Object, boolean) get(null, true)}ŌĂяôɓB<br>
     *
     * @return LbVIuWFNg
     * @see #get(Object, boolean)
     */
    public E get();
    
    /**
     * LbVꂽIuWFNg擾B<p>
     * {@link #get(Object, boolean) get(source, true)}ŌĂяôɓB<br>
     *
     * @param source LbV擾邱̃\bȟĂяoIuWFNg
     * @return LbVIuWFNg
     * @see #get(Object, boolean)
     */
    public E get(Object source);
    
    /**
     * LbVꂽIuWFNg擾B<p>
     * truȅꍇ́A{@link #addCacheAccessListener(CacheAccessListener)}œo^ꂽ{@link CacheAccessListener}ɒʒmBAAœnꂽĂяoIuWFNgʒmCacheAccessListener̃CX^XƓꍇ́AʒmȂB<br>
     * gێLbVIuWFNgnullłȂꍇ́AԂBnull̏ꍇ́A{@link #addLinkedReference(LinkedReference)}œo^ꂽ{@link LinkedReference}擾݂B<br>
     *
     * @param source LbV擾邱̃\bȟĂяoIuWFNg
     * @param notify LbVANZXXiɒʒmꍇtrue
     * @return LbVIuWFNg
     */
    public E get(Object source, boolean notify);
    
    /**
     * LbVIuWFNgݒ肷B<p>
     * {@link #set(Object, Object) set(null, obj)}ŌĂяôɓB<br>
     *
     * @param obj ݒ肷LbVIuWFNg
     * @exception IllegalCachedReferenceException LbVQƂ̏ԂsȈ׃LbVIuWFNg̐ݒɎsꍇ
     * @see #set(Object, Object)
     */
    public void set(E obj) throws IllegalCachedReferenceException;
    
    /**
     * LbVIuWFNgݒ肷B<p>
     * {@link #addCacheChangeListener(CacheChangeListener)}œo^ꂽ{@link CacheChangeListener}ɒʒmBAAœnꂽĂяoIuWFNgʒmCacheChangeListener̃CX^XƓꍇ́AʒmȂB<br>
     *
     * @param source LbVIuWFNgύX邱̃\bȟĂяoIuWFNg
     * @param obj ݒ肷LbVIuWFNg
     * @exception IllegalCachedReferenceException LbVQƂ̏ԂsȈ׃LbVIuWFNg̐ݒɎsꍇ
     */
    public void set(Object source, E obj) throws IllegalCachedReferenceException;
    
    /**
     * LbVIuWFNg폜B<p>
     * {@link #remove(Object) remove(null)}ŌĂяôɓB<br>
     *
     * @see #remove(Object)
     */
    public void remove();
    
    /**
     * LbVIuWFNg폜B<p>
     * {@link #addCacheRemoveListener(CacheRemoveListener)}œo^ꂽ{@link CacheRemoveListener}ɒʒmBAAœnꂽĂяoIuWFNgʒmCacheChangeListener̃CX^XƓꍇ́AʒmȂB<br>
     *
     * @param source LbVIuWFNg폜邱̃\bȟĂяoIuWFNg
     */
    public void remove(Object source);
    
    /**
     * ̃LbVIuWFNg폜Ă邩ǂ𔻒肷B<p>
     *
     * @return 폜ĂꍇAtrue
     */
    public boolean isRemoved();
    
    /**
     * LbVNQƂǉB<p>
     * ̃LbVQƂێLbVIuWFNgA炩̗R{@link LinkedReference}ɑޔnullɂȂĂꍇɁA{@link #get()}ŃLbVIuWFNgvꂽꍇɁÃ\bhœo^ꂽLbVNQƂ{@link LinkedReference#get(CachedReference)}ĂяoB<br>
     *
     * @param link LbVNQ
     */
    public void addLinkedReference(LinkedReference<E> link);
    
    /**
     * LbVNQƂ폜B<p>
     * 
     * @param link LbVNQ
     */
    public void removeLinkedReference(LinkedReference<E> link);
    
    /**
     * LbV폜XiǉB<p>
     * LbVIuWFNg폜ꂽm郊Xio^B<br>
     * {@link #remove()}A{@link #remove(Object)}ŁALbVIuWFNg폜ƁÃ\bhœo^ꂽLbV폜Xi{@link CacheRemoveListener#removed(CachedReference)}ĂяoB<br>
     * 
     * @param listener LbV폜Xi
     */
    public void addCacheRemoveListener(CacheRemoveListener<E> listener);
    
    /**
     * LbV폜Xi폜B<p>
     * 
     * @param listener LbV폜Xi
     */
    public void removeCacheRemoveListener(CacheRemoveListener<E> listener);
    
    /**
     * LbVANZXXiǉB<p>
     * LbVIuWFNgANZXꂽm郊Xio^B<br>
     * {@link #get()}A{@link #get(Object)}A{@link #get(Object, boolean) get(obj, true)}ŁALbVIuWFNgANZXƁÃ\bhœo^ꂽLbVANZXXi{@link CacheAccessListener#accessed(CachedReference)}ĂяoB<br>
     * 
     * @param listener LbVANZXXi
     */
    public void addCacheAccessListener(CacheAccessListener<E> listener);
    
    /**
     * LbVANZXXi폜B<p>
     * 
     * @param listener LbVANZXXi
     */
    public void removeCacheAccessListener(CacheAccessListener<E> listener);
    
    /**
     * LbVύXXiǉB<p>
     * LbVIuWFNgύXꂽm郊Xio^B<br>
     * {@link #set(Object)}A{@link #set(Object, Object)}ŁALbVIuWFNgύXƁÃ\bhœo^ꂽLbVύXXi{@link CacheChangeListener#changed(CachedReference, Object)}ĂяoB<br>
     * 
     * @param listener LbVύXXi
     */
    public void addCacheChangeListener(CacheChangeListener<E> listener);
    
    /**
     * LbVύXXi폜B<p>
     * 
     * @param listener LbVύXXi
     */
    public void removeCacheChangeListener(CacheChangeListener<E> listener);
}