/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.beanflow;

import java.util.Date;
import java.util.Set;

import jp.ossc.nimbus.core.*;

/**
 * {@link BeanFlowServerService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see BeanFlowServerService
 */
public interface BeanFlowServerServiceMBean extends ServiceBaseMBean{
    
    public static final String DEFAULT_JNDI_NAME = "nimbus/BeanFlowServer";
    
    /**
     * {@link BeanFlowFactory}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name BeanFlowFactoryT[rX̃T[rX
     */
    public void setBeanFlowFactoryServiceName(ServiceName name);
    
    /**
     * {@link BeanFlowFactory}T[rX̃T[rX擾B<p>
     * 
     * @return BeanFlowFactoryT[rX̃T[rX
     */
    public ServiceName getBeanFlowFactoryServiceName();
    
    /**
     * {@link BeanFlow#execute(Object, BeanFlowMonitor)}̌Ăяoɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChain InterceptorChain}𐶐{@link jp.ossc.nimbus.service.aop.InterceptorChainFactory InterceptorChainFactory}̃T[rXݒ肷B<p>
     *
     * @param name InterceptorChainFactoryT[rX̃T[rX
     */
    public void setInterceptorChainFactoryServiceName(ServiceName name);
    
    /**
     * {@link BeanFlow#execute(Object, BeanFlowMonitor)}̌Ăяoɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChain InterceptorChain}𐶐{@link jp.ossc.nimbus.service.aop.InterceptorChainFactory InterceptorChainFactory}̃T[rX擾B<p>
     *
     * @return InterceptorChainFactoryT[rX̃T[rX
     */
    public ServiceName getInterceptorChainFactoryServiceName();
    
    /**
     * {@link BeanFlowServer#execute(Object, Object, Map)}̑RŎw肳ꂽReLXg肱{@link jp.ossc.nimbus.service.context.Context Context}̃T[rXݒ肷B<p>
     *
     * @param name ContextT[rX̃T[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * {@link BeanFlowServer#execute(Object, Object, Map)}̑RŎw肳ꂽReLXg肱{@link jp.ossc.nimbus.service.context.Context Context}̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     */
    public ServiceName getContextServiceName();
    
    /**
     * {@link BeanFlowServerService.ResourceUsage}T[rX̃T[rXݒ肷B<p>
     * ݒ肵Ȃꍇ́A{@link jp.ossc.nimbus.service.beancontrol.BeanFlowServer#getResourceUsage() getResourceUsage()}̖߂ĺA{@link jp.ossc.nimbus.service.beancontrol.BeanFlowServer#getCurrentFlowCount() getCurrentFlowCount()}ƓB<br>
     *
     * @param name ResourceUsageT[rX̃T[rX
     */
    public void setResourceUsageServiceName(ServiceName name);
    
    /**
     * {@link BeanFlowServerService.ResourceUsage}T[rX̃T[rX擾B<p>
     *
     * @return ResourceUsageT[rX̃T[rX
     */
    public ServiceName getResourceUsageServiceName();
    
    /**
     * {@link BeanFlowServer}JNDIɃoChۂJNDIݒ肷B<p>
     * ftHǵA{@link #DEFAULT_JNDI_NAME}B<br>
     *
     * @param name BeanFlowServerJNDIɃoChۂJNDI
     */
    public void setJndiName(String name);
    
    /**
     * {@link BeanFlowServer}JNDIɃoChۂJNDI擾B<p>
     *
     * @return BeanFlowServerJNDIɃoChۂJNDI
     */
    public String getJndiName();
    
    /**
     * {@link BeanFlowServer}JNDIɃoCh{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rXݒ肷B<p>
     *
     * @param name RepositoryT[rX̃T[rX
     */
    public void setJndiRepositoryServiceName(ServiceName name);
    
    /**
     * {@link BeanFlowServer}JNDIɃoCh{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rX擾B<p>
     *
     * @return RepositoryT[rX̃T[rX
     */
    public ServiceName getJndiRepositoryServiceName();
    
    /**
     * {@link BeanFlowServer}ɑ΂RMIĂяo鎞̃|[gԍݒ肷B<p>
     * ftHǵA0ŔCӂ̃|[ggpB<br>
     *
     * @param port |[gԍ
     */
    public void setRMIPort(int port);
    
    /**
     * {@link BeanFlowServer}ɑ΂RMIĂяo鎞̃|[gԍ擾B<p>
     *
     * @return |[gԍ
     */
    public int getRMIPort();
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.ClusterService NX^}T[rX̃T[rXݒ肷B<p>
     * ̑ݒ肵ꍇ́ANX^T[rX̃o[̃IvV{@link BeanFlowServer}ݒ肷鎖ŁANX^T[rXoRł̃[gĂяoT|[gB<br>
     * NX^T[rX̃NX^ւ̎Q́ÃT[rX̏ԂƘAKv邽߁A{@link jp.ossc.nimbus.service.distribute.ClusterService#setJoinOnStart(boolean) ClusterService.setJoinOnStart(false)}ɂĂKvB<br>
     *
     * @param name NX^T[rX̃T[rX
     */
    public void setClusterServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.ClusterService NX^}T[rX̃T[rX擾B<p>
     *
     * @return NX^T[rX̃T[rX
     */
    public ServiceName getClusterServiceName();
    
    /**
     * {@link BeanFlowServer#createFlow(String, String, boolean)}ŐsIDɊ܂܂^CX^vtH[}bgݒ肷B<p>
     * ftHǵA"HHmmssSSS"Ȃ̂ŁA24Ԉȏ㑱݂ꍇ́AsID̈ӐۂȂȂB<br>
     *
     * @param foramt ^CX^vtH[}bg
     */
    public void setSequenceTimestampFormat(String format);
    
    /**
     * {@link BeanFlowServer#createFlow(String, String, boolean)}ŐsIDɊ܂܂PʎԂ̃^CX^vtH[}bg擾B<p>
     *
     * @return ^CX^vtH[}bg
     */
    public String getSequenceTimestampFormat();
    
    /**
     * {@link BeanFlowServer#createFlow(String, String, boolean)}ŐsIDɊ܂܂PʎԂ̒ʔԌݒ肷B<p>
     * ftHǵAPʎԂ~bŁAʔԌ3Ȃ̂ŁA1~b999ȏ̏ꍇ́AsID̈ӐۂȂȂB<br>
     *
     * @param digit ʔԌ
     */
    public void setSequenceDigit(int digit);
    
    /**
     * {@link BeanFlowServer#createFlow(String, String, boolean)}ŐsIDɊ܂܂PʎԂ̒ʔԌ擾B<p>
     *
     * @return ʔԌ
     */
    public int getSequenceDigit();
    
    /**
     * ̃T[oNGXgt\𔻒肷B<p>
     *
     * @return NGXgt\ȏꍇtrue
     */
    public boolean isAcceptable();
    
    /**
     * ̃T[oNGXgt\ݒ肷B<p>
     *
     * @param isAcceptable truȅꍇANGXgt\
     */
    public void setAcceptable(boolean isAcceptable);
    
    /**
     * ݐĂBeanFlow̐擾B<p>
     *
     * @return ݐĂBeanFlow̐
     */
    public int getCurrentFlowCount();
    
    /**
     * ݐĂBeanFlow̎sID̏W擾B<p>
     *
     * @return sID̏W
     */
    public Set<Object> getCurrentFlowIdSet();
    
    /**
     * w肳ꂽsIDBeanFlow̎sJn擾B<p>
     *
     * @return sJn
     */
    public Date getFlowStartTime(String id);
    
    /**
     * w肳ꂽsIDBeanFlow̏[ms]擾B<p>
     *
     * @return 
     */
    public long getFlowCurrentProcessTime(String id);
}
