/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.Map;

import jp.ossc.nimbus.core.*;

/**
 * {@link RequestProcessCheckInterceptorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see RequestProcessCheckInterceptorService
 */
public interface RequestProcessCheckInterceptorServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * Oo͂{@link jp.ossc.nimbus.service.log.Logger Logger}T[rX̃T[rXݒ肷B<p>
     * ftHgł́A{@link RequestProcessCheckInterceptorService#getLogger()}Ŏ擾łLoggergpB<br>
     *
     * @param name LoggerT[rX
     */
    public void setReportingLoggerServiceName(ServiceName name);
    
    /**
     * Oo͂{@link jp.ossc.nimbus.service.log.Logger Logger}T[rX̃T[rX擾B<p>
     *
     * @return LoggerT[rX
     */
    public ServiceName getReportingLoggerServiceName();
    
    /**
     * Ԃ臒lƏo͂郍ÕbZ[WID̃}bsOݒ肷B<p>
     * Ԃ臒l[ms]=o͂郍ÕbZ[WID<br>
     *
     * @param threshold Ԃ臒lƏo͂郍ÕbZ[WID̃}bsO
     */
    public void setThreshold(Map<String, String> threshold);
    
    /**
     * Ԃ臒lƏo͂郍ÕbZ[WID̃}bsO擾B<p>
     *
     * @return Ԃ臒lƏo͂郍ÕbZ[WID̃}bsO
     */
    public Map<String, String> getThreshold();
    
    /**
     * Ԃ̃`FbNsԊu[ms]ݒ肷B<p>
     *
     * @param interval `FbNԊu
     */
    public void setCheckInterval(long interval);
    
    /**
     * Ԃ̃`FbNsԊu[ms]擾B<p>
     *
     * @return `FbNԊu
     */
    public long getCheckInterval();
    
    /**
     * ݂̃NGXg̃|[go͂B<p>
     * 
     * @return ݂̃NGXg̃|[g
     */
    public String displayCurrentReport();
    
    /**
     * Ԃ̃`FbN𒆒fB<p>
     */
    public void suspendChecker();
    
    /**
     * Ԃ̃`FbNĊJB<p>
     */
    public void resumeChecker();
    
    /**
     * w肳ꂽNGXgXbhC^[vgB<p>
     *
     * @param groupName Xbh̃O[v
     * @param threadName Xbh
     * @return C^[vgłꍇ́Atrue
     */
    public boolean interruptRequest(String groupName, String threadName);
    
    /**
     * w肳ꂽNGXgXbh`FbNΏۂ폜B<p>
     *
     * @param groupName Xbh̃O[v
     * @param threadName Xbh
     * @return 폜łꍇ́Atrue
     */
    public boolean removeRequest(String groupName, String threadName);
    
    /**
     * NGXgXbh`FbNΏۂSč폜B<p>
     */
    public void clearRequest();
    
    /**
     * NGXg̃Xbh擾B<p>
     *
     * @return NGXg̃Xbh
     */
    public int getRequestCount();
}