/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop;

/**
 * C^[Zv^`F[B<p>
 * {@link #invokeNext(InvocationContext)}ĂяoŁA{@link InterceptorChainList}ɓo^ꂽ{@link Interceptor}ĂяoB<br>
 * ܂ASĂInterceptorĂяoƁA{̌ĂяoĂяo{@link Invoker}ĂяoB<br>
 *
 * @author M.Takata
 */
public interface InterceptorChain{
    
    /**
     * ̃C^[Zv^ĂяoBŌ̃C^Zv^ĂяóA{̌ĂяoĂяo{@link Invoker}ĂяoB<p>
     *
     * @param context ĂяõReLXg
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇ
     */
    public Object invokeNext(InvocationContext context) throws Throwable;
    
    /**
     * ݂̃C^[Zv^̂̃C^[Zv^`F[̃CfbNX擾B<p>
     *
     * @return ݂̃C^[Zv^̂̃C^[Zv^`F[̃CfbNX
     */
    public int getCurrentInterceptorIndex();
    
    /**
     * ݂̃C^[Zv^̂̃C^[Zv^`F[̃CfbNXݒ肷B<p>
     *
     * @param index ݂̃C^[Zv^̂̃C^[Zv^`F[̃CfbNX
     */
    public void setCurrentInterceptorIndex(int index);
    
    /**
     * ̃C^[Zv^`F[C^[Zv^̃Xg擾B<p>
     *
     * @return ̃C^[Zv^`F[C^[Zv^̃Xg
     */
    public InterceptorChainList getInterceptorChainList();
    
    /**
     * Ō̌ĂяosInvoker擾B<p>
     *
     * @return Ō̌ĂяosInvoker
     */
    public Invoker getInvoker();
    
    /**
     * ̃CX^X̕B<p>
     *
     * @return 
     */
    public InterceptorChain cloneChain();
}
