/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import org.w3c.dom.*;

import jp.ossc.nimbus.beans.ServiceNameEditor;

/**
 * T[rX\vf^f[^B<p>
 * 
 * @author M.Takata
 */
public class ServiceNameMetaData extends MetaData implements Serializable{
    
    private static final long serialVersionUID = 3198561088823261679L;
    
    /**
     * ̗vf̖OB<p>
     */
    protected String tagName;
    
    /**
     * T[rX\vf̓eŎw肳ꂽ}l[WB<p>
     */
    protected String managerName = ServiceManager.DEFAULT_NAME;
    
    /**
     * T[rX\vf̓eŎw肳ꂽT[rXB<p>
     */
    protected String serviceName;
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     */
    public ServiceNameMetaData(MetaData parent){
        super(parent);
    }
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     * @param manager T[rXo^{@link ServiceManager}̖O
     */
    public ServiceNameMetaData(MetaData parent, String manager){
        super(parent);
        if(manager != null){
            managerName = manager;
        }
    }
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     * @param manager T[rXo^{@link ServiceManager}̖O
     * @param service T[rX̖O
     */
    public ServiceNameMetaData(MetaData parent, String manager, String service){
        super(parent);
        if(manager != null){
            managerName = manager;
        }
        serviceName = service;
    }
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     * @param name ̗vf̖O
     * @param manager T[rXo^{@link ServiceManager}̖O
     * @param service T[rX̖O
     */
    public ServiceNameMetaData(MetaData parent, String name, String manager, String service){
        super(parent);
        tagName = name;
        if(manager != null){
            managerName = manager;
        }
        serviceName = service;
    }
    
    /**
     * T[rX\vf̓eŎw肳ꂽ}l[W擾B<p>
     * 
     * @return T[rX\vf̓eŎw肳ꂽ}l[W
     */
    public String getManagerName(){
        return managerName;
    }
    
    /**
     * T[rX\vf̓eŎw肳ꂽ}l[Wݒ肷B<p>
     * 
     * @param name T[rX\vf̓eŎw肳ꂽ}l[W
     */
    public void setManagerName(String name){
        if(name != null){
            managerName = name;
        }
    }
    
    /**
     * T[rX\vf̓eŎw肳ꂽT[rX擾B<p>
     * ew肳ĂȂꍇ́AnullԂB<br>
     * 
     * @return T[rX\vf̓e
     */
    public String getServiceName(){
        return serviceName;
    }
    
    /**
     * T[rX\vf̓eŎw肳ꂽT[rXݒ肷B<p>
     * 
     * @param name T[rX\vf̓e
     */
    public void setServiceName(String name){
        serviceName = name;
    }
    
    /**
     * T[rX\vfElementp[XāAg̏sB<p>
     *
     * @param element T[rX\vfElement
     * @exception DeploymentException T[rX\vf̉͂Ɏsꍇ
     */
    @Override
    public void importXML(Element element) throws DeploymentException{
        super.importXML(element);
        
        tagName = element.getTagName();
        
        String content = getElementContent(element);
        if(content != null && content.length() != 0){
            if(content != null){
                // VXevpeB̒u
                content = Utility.replaceSystemProperty(content, false);
                final MetaData parent = getParent();
                if(parent != null && parent instanceof ObjectMetaData){
                    ObjectMetaData objData = (ObjectMetaData)parent;
                    if(objData.getServiceLoader() != null){
                        // T[rX[_\vpeB̒u
                        content = Utility.replaceServiceLoderConfig(
                            objData.getServiceLoader().getConfig(),
                            content,
                            false
                        );
                    }
                }
                if(parent != null && parent instanceof ServiceMetaData){
                    ServiceMetaData serviceData = (ServiceMetaData)parent;
                    if(serviceData.getManager() != null){
                        // }l[WvpeB̒u
                        content = Utility.replaceManagerProperty(serviceData.getManager(), content, false);
                    }
                }
                // T[ovpeB̒u
                content = Utility.replaceServerProperty(content, true);
            }
            if(content.indexOf('#') != -1){
                final ServiceNameEditor editor = new ServiceNameEditor();
                editor.setServiceManagerName(getManagerName());
                try{
                    editor.setAsText(content);
                }catch(IllegalArgumentException e){
                    throw new DeploymentException("Illegal service name.", e);
                }
                final ServiceName editName = (ServiceName)editor.getValue();
                managerName = editName.getServiceManagerName();
                serviceName = editName.getServiceName();
            }else{
                if(managerName == null){
                    managerName = ServiceManager.DEFAULT_NAME;
                }
                serviceName = content;
            }
        }else{
            throw new DeploymentException(
                "Content of '" + tagName + "' element must not be null."
            );
        }
    }
    
    @Override
    public StringBuilder toXML(StringBuilder buf){
        appendComment(buf);
        buf.append('<').append(tagName).append('>');
        if(managerName != null){
            buf.append(managerName);
        }
        if(serviceName != null){
            buf.append('#').append(serviceName);
        }
        buf.append("</").append(tagName).append('>');
        return buf;
    }
    
    /**
     * obj̃IuWFNgƓׂB<p>
     * {@link Service}o^Ă{@link ServiceManager}̖OService̖O̗ꍇ̂trueԂB<br>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return ꍇtrue
     */
    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(this == obj){
            return true;
        }
        if(obj instanceof ServiceNameMetaData){
            final ServiceNameMetaData name = (ServiceNameMetaData)obj;
            if((managerName == null && name.managerName != null)
                || (managerName != null && name.managerName == null)){
                return false;
            }else if(managerName != null && name.managerName != null
                && !managerName.equals(name.managerName)){
                return false;
            }
            if((serviceName == null && name.serviceName != null)
                || (serviceName != null && name.serviceName == null)){
                return false;
            }else if(serviceName != null && name.serviceName != null
                && !serviceName.equals(name.serviceName)){
                return false;
            }
            return true;
        }
        return false;
    }
    
    /**
     * nbVl擾B<p>
     *
     * @return nbVl
     */
    @Override
    public int hashCode(){
        return (managerName != null ? managerName.hashCode() : 0)
            + (serviceName != null ? serviceName.hashCode() : 0);
    }
}
