/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans.dataset;

import java.beans.*;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Array;
import java.util.*;
import java.math.*;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;

import jp.ossc.nimbus.beans.*;
import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.util.converter.*;
import jp.ossc.nimbus.util.validator.*;

/**
 * ftHg̃vpeBXL[}NXB<p>
 * ̃NXɂ́AvpeB̃XL[}ƂāAȉ̏񂪒`łB<br>
 * <ul>
 *   <li>O</li>
 *   <li>^</li>
 *   <li>͕ϊ</li>
 *   <li>o͕ϊ</li>
 *   <li></li>
 *   <li>L[tO</li>
 * </ul>
 * vpeBXL[}`̃tH[}bǵA<br>
 * <pre>
 *    O,^,͕ϊ,o͕ϊ,
 * </pre>
 * ƂȂĂAOȊO͏ȗ\łBAAr̍ڂȗꍇ́A؂qłJ}͕KvłB<br>
 * <p>
 * ɁAeڂ̏ڍׂB<br>
 * <p>
 * ÓAvpeB̖OӖA{@link Record R[h}vpeBl擾ۂ̃L[ƂȂB<br>
 * <p>
 * ^́AvpeB̌^ӖAJavåSCNXŎw肷B<br>
 * <p>
 * ϊނ́A{@link Record#setParseProperty(String, Object)}œ̓IuWFNgvpeB̌^ɕϊlݒ肵A{@link Record#getFormatProperty(String)}ŃvpeBϊ炩̃tH[}bgl擾邽߂̂̂łB<br>
 * ϊɂ́A{@link Converter Ro[^}gp邽߁ARo[^̊SCNX܂́AT[rXw肷邱ƂłB<br>
 * ܂ARo[^̃NXw肷ꍇ́AftHgRXgN^Ro[^łKvBXɁARo[^NXɑ΂ẮARo[^̃vpeBw肷邱ƂłB<br>
 * Ro[^̃vpeB̎ẃA<br>
 * <pre>
 *   "Ro[^̊SCNX{vpeB1=l;vpeB2="l,l",c}"
 * </pre>
 * Ƃ悤ɍsB<br>
 * ܂ARo[^̃NXw肷ꍇŁÃRo[^gݍ킹ꍇ́A<br>
 * <pre>
 *   "Ro[^̊SCNX{vpeB1=l;vpeB2="l,l",c}+Ro[^̊SCNX{vpeB1=l;vpeB2="l,l",c}"
 * </pre>
 * Ƃ悤ɁARo[^̒`"+"ŘAB<br>
 * <p>
 * ́AvpeBɒlݒ肷ۂ́Alɑ΂鐧񎮂܂́A{@link Validator}̊SCNX܂̓T[rX`B<br>
 * ܂Aof[^̃NXw肷ꍇ́AftHgRXgN^of[^łKvBXɁAof[^NXɑ΂ẮAof[^̃vpeBw肷邱ƂłB<br>
 * of[^̃vpeB̎ẃAOqRo[^̃vpeBw@Ɠł<br>
 * 񎮂́A"{}"Ƃ`Ŏw肵AAsA_ZAlZȂǂ\ł邪ǍʂbooleanƂȂ悤ɂȂ΂ȂȂB́AThe Apache Jakarta Project Commons Jexl(http://jakarta.apache.org/commons/jexl/)̎dlɏ]B<br>
 * ĺA"value"Ƃŕ\BႦ΁ANOT NULL|΁A"{value != null}"Ƃ񎮂ɂȂB<br>
 * ܂lɑ΂āA{@link PropertyAccess}găvpeBANZX鎖\łBႦ΁AString^̃vpeBɒTȏƂ|΁A"{prop:get(value, 'length') >= 5}"Ƃ񎮂ɂȂBvpeBANZX́A{@link PropertyFactory vpeBt@Ng}̎dlɏ]B<br>
 * <p>
 * L[tÓA{@link RecordList}̃XL[}ƂĎgpꍇɁÃvpeBL[ł鎖w肷̂ŁAL[ȏꍇ́A"1"Ŏw肷B<br>
 * 
 * @author M.Takata
 */
public class DefaultPropertySchema implements PropertySchema, Serializable{
    
    private static final long serialVersionUID = -197489648533293612L;

    /**
     * IuWFNg̃vpeBW̋؂ړB<p>
     */
    protected static final String CLASS_PROPERTY_PREFIX = "{";
    
    /**
     * IuWFNg̃vpeBW̋؂ڔB<p>
     */
    protected static final String CLASS_PROPERTY_SUFFIX = "}";
    
    /**
     * 񎮂̐ړB<p>
     */
    protected static final String CONSTRAIN_EXPRESSION_PREFIX = "{";
    
    /**
     * 񎮂̐ڔB<p>
     */
    protected static final String CONSTRAIN_EXPRESSION_SUFFIX = "}";
    
    /**
     * IuWFNg̊Ǘp}bvB<p>
     * L[̓IuWFNgAl̓IuWFNgB<br>
     */
    protected static final Map<String, Object> objectManager
         = Collections.synchronizedMap(new HashMap<String, Object>());
    
    /**
     * XL[}B<p>
     */
    protected String schema;
    
    /**
     * vpeB̖OB<p>
     */
    protected String name;
    
    /**
     * vpeB̌^B<p>
     */
    protected Class<?> type;
    
    /**
     * vpeBl̃tH[}bgRo[^B<p>
     */
    protected transient Converter formatConverter;
    
    /**
     * vpeBl̃tH[}bgRo[^T[rXB<p>
     */
    protected ServiceName formatConverterName;
    
    /**
     * vpeBl̃p[XRo[^B<p>
     */
    protected transient Converter parseConverter;
    
    /**
     * vpeBl̃p[XRo[^T[rXB<p>
     */
    protected ServiceName parseConverterName;
    
    /**
     * vpeBl̐ݒ萧B<p>
     */
    protected transient Constrain constrainExpression;
    
    /**
     * vpeBlValidatorT[rXB<p>
     */
    protected ServiceName validatorName;
    
    /**
     * vpeBlValidatorB<p>
     */
    protected transient Validator validator;
    
    /**
     * L[ǂ̃tOB<p>
     * L[̏ꍇtrueŁAftHgfalseB<br>
     */
    protected boolean isPrimaryKey;
    
    /**
     * ̃vpeBXL[}𐶐B<p>
     */
    public DefaultPropertySchema(){
    }
    
    /**
     * vpeBXL[}𐶐B<p>
     *
     * @param schema vpeB̃XL[}`
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public DefaultPropertySchema(String schema) throws PropertySchemaDefineException{
        setSchema(schema);
    }
    
    // PropertySchemaJavaDoc
    @Override
    public void setSchema(String schema) throws PropertySchemaDefineException{
        if(schema == null || schema.length() == 0){
            throw new PropertySchemaDefineException(
                schema,
                "The schema is insufficient."
            );
        }
        parseSchemata(schema, parseCSV(schema));
        this.schema = schema;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public String getSchema(){
        return schema;
    }
    
    /**
     * CSVp[XB<p>
     * ,؂蕶A\1GXP[vA""ň͂ނƃubNGXP[vƂāAp[XB<br>
     *
     * @param text CSV
     * @return Zp[gꂽ̃Xg
     */
    protected static List<String> parseCSV(String text){
        return CSVReader.toList(
            text,
            null,
            ',',
            '\\',
            '"',
            "",
            null,
            true,
            true,
            true,
            false
        );
    }
    
    /**
     * vpeBXL[}̊eڂp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param schemata XL[}ڂ̃Xg
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected void parseSchemata(String schema, List<String> schemata)
     throws PropertySchemaDefineException{
        if(schemata.size() == 0){
            throw new PropertySchemaDefineException("Name must be specified.");
        }
        for(int i = 0, max = schemata.size(); i < max; i++){
            parseSchema(schema, i, schemata.get(i));
        }
    }
    
    /**
     * vpeBXL[}̊eڂp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param index XL[}ڂ̃CfbNX
     * @param val XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected void parseSchema(String schema, int index, String val)
     throws PropertySchemaDefineException{
        switch(index){
        case 0:
            parseName(schema, val);
            break;
        case 1:
            parseType(schema, val);
            break;
        case 2:
            parseParseConverter(schema, val);
            break;
        case 3:
            parseFormatConverter(schema, val);
            break;
        case 4:
            parseConstrain(schema, val);
            break;
        case 5:
            parsePrimaryKey(schema, val);
            break;
        }
    }
    
    /**
     * vpeBXL[}̖O̍ڂp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param val XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected void parseName(String schema, String val)
     throws PropertySchemaDefineException{
        name = val;
    }
    
    /**
     * vpeBXL[}̌^̍ڂp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param val XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected void parseType(String schema, String val)
     throws PropertySchemaDefineException{
        if(val != null && val.length() != 0){
            try{
                type = jp.ossc.nimbus.core.Utility.convertStringToClass(val, false);
            }catch(ClassNotFoundException e){
                throw new PropertySchemaDefineException(
                    schema,
                    "The type is illegal.",
                    e
                );
            }
        }
    }
    
    /**
     * vpeBXL[}͕̓ϊ̍ڂp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param val XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected void parseParseConverter(String schema, String val)
     throws PropertySchemaDefineException{
        Object conv = parseConverter(schema, val);
        if(conv != null){
            if(conv instanceof ServiceName){
                parseConverterName = (ServiceName)conv;
            }else{
                parseConverter = (Converter)conv;
            }
        }
    }
    
    /**
     * vpeBXL[}̏o͕ϊ̍ڂp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param val XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected void parseFormatConverter(String schema, String val)
     throws PropertySchemaDefineException{
        Object conv = parseConverter(schema, val);
        if(conv != null){
            if(conv instanceof ServiceName){
                formatConverterName = (ServiceName)conv;
            }else{
                formatConverter = (Converter)conv;
            }
        }
    }
    
    /**
     * IuWFNgp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param val IuWFNg
     * @return IuWFNg
     * @exception ClassNotFoundException w肳ꂽNX̃NXȂꍇ
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected Object parseObject(String schema, String val)
     throws ClassNotFoundException, PropertySchemaDefineException{
        Object object = objectManager.get(val);
        if(object != null){
            return object;
        }
        String className = val;
        List<String> properties = null;
        final int propStartIndex = className.indexOf(CLASS_PROPERTY_PREFIX);
        if(propStartIndex != -1
             && className.endsWith(CLASS_PROPERTY_SUFFIX)){
            properties = CSVReader.toList(
                className.substring(
                    propStartIndex + 1,
                    className.length() - 1
                ),
                null,
                ';',
                '\\',
                '"',
                null,
                null,
                true,
                false,
                true,
                false
            );
            className = className.substring(0, propStartIndex);
        }
        Class<?> clazz = jp.ossc.nimbus.core.Utility.convertStringToClass(
            className,
            true
        );
        try{
            object = clazz.newInstance();
        }catch(InstantiationException e){
            throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
        }catch(IllegalAccessException e){
            throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
        }
        
        if(properties != null && properties.size() != 0){
            for(String property : properties){
                if(property == null || property.length() < 2){
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val);
                }
                final int index = property.indexOf('=');
                if(index == -1 || index == 0){
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val);
                }
                String propName = property.substring(0, index);
                String propValStr = property.substring(index + 1);
                Property prop = null;
                try{
                    prop = PropertyFactory.createProperty(propName);
                }catch(IllegalArgumentException e){
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
                }
                try{
                    Class<?> propType = prop.getPropertyType(object);
                    if(propType == null){
                        propType = java.lang.String.class;
                    }
                    PropertyEditor editor = NimbusPropertyEditorManager.findEditor(propType);
                    Object propVal = propValStr;
                    if(editor != null){
                        editor.setAsText(propValStr);
                        propVal = editor.getValue();
                    }
                    prop.setProperty(object, propVal);
                }catch(NoSuchPropertyException e){
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
                }catch(InvocationTargetException e){
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
                }catch(RuntimeException e){
                    throw new PropertySchemaDefineException(schema, "Illegal object format : " + val, e);
                }
            }
        }
        objectManager.put(val, object);
        return object;
    }
    
    /**
     * vpeBXL[}̕ϊ̍ڂp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param val XL[}
     * @return {@link Converter Ro[^}܂̓Ro[^{@link ServiceName T[rX}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected Object parseConverter(String schema, String val)
     throws PropertySchemaDefineException{
        if(val != null && val.length() != 0){
            if(val.indexOf('+') == -1){
                try{
                    Object obj = parseObject(schema, val);
                    if(!(obj instanceof Converter)){
                        throw new PropertySchemaDefineException(schema, "Converter dose not implement Converter.");
                    }
                    return obj;
                }catch(ClassNotFoundException e){
                    final ServiceNameEditor serviceNameEditor
                         = new ServiceNameEditor();
                    try{
                        serviceNameEditor.setAsText(val);
                    }catch(IllegalArgumentException e2){
                        throw new PropertySchemaDefineException(
                            schema,
                            "Converter is illegal.",
                            e2
                        );
                    }
                    return (ServiceName)serviceNameEditor.getValue();
                }
            }
            List<String> converterStrList = CSVReader.toList(
                val,
                null,
                '+',
                '\\',
                '"',
                "",
                null,
                true,
                true,
                true,
                false
            );
            Converter[] converters = new Converter[converterStrList.size()];
            for(int i = 0; i < converterStrList.size(); i++){
                try{
                    Object obj = parseObject(schema, converterStrList.get(i));
                    if(!(obj instanceof Converter)){
                        throw new PropertySchemaDefineException(schema, "Converter dose not implement Converter.");
                    }
                    converters[i] = (Converter)obj;
                }catch(ClassNotFoundException e){
                    throw new PropertySchemaDefineException(
                        schema,
                        "Converter is illegal.",
                        e
                    );
                }
            }
            return new CustomConverter(converters);
        }
        return null;
    }
    
    /**
     * vpeBXL[}̐̍ڂp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param val XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected void parseConstrain(String schema, String val)
     throws PropertySchemaDefineException{
        if(val != null && val.length() != 0){
            if(val.startsWith(CONSTRAIN_EXPRESSION_PREFIX)
                && val.endsWith(CONSTRAIN_EXPRESSION_SUFFIX)){
                try{
                    constrainExpression = new Constrain(
                        val.substring(1, val.length() - 1)
                    );
                }catch(Exception e){
                    throw new PropertySchemaDefineException(
                        this.toString(),
                        "Illegal constrain : " + val,
                        e
                    );
                }
            }else{
                try{
                    validator = (Validator)parseObject(schema, val);
                }catch(ClassNotFoundException e){
                    final ServiceNameEditor serviceNameEditor
                         = new ServiceNameEditor();
                    try{
                        serviceNameEditor.setAsText(val);
                    }catch(IllegalArgumentException e2){
                        throw new PropertySchemaDefineException(
                            schema,
                            "Converter is illegal.",
                            e2
                        );
                    }
                    validatorName = (ServiceName)serviceNameEditor.getValue();
                }
            }
        }
    }
    
    /**
     * vpeBXL[}̎L[̍ڂp[XB<p>
     *
     * @param schema vpeBXL[}S
     * @param val XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    protected void parsePrimaryKey(String schema, String val)
     throws PropertySchemaDefineException{
        isPrimaryKey = val != null && "1".equals(val) ? true : false;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public String getName(){
        return name;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public Class<?> getType(){
        return type;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public boolean isPrimaryKey(){
        return isPrimaryKey;
    }
    
    /**
     * p[Xp̃Ro[^擾B<p>
     *
     * @return Ro[^
     */
    public Converter getParseConverter(){
        if(parseConverter != null){
            return parseConverter;
        }
        if(parseConverterName != null){
            return ServiceManagerFactory
                .<Converter>getServiceObject(parseConverterName);
        }
        return null;
    }
    
    /**
     * tH[}bgp̃Ro[^擾B<p>
     *
     * @return Ro[^
     */
    public Converter getFormatConverter(){
        if(formatConverter != null){
            return formatConverter;
        }
        if(formatConverterName != null){
            return ServiceManagerFactory
                .<Converter>getServiceObject(formatConverterName);
        }
        return null;
    }
    
    /**
     * 񎮂擾B<p>
     *
     * @return 
     */
    public String getConstrain(){
        return constrainExpression == null
             ? null : constrainExpression.constrain;
    }
    
    /**
     * ؗpValidator擾B<p>
     *
     * @return Validator
     */
    public Validator getValidator(){
        if(validator != null){
            return validator;
        }
        if(validatorName != null){
            return ServiceManagerFactory
                .<Validator>getServiceObject(validatorName);
        }
        return null;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public Object set(Object val) throws PropertySetException{
        return checkSchema(val);
    }
    
    // PropertySchemaJavaDoc
    @Override
    public Object get(Object val) throws PropertyGetException{
        return val;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public Object format(Object val) throws PropertyGetException{
        Object result = val;
        Converter converter = null;
        try{
            converter = getFormatConverter();
        }catch(ServiceNotFoundException e){
            throw new PropertyGetException(this, e);
        }
        if(converter == null){
            if(result == null){
                return result;
            }
            final Class<?> type = getType();
            if(type != null){
                final PropertyEditor editor
                     = NimbusPropertyEditorManager.findEditor(type);
                if(editor != null){
                    try{
                        editor.setValue(result);
                        result = editor.getAsText();
                    }catch(RuntimeException e){
                        throw new PropertySetException(this, e);
                    }
                }
            }
        }else{
            try{
                result = converter.convert(result);
            }catch(ConvertException e){
                throw new PropertyGetException(this, e);
            }
        }
        return result;
    }
    
    // PropertySchemaJavaDoc
    @Override
    public Object parse(Object val) throws PropertySetException{
        Object result = val;
        Converter converter = null;
        try{
            converter = getParseConverter();
        }catch(ServiceNotFoundException e){
            throw new PropertySetException(this, e);
        }
        if(converter == null){
            if(result == null){
                return result;
            }
            final Class<?> type = getType();
            if(type == null){
                return result;
            }
            final Class<?> inType = result.getClass();
            if(type.isAssignableFrom(inType)){
                return result;
            }
            if(result instanceof String){
                result = parseByPropertyEditor((String)result, type);
            }else if(type.isArray() && inType.equals(String[].class)){
                final String[] array = (String[])result;
                final Class<?> componentType = type.getComponentType();
                result = Array.newInstance(
                    componentType,
                    array.length
                );
                for(int i = 0; i < array.length; i++){
                    Array.set(
                        result,
                        i,
                        parseByPropertyEditor(array[i], componentType)
                    );
                }
            }else{
                throw new PropertySetException(this, "Counld not parse.");
            }
        }else{
            try{
                result = converter.convert(result);
            }catch(ConvertException e){
                throw new PropertySetException(this, e);
            }
        }
        return result;
    }
    
    private Object parseByPropertyEditor(String str, Class<?> editType)
     throws PropertySetException{
        if(str.length() == 0
            && (Number.class.isAssignableFrom(editType)
                || Boolean.class.equals(editType))
        ){
            return null;
        }
        if(editType.isPrimitive()
            && str.length() == 0
        ){
            if(editType.equals(Boolean.TYPE)){
                return Boolean.FALSE;
            }else if(editType.equals(Byte.TYPE)){
                return new Byte((byte)0);
            }else if(editType.equals(Short.TYPE)){
                return new Short((short)0);
            }else if(editType.equals(Integer.TYPE)){
                return new Integer(0);
            }else if(editType.equals(Long.TYPE)){
                return new Long(0l);
            }else if(editType.equals(Float.TYPE)){
                return new Float(0f);
            }else if(editType.equals(Double.TYPE)){
                return new Double(0d);
            }
        }
        final PropertyEditor editor
             = NimbusPropertyEditorManager.findEditor(editType);
        if(editor != null){
            try{
                editor.setAsText(str);
                return editor.getValue();
            }catch(RuntimeException e){
                throw new PropertySetException(this, e);
            }
        }
        return str;
    }
    
    /**
     * vpeB̒lXL[}`ɓKĂ邩`FbNB<p>
     *
     * @param val vpeB̒l
     * @return vpeB̒l
     * @exception PropertySchemaCheckException vpeB̒lXL[}`ɓKĂȂꍇ
     */
    protected Object checkSchema(Object val) throws PropertySchemaCheckException{
        val = checkType(val);
        return val;
    }
    
    /**
     * vpeB̒lXL[}`̌^ɓKĂ邩`FbNB<p>
     *
     * @param val vpeB̒l
     * @return vpeB̒l
     * @exception PropertySchemaCheckException vpeB̒lXL[}`ɓKĂȂꍇ
     */
    protected Object checkType(Object val) throws PropertySchemaCheckException{
        if(type == null || val == null){
            return val;
        }
        
        Class<?> clazz = val.getClass();
        if(!isAssignableFrom(type, clazz)){
            try{
                val = parse(val);
                clazz = val.getClass();
            }catch(PropertySetException e){
                throw new PropertySchemaCheckException(
                    this,
                    "The type is unmatch. type=" + clazz.getName()
                );
            }
        }
        if(Number.class.isAssignableFrom(clazz)
             && ((!type.isPrimitive() && !type.equals(clazz))
                    || (type.isPrimitive() && !type.equals(getPrimitiveClass(clazz))))
        ){
            val = castPrimitiveWrapper(type, (Number)val);
        }
        return val;
    }
    
    private Class<?> getPrimitiveClass(Class<?> type){
        if(type.equals(Byte.class)){
            return Byte.TYPE;
        }else if(type.equals(Short.class)){
            return Short.TYPE;
        }else if(type.equals(Integer.class)){
            return Integer.TYPE;
        }else if(type.equals(Long.class)){
            return Long.TYPE;
        }else if(type.equals(Float.class)){
            return Float.TYPE;
        }else if(type.equals(Double.class)){
            return Double.TYPE;
        }else{
            return null;
        }
    }
    
    private boolean isAssignableFrom(Class<?> thisClass, Class<?> thatClass){
        if(isNumber(thisClass) && isNumber(thatClass)){
            if(Byte.TYPE.equals(thisClass)
                || Byte.class.equals(thisClass)){
                return Byte.TYPE.equals(thatClass)
                    || Byte.class.equals(thatClass);
            }else if(Short.TYPE.equals(thisClass)
                || Short.class.equals(thisClass)){
                return Short.TYPE.equals(thatClass)
                    || Short.class.equals(thatClass)
                    || Byte.TYPE.equals(thatClass)
                    || Byte.class.equals(thatClass);
            }else if(Integer.TYPE.equals(thisClass)
                || Integer.class.equals(thisClass)){
                return Integer.TYPE.equals(thatClass)
                    || Integer.class.equals(thatClass)
                    || Short.TYPE.equals(thatClass)
                    || Short.class.equals(thatClass)
                    || Byte.TYPE.equals(thatClass)
                    || Byte.class.equals(thatClass);
            }else if(Long.TYPE.equals(thisClass)
                || Long.class.equals(thisClass)){
                return Long.TYPE.equals(thatClass)
                    || Long.class.equals(thatClass)
                    || Integer.TYPE.equals(thatClass)
                    || Integer.class.equals(thatClass)
                    || Short.TYPE.equals(thatClass)
                    || Short.class.equals(thatClass)
                    || Byte.TYPE.equals(thatClass)
                    || Byte.class.equals(thatClass);
            }else if(BigInteger.class.equals(thisClass)){
                return BigInteger.class.equals(thatClass)
                    || Long.TYPE.equals(thatClass)
                    || Long.class.equals(thatClass)
                    || Integer.TYPE.equals(thatClass)
                    || Integer.class.equals(thatClass)
                    || Short.TYPE.equals(thatClass)
                    || Short.class.equals(thatClass)
                    || Byte.TYPE.equals(thatClass)
                    || Byte.class.equals(thatClass);
            }else if(Float.TYPE.equals(thisClass)
                || Float.class.equals(thisClass)){
                return Float.TYPE.equals(thatClass)
                    || Float.class.equals(thatClass)
                    || Long.TYPE.equals(thatClass)
                    || Long.class.equals(thatClass)
                    || Integer.TYPE.equals(thatClass)
                    || Integer.class.equals(thatClass)
                    || Short.TYPE.equals(thatClass)
                    || Short.class.equals(thatClass)
                    || Byte.TYPE.equals(thatClass)
                    || Byte.class.equals(thatClass);
            }else if(Double.TYPE.equals(thisClass)
                || Double.class.equals(thisClass)){
                return Double.TYPE.equals(thatClass)
                    || Double.class.equals(thatClass)
                    || Float.TYPE.equals(thatClass)
                    || Float.class.equals(thatClass)
                    || Long.TYPE.equals(thatClass)
                    || Long.class.equals(thatClass)
                    || Integer.TYPE.equals(thatClass)
                    || Integer.class.equals(thatClass)
                    || Short.TYPE.equals(thatClass)
                    || Short.class.equals(thatClass)
                    || Byte.TYPE.equals(thatClass)
                    || Byte.class.equals(thatClass);
            }else if(BigDecimal.class.equals(thisClass)){
                return BigDecimal.class.equals(thatClass)
                    || Double.TYPE.equals(thatClass)
                    || Double.class.equals(thatClass)
                    || Float.TYPE.equals(thatClass)
                    || Float.class.equals(thatClass)
                    || BigInteger.class.equals(thatClass)
                    || Long.TYPE.equals(thatClass)
                    || Long.class.equals(thatClass)
                    || Integer.TYPE.equals(thatClass)
                    || Integer.class.equals(thatClass)
                    || Short.TYPE.equals(thatClass)
                    || Short.class.equals(thatClass)
                    || Byte.TYPE.equals(thatClass)
                    || Byte.class.equals(thatClass);
            }
            return true;
        }else if((thisClass.equals(Boolean.class) && thatClass.equals(Boolean.TYPE))
            || (thisClass.equals(Boolean.TYPE) && thatClass.equals(Boolean.class))
        ){
            return true;
        }else if((thisClass.equals(Character.class) && thatClass.equals(Character.TYPE))
            || (thisClass.equals(Character.TYPE) && thatClass.equals(Character.class))
        ){
            return true;
        }else{
            return thisClass.isAssignableFrom(thatClass);
        }
    }
    
    private boolean isNumber(Class<?> clazz){
        if(clazz == null){
            return false;
        }
        if(clazz.isPrimitive()){
            if(Byte.TYPE.equals(clazz)
                || Short.TYPE.equals(clazz)
                || Integer.TYPE.equals(clazz)
                || Long.TYPE.equals(clazz)
                || Float.TYPE.equals(clazz)
                || Double.TYPE.equals(clazz)){
                return true;
            }else{
                return false;
            }
        }else if(Number.class.isAssignableFrom(clazz)){
            return true;
        }else{
            return false;
        }
    }
    
    private Number castPrimitiveWrapper(Class<?> clazz, Number val){
        if(Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)){
            return new Byte(val.byteValue());
        }else if(Short.class.equals(clazz) || Short.TYPE.equals(clazz)){
            return new Short(val.shortValue());
        }else if(Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)){
            return new Integer(val.intValue());
        }else if(Long.class.equals(clazz) || Long.TYPE.equals(clazz)){
            return new Long(val.longValue());
        }else if(BigInteger.class.equals(clazz)){
            return BigInteger.valueOf(val.longValue());
        }else if(Float.class.equals(clazz) || Float.TYPE.equals(clazz)){
            return new Float(val.floatValue());
        }else if(Double.class.equals(clazz) || Double.TYPE.equals(clazz)){
            return new Double(val.doubleValue());
        }else if(BigDecimal.class.equals(clazz)){
            if(val instanceof BigInteger){
                return new BigDecimal((BigInteger)val);
            }else{
                return new BigDecimal(val.doubleValue());
            }
        }else{
            return val;
        }
    }
    
    // PropertySchemaJavaDoc
    @Override
    public boolean validate(Object val) throws PropertyValidateException{
        if(constrainExpression != null){
            try{
                return constrainExpression.evaluate(val);
            }catch(Exception e){
                throw new PropertyValidateException(
                    this,
                    "The constrain is illegal."
                        + "constrain=" + constrainExpression.constrain
                        + ", value=" + val,
                    e
                );
            }
        }
        Validator validator = null;
        try{
            validator = getValidator();
        }catch(ServiceNotFoundException e){
            throw new PropertyValidateException(this, e);
        }
        if(validator != null){
            try{
                return validator.validate(val);
            }catch(ValidateException e){
                throw new PropertyValidateException(this, e);
            }
        }
        return true;
    }
    
    /**
     * ̃XL[}̕\擾B<p>
     *
     * @return \
     */
    @Override
    public String toString(){
        final StringBuilder buf = new StringBuilder(getClass().getName());
        buf.append('{');
        buf.append("name=").append(name);
        buf.append(",type=").append(type == null ? null : type.getName());
        if(parseConverter == null && parseConverterName == null){
            buf.append(",parseConverter=null");
        }else if(parseConverter != null){
            buf.append(",parseConverter=").append(parseConverter);
        }else{
            buf.append(",parseConverter=").append(parseConverterName);
        }
        if(formatConverter == null && formatConverterName == null){
            buf.append(",formatConverter=null");
        }else if(formatConverter != null){
            buf.append(",formatConverter=").append(formatConverter);
        }else{
            buf.append(",formatConverter=").append(formatConverterName);
        }
        if(validator == null && validatorName == null && constrainExpression == null){
            buf.append(",constrain=null");
        }else if(validator != null){
            buf.append(",constrain=").append(validator);
        }else if(validatorName != null){
            buf.append(",constrain=").append(validatorName);
        }else{
            buf.append(",constrain=").append(constrainExpression.constrain);
        }
        if(isPrimaryKey){
            buf.append(",isPrimaryKey=").append(isPrimaryKey);
        }
        buf.append('}');
        return buf.toString();
    }
    
    /**
     * B<p>
     *
     * @author M.Takata
     */
    protected static class Constrain implements Serializable{
        
        private static final long serialVersionUID = 8372075163997429054L;
        
        /**
         * 񎮒̃vpeBl\B<p>
         */
        protected static final String CONSTRAIN_TARGET_KEY = "value";
        /**
         * 񎮒̃vpeB֐\B<p>
         */
        protected static final String PROP_FUNCTION_NAME = "prop";
        
        /**
         * B<p>
         */
        public final String constrain;
        
        /**
         * 񎮁B<p>
         */
        protected transient Expression expression;
        
        /**
         * 𐶐B<p>
         *
         * @param constrain 񎮕
         * @exception Exception 񎮕̉߂Ɏsꍇ
         */
        public Constrain(String constrain) throws Exception{
            this.constrain = constrain;
            JexlEngine jexl = new JexlEngine();
            jexl.setSilent(true);
            Map<String, Object> funcs = new HashMap<String, Object>();
            PropertyAccess propAccess = new PropertyAccess();
            propAccess.setIgnoreNullProperty(true);
            funcs.put(PROP_FUNCTION_NAME, propAccess);
            jexl.setFunctions(funcs);
            expression = jexl.createExpression(constrain);
            evaluate("", true);
        }
        
        /**
         * w肳ꂽlɓKĂ邩]B<p>
         *
         * @param object Ώۂ̒l
         * @return ɓKĂꍇtrue
         * @exception Exception ]Ɏsꍇ
         */
        public boolean evaluate(Object object) throws Exception{
            return evaluate(object, false);
        }
        
        /**
         * w肳ꂽlɓKĂ邩]B<p>
         *
         * @param object Ώۂ̒l
         * @param isTest 񎮂̌ʂ̌^Ώۂ̒lɈˑꍇA񎮌ʂbooleanƂȂ鎖ۏłȂ̂ŁA^`FbNsȂ悤ɂtO
         * @return ɓKĂꍇtrue
         * @exception Exception ]Ɏsꍇ
         */
        protected boolean evaluate(Object object, boolean isTest) throws Exception{
            JexlContext jexlContext = new MapContext();
            jexlContext.set(CONSTRAIN_TARGET_KEY, object);
            
            Object exp = expression.evaluate(jexlContext);
            if(exp instanceof Boolean){
                return ((Boolean)exp).booleanValue();
            }else{
                if(exp == null && isTest){
                    return true;
                }
                throw new IllegalArgumentException(expression.getExpression());
            }
            
        }
    } 
}
