/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.lang.reflect.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * AvpeBB<p>
 * ̃vpeBAăANZX邽߂{@link Property}B<br>
 * ȉ̂悤ȃR[hB<br>
 * <pre>
 *   String dateStr = obj.getDate();
 *   String timeStr = obj.getTime();
 *   String dateTime = dateStr + timeStr;
 * </pre>
 * AgŁÃR[h<br>
 * <pre>
 *   ConcatenationProperty prop = new ConcatenationProperty(new SimpleProperty("date"), new SimpleProperty("time"));
 *   Object propValue = prop.getProperty(obj);
 * </pre>
 * ƂR[hɒu鎖łB<br>
 * ̃R[h́A璷ɂȂĂ邪AΏۂƂȂBeaň^⃁\bh^CvZ[tɏȂIȃR[hɂȂĂB<br>
 * <p>
 * ̘AvpeBł́Aȉ̂悤BeañvpeBɑ΂ANZX@pӂĂB<br>
 * <table border="1">
 *   <tr bgcolor="#CCCCFF"><th rowspan="3">ANZX@</th><th>Java\</th><th rowspan="3">vpeB\</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>vpeB擾</th><td>A</td><td>bean.getDate() + bean.getTime()</td><td rowspan="2">date+time</td></tr>
 * </table>
 * AΏۂ̂Q̃vpeB́A{@link Property}C^tF[XĂΗǂAPvpeBACfbNXvpeBA}bvvpeBAlXgvpeB̂łǂB<br>
 *
 * @author M.Takata
 */
public class ConcatenatedProperty implements Property, Comparable<Property>, java.io.Serializable{
    
    private static final long serialVersionUID = -7626632324425762277L;
    
    private static final String MSG_00001 = "Illegal ConcatenatedProperty : ";
    private static final String MSG_00002 = "Arguments is null.";
    
    /**
     * AvpeBB<p>
     */
    protected Property thisProperty;
    
    /**
     * AvpeBB<p>
     */
    protected Property concatProperty;
    
    /**
     * nullQƂ̃vpeB擾gpƂꍇɁAOthrow邩ǂ̃tOB<p>
     * truȅꍇ́AOthrowȂBftHǵAfalseB<br>
     */
    protected boolean isIgnoreNullProperty;
    
    /**
     * ̘AvpeB𐶐B<p>
     */
    public ConcatenatedProperty(){
    }
    
    /**
     * w肵Q̃vpeBAAvpeB𐶐B<p>
     *
     * @param prop AvpeB
     * @param concatProp AvpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public ConcatenatedProperty(Property prop, Property concatProp)
     throws IllegalArgumentException{
        if(prop == null || concatProp == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        thisProperty = prop;
        concatProperty = concatProp;
    }
    
    /**
     * AvpeBݒ肷B<p>
     * 
     * @param prop AvpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public void setThisProperty(Property prop) throws IllegalArgumentException{
        if(prop == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        thisProperty = prop;
    }
    
    /**
     * Aŏ̃vpeB擾B<p>
     * 
     * @return Aŏ̃vpeB
     */
    public Property getFirstThisProperty(){
        return getFirstThisProperty(thisProperty);
    }
    
    private Property getFirstThisProperty(Property prop){
        if(prop instanceof ConcatenatedProperty){
            return getFirstThisProperty(
                ((ConcatenatedProperty)prop).getThisProperty()
            );
        }
        return prop;
    }
    
    /**
     * AvpeB擾B<p>
     * 
     * @return AvpeB
     */
    public Property getThisProperty(){
        return thisProperty;
    }
    
    /**
     * AvpeBݒ肷B<p>
     * 
     * @param concatProp AvpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public void setConcatenatedProperty(Property concatProp)
     throws IllegalArgumentException{
        if(concatProp == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        concatProperty = concatProp;
    }
    
    /**
     * AvpeB擾B<p>
     * 
     * @return AvpeB
     */
    public Property getConcatenatedProperty(){
        return concatProperty;
    }
    
    /**
     * w肵vpeB͂B<p>
     * Ŏw\ȕ́A<br>
     * &nbsp;AvpeB.AvpeB<br>
     * łB<br>
     *
     * @param prop vpeB
     * @exception IllegalArgumentException w肳ꂽvpeB̃vpeBIuWFNg͂łȂꍇ
     */
    public void parse(String prop) throws IllegalArgumentException{
        final int index = prop.indexOf('+');
        if(index == -1 || index == 0 || index == prop.length() - 1){
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        thisProperty = PropertyFactory.createProperty(prop.substring(0, index).trim());
        concatProperty = PropertyFactory.createProperty(
            prop.substring(index + 1).trim()
        );
    }
    
    @Override
    public Class<?> getPropertyType(Object obj){
        return String.class;
    }
    
    @Override
    public Class<?> getPropertyGenericType(Object obj){
        return String.class;
    }
    
    @Override
    public boolean isReadable(Object obj){
        return thisProperty.isReadable(obj) && concatProperty.isReadable(obj);
    }
    
    @Override
    public boolean isWritable(Object obj, Class<?> clazz){
        return false;
    }
    
    /**
     * w肵IuWFNgÃvpeB\vpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @return vpeBl
     * @exception NullNestPropertyException AvpeBAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public Object getProperty(Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        StringBuilder buf = new StringBuilder();
        final Object thisObj = thisProperty.getProperty(obj);
        if(thisObj != null){
            buf.append(thisObj);
        }
        final Object concatObj = concatProperty.getProperty(obj);
        if(concatObj != null){
            buf.append(concatObj);
        }
        return thisObj == null && concatObj == null && isIgnoreNullProperty ? null : buf.toString();
    }
    
    /**
     * T|[gȂB<p>
     *
     * @param obj ΏۂƂȂBean
     * @param value ݒ肷vpeBl
     * @exception NullNestPropertyException AvpeBAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public void setProperty(Object obj, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        throw new UnsupportedOperationException();
    }
    
    /**
     * T|[gȂB<p>
     *
     * @param obj ΏۂƂȂBean
     * @param type vpeB̌^
     * @param value ݒ肷vpeBl
     * @exception NullNestPropertyException AvpeBAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public void setProperty(Object obj, Class<?> type, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        throw new UnsupportedOperationException();
    }
    
    /**
     * ̃vpeB\vpeB擾B<p>
     *
     * @return AvpeB.AvpeB
     */
    @Override
    public String getPropertyName(){
        return thisProperty.getPropertyName()
            + '+' + concatProperty.getPropertyName();
    }
    
    @Override
    public void setIgnoreNullProperty(boolean isIgnore){
        isIgnoreNullProperty = isIgnore;
        if(thisProperty != null){
            thisProperty.setIgnoreNullProperty(isIgnoreNullProperty);
        }
        if(concatProperty != null){
            concatProperty.setIgnoreNullProperty(isIgnoreNullProperty);
        }
    }
    
    @Override
    public boolean isIgnoreNullProperty(){
        return isIgnoreNullProperty;
    }
    
    /**
     * AɃvpeBJԂqԂB<p>
     *
     * @return AɃvpeBJԂq
     */
    public Iterator<Property> iterator(){
        final List<Property> list = new ArrayList<Property>();
        ConcatenatedProperty nested = this;
        do{
            list.add(0, nested.getConcatenatedProperty());
            Property prop = getThisProperty();
            if(prop instanceof ConcatenatedProperty){
                nested = (ConcatenatedProperty)prop;
            }else{
                list.add(0, prop);
                nested = null;
            }
        }while(nested != null);
        
        return list.iterator();
    }
    
    /**
     * ̘AvpeB̕\擾B<p>
     *
     * @return ConcatenatedProperty{vpeB.AvpeB}
     */
    public String toString(){
        return "ConcatenatedProperty{" + thisProperty.toString()
            + '+' + concatProperty.toString() + '}';
    }
    
    /**
     * ̃IuWFNgƑ̃IuWFNgǂ܂B <p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return Ɏw肳ꂽIuWFNgƂ̃IuWFNgꍇ trueAłȂꍇ falseB
     */
    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(!(obj instanceof ConcatenatedProperty)){
            return false;
        }
        final ConcatenatedProperty comp = (ConcatenatedProperty)obj;
        if(thisProperty == null && comp.thisProperty != null
            || thisProperty != null && comp.thisProperty == null){
            return false;
        }else if(thisProperty != null && comp.thisProperty != null
            && !thisProperty.equals(comp.thisProperty)){
            return false;
        }
        if(concatProperty == null && comp.concatProperty == null){
            return true;
        }else if(concatProperty == null){
            return false;
        }else{
            return concatProperty.equals(comp.concatProperty);
        }
    }
    
    /**
     * nbVl擾B<p>
     *
     * @return nbVl
     */
    public int hashCode(){
        return (thisProperty == null ? 0 : thisProperty.hashCode()) + (concatProperty == null ? 0 : concatProperty.hashCode()) + 3;
    }
    
    /**
     * ̃IuWFNgƎw肳ꂽIuWFNg̏rB<p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return ̃IuWFNgw肳ꂽIuWFNg菬ꍇ͕̐Aꍇ̓[A傫ꍇ͐̐
     */
    @SuppressWarnings("unchecked")
    @Override
    public int compareTo(Property obj){
        if(obj == null){
            return 1;
        }
        if(!(obj instanceof ConcatenatedProperty)){
            return 1;
        }
        final ConcatenatedProperty comp = (ConcatenatedProperty)obj;
        if(thisProperty == null && comp.thisProperty != null){
            return -1;
        }else if(thisProperty != null && comp.thisProperty == null){
            return 1;
        }else if(thisProperty != null && comp.thisProperty != null){
            if(thisProperty instanceof Comparable){
                final int val = ((Comparable<Property>)thisProperty).compareTo(comp.thisProperty);
                if(val != 0){
                    return val;
                }
            }else{
                return -1;
            }
        }
        if(concatProperty == null && comp.concatProperty == null){
            return 0;
        }else if(concatProperty == null){
            return -1;
        }else{
            if(concatProperty instanceof Comparable){
                return ((Comparable<Property>)concatProperty).compareTo(comp.concatProperty);
            }else{
                return -1;
            }
        }
    }
}
