---
layout: page
title: コミュニティ
css_class: community
---

<h1 class="text-centered page-title main-heading">コミュニティ</h1>

<h2 class="text-centered page-subtitle">
  通信媒体を問わず、
  コミュニティで活躍の場を見つけられることを願っております。
</h2>

# チャットルーム

コミュニティへの参加において、
間違いなく手軽で簡単な方法はチャットルームへの参加です。

公式チャットルームは <code>irc.freenode.net</code> にある <code>#nim</code> チャンネルです。
公式チャットルームには各種方法でアクセスできます:

<i class="fc fa-irc li" aria-hidden="true">#</i>
[IRC クライアント](https://en.wikipedia.org/wiki/Internet_Relay_Chat#Clients)で
<code>irc.freenode.net</code> へ接続後に <code>#nim</code> チャンネルへ参加します。
また、 [IRC ログ](https://irclogs.nim-lang.org) の参照もできます。

<i class="fab fa-gitter black li" aria-hidden="true"></i>
[こちら](https://gitter.im/nim-lang/Nim)をクリックすると
Gitter チャットルームへ参加します。メッセージのリレー配信は IRC と Gitter の双方向間で行われます。

<i class="fab fa-discord black li" aria-hidden="true"></i>
[こちら](https://discord.gg/ezDFDw2)をクリックすると
Discord チャットルームへ参加します。メッセージのリレー配信は IRC と Discord の双方向間で行われます。

<i class="fab black li" aria-hidden="true">m</i>
[こちら](https://matrix.to/#/#freenode_#nim:matrix.org)をクリックすると
Matrix チャットルームへ参加します。メッセージのリレー配信は IRC と Matrix の双方向間で行われます。

<i class="fab fa-telegram black li" aria-hidden="true"></i>
 [こちら](https://t.me/nim_lang)をクリックすると
Telegram チャットルームへ参加します (メッセージのリレー配信は行われません)。

このチャットルームは短文質問、
あるいは興味のある機能やプロジェクトの議論のために参加できます。
正式な機能要望と問題の報告は[問題とRFC](#問題とrfc)のセクションを参照してください。

Gitter, Discord, Matrix および IRC の全メッセージはログとして記録されることを認識しておいてください。
[こちら](https://irclogs.nim-lang.org)から <code>#nim</code> チャンネルの
IRC ログにアクセスすることができます。

<code>#nim</code> チャンネルはオン・トピック (Nim関連の議題) の議論を中心に扱います。
また、オフ・トピック (Nimとは関係のない議題) の議論を扱うために準公式の <code>#nim-offtopic</code> チャンネルがあります。

ログを残したくない場合は、 <code>#nim-nologs</code> チャンネルをお使いください。

# フォーラム

長文や長期にわたる質問、
または新機能など特定のトピックでコミュニティの関心を判断するのに適した場所です。

<i class="fa fa-comments" aria-hidden="true"></i>
[Nim フォーラム](https://forum.nim-lang.org)

# Twitter

リリース、イベントとプロジェクトに関するニュースなどのアナウンスを行います。
Nim に関してツイートするときは、公式 Twitter 
アカウントのフォローとアカウントへのメンションをお忘れなく！

<i class="fab fa-twitter" aria-hidden="true"></i>
[@nim_lang](https://twitter.com/nim_lang)

# ブログ

ブログにはリリースのアナウンスと、そのほかのニュースが最初に投稿されます。
熱心な RSS ユーザーならば、これを選んでください。

<i class="fa fa-bullhorn" aria-hidden="true"></i>
[Nim ブログ]({{ site.baseurl }}/blog.html)

<i class="fa fa-rss" aria-hidden="true"></i>
[Blog フィード]({{ '/feed.xml' | prepend: site.baseurl }})

# Reddit

Nim の subreddit には大勢のユーザが投稿したアナウンス、ブログの投稿、議論があります。
ここは Nim コミュニティとの作品共有には適した場所です。
プロジェクト関連の最新情報を得るには、必ず subscribe ボタンを押してください。

<i class="fab fa-reddit" aria-hidden="true"></i>
[r/nim](https://reddit.com/r/nim)

# StackOverflow

すでに、 StackOverflow では質問の回答で活躍している
Nim 開発者が何人もおり、あなたもその一人として参加できます。
また、新人が自身のプロジェクトの支援を受けとるのに適した場所です。
質問するときは、必ず  ``nim`` タグをお使いください。

<i class="fab fa-stack-overflow" aria-hidden="true"></i>
[nim](https://stackoverflow.com/questions/tagged/nim-lang)

# ミートアップ

Nim ミートアップの設立を計画しているのでしたら、お知らせ願います。
こちらへの掲載と Twitter と他の手段でアナウンスさせていただきます。

現時点で、積極的に活動しているミートアップはありませんが、
次のグループが設立されています:

* [サンパウロ (ブラジル)](http://www.meetup.com/pt-BR/nim-br)
* [ベルリン (ドイツ)](https://www.meetup.com/The-Nim-Language-Meetup/)

# 問題とRFC

issue トラッカーはメインリポジトリと同じく GitHub でホストされています。
ほとんどの Nim 傘下プロジェクトには issue トラッカーがあります:


* [Nim コンパイラと標準ライブラリの issue トラッカー](https://github.com/nim-lang/Nim/issues)

* [Nimsuggest の issue トラッカー](https://github.com/nim-lang/nimsuggest/issues)

* [Nimble の issue トラッカー](https://github.com/nim-lang/nimble/issues)

* [NimForum の issue トラッカー](https://github.com/nim-lang/nimsuggest/issues)

* [このウェブサイトの issue トラッカー](https://github.com/nim-lang/website/issues)

コンパイラ、標準ライブラリ、またはツールに問題を発見した場合は該当するリポジトリに
issue の作成をお願いします。可能ならば、
問題を再現するための適切な最小用例を添付してください。

機能要望がありましたら、正式な RFC (Request For Comments) 作成の検討をお願いします。
機能要望内容として、機能で予測される使用事例、
それ以外にも重要であると思うことなどを分かりやすく記述してくださるようお願いします。
現在のところ、 RFC は
issue トラッカーへの提出をお願いしております。

# Wiki

一般ユーザにより提出された記事とコンテンツに適した場所です。
例えば、玉石混交のハウツー、チュートリアル、メモ、興味深いコンテンツのリンク集などです。
また、フォーラムや IRC チャット利用中などに話題になった
資料やアイデアを公表するのに適した場所でもあります。

GitHub でホストされていますが、 pull をリクエストは不要です。
どなたさまでも非常に簡単に編集ができ、さらに手軽に共有ができます。

* [Nim wiki](https://github.com/nim-lang/Nim/wiki)

# ユーザと貢献者のマップ

{% include map.html %}
