---
title: "Nim Community Survey Results"
author: Dominik Picheta
---

We have recently closed the 2016 Nim Community Survey. I am happy to
say that we have received exactly 790 responses, huge thanks go to the people
that took the time to respond. We're incredibly thankful for this very valuable
feedback.

This survey was inspired in part by the
[2016 State of Rust](https://blog.rust-lang.org/2016/06/30/State-of-Rust-Survey-2016.html)
survey. You will note that many of the questions were modelled after
Rust's survey. One of the reasons for doing this was to allow us to easily
compare our results against the results obtained in the Rust survey. In
addition, we of course also liked many of their questions.

Our survey ran from the 23rd of June 2016 until the 8th of August 2016. The
response numbers are impressive considering Nim's community size; at 790 they
make up just over 25% of the Rust survey's responses.

The goal of this survey was to primarily determine how our community is using
Nim, in order to better understand how we should be improving it. In particular,
we wanted to know what people feel is missing from Nim in the lead up to
version 1.0. We have also asked our respondents about how well the Nim tools
worked, the challenges of adopting Nim, the resources that they used to learn
Nim and more.

It is my hope that we will be able to run a similar survey in a years time,
doing so should give us an idea of whether we are improving.
With these general facts in mind, let's begin looking at specific questions.

# How did you find out about Nim?

The rationale for the first question was simple, we wanted to know where our
respondents found out about Nim. This is an interesting question for us, as
we do occasionally get users asking us why it took so long for them to hear
about Nim. It allows us to see how effective each website is at spreading the
word about Nim.

<a href="{{site.baseurl}}/assets/news/images/survey/nim_found.png">
  <img src="{{site.baseurl}}/assets/news/images/survey/nim_found.png" alt="How did you find out about Nim?" style="width:100%"/>
</a>

The majority of our respondents found Nim via Reddit, HackerNews or a search
engine such as Google. These results are not altogether surprising. There were
also a lot of "Other" responses, some of which were a bit more
interesting. These included multiple mentions of habrahabr.ru, Dr. Dobb's,
and lobste.rs.

# Do you use Nim?

Just like the Rust survey creators, we wanted to ensure that our survey was
open to both Nim users as well people who never used Nim. In addition to
those two groups, we have also included a third group of people: ex-Nim
users. All three are interesting, for many different reasons.
Nim users can tell us how they are using Nim and also how Nim's
tooling can improve. Ex-Nim users give us an
idea of why they stopped using Nim. Finally, respondents who never used Nim
can tell us the reasons for not adopting it.



  <a href="{{site.baseurl}}/assets/news/images/survey/do_you_use_nim.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/do_you_use_nim.png" alt="Do you use Nim?" style="width:100%"/>
  </a>

It's nice to see that we have such a good range of respondents. The Rust survey
had a much larger number of Rust users amongst their respondents, with
no distinction between users that never used Rust and users that stopped using
Rust.

# Should we consider your answers to be invalid?

This was something I thought would be interesting to have, after I saw it
being used in another survey. While it does pinpoint possibly
invalid respondents, I have opted against filtering those out. Mainly because
that would require re-creating each of the charts generated by Google Forms
manually.



  <a href="{{site.baseurl}}/assets/news/images/survey/reliability.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/reliability.png" alt="Should we consider your answers to be invalid?" style="width:100%"/>
  </a>

According to the responses to this question, around 94% of our responses
can be considered reliable.

# Nim users

The following questions were answered only by the 38.9% of our respondents
who identified themselves as Nim users.

## How long have you been using Nim?



  <a href="{{site.baseurl}}/assets/news/images/survey/nim_time.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/nim_time.png" alt="How long have you been using Nim?" style="width:100%"/>
  </a>

A large proportion of our Nim users were new. This is good news as it means that
our community is growing, with a large proportion of new Nim users that could
become long-term Nimians. In total, more than 35% of Nim users can be considered
new having used Nim for less than 3 months. With 18% of Nim users that can
be considered very new having used Nim for less than a month.
This could suggest that 18% of our users have only just found out about Nim in
the last week or so and have not yet got the chance to use it extensively.

The high percentages of long term Nim users are encouraging.
They suggest
that many users are continuing to use Nim after making it through the first
few months. The sharp drop at 7-9 months is interesting, but may simply be
due to the fact that there were fewer newcomers during that period, or it
could be because our respondents are more likely to estimate that they have
been using Nim for a year or half a year rather than the awkward 7-9 months.



  <a href="{{site.baseurl}}/assets/news/images/survey/nim_time_rust.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/nim_time_rust.png" alt="Time using Nim and Rust" style="width:100%"/>
  </a>

The results for Nim and Rust are actually remarkably similar. They both show a
drop at 7-9 months, although Rust's isn't as dramatic. Nim on the other hand
has a significantly higher percentage of new Nim users.

## Do you use Nim at work?

An important aspect of a language's adoption is whether it is being used for
"real" work. We wanted to know how many people are using Nim in their day
jobs and under what circumstances it is used.



  <a href="{{site.baseurl}}/assets/news/images/survey/nim_at_work.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/nim_at_work.png" alt="Do you use Nim at work?" style="width:100%"/>
  </a>

While a vast majority of our users are not using Nim at work, more than 25%
of them are. It's encouraging to see such a high number already, even before
we have released version 1.0. In fact, this percentage is likely close to 30%,
because many of the "Other" responses mention using Nim for the likes of
internal tools or small scripts to help with the respondent's work.



  <a href="https://blog.rust-lang.org/images/2016-06-Survey/rust_at_work.png">
    <img src="https://blog.rust-lang.org/images/2016-06-Survey/rust_at_work.png" alt="Do you use Rust at work?" style="width:100%"/>
  </a>

Interestingly, a larger percentage of Nim users are using Nim at work than
Rust users. The sample sizes are of course vastly different, but it's still an
interesting result. Combined, nearly 1/5th of Rust users are using Rust
commercially whereas more than a quarter of Nim users are using Nim
commercially.

## Approximately how large are all the Nim projects that you work on?

Finding out how large the Nim projects worked on by Nim users are is also
very valuable.



  <a href="{{site.baseurl}}/assets/news/images/survey/project_size.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/project_size.png" alt="Nim project size for all users" style="width:100%"/>
  </a>

This shows us that currently Nim is primarily being used for small scripts and
applications, with nearly 60% of the projects consisting of less than 1,000
lines of code. This makes sense as many of our users are not using Nim
professionally, but are doing so in their spare time.



  <a href="{{site.baseurl}}/assets/news/images/survey/project_size_work.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/project_size_work.png" alt="Nim project size for work users" style="width:100%"/>
  </a>

The numbers for part-time and full-time work users of Nim tell a different
story. Over 70% of the projects written by full-time users are between 10,001
and 100,000 lines of code. Part-time users show a slightly different trend,
with many more small projects, the majority being between 1,000 and
10,000 lines of code.

Overall it's good to see that there is a few large projects out there which are
composed of more than 100,000 lines of code. We expect to see the amount of
large projects to grow with time, especially with version 1.0 on the way.



  <a href="{{site.baseurl}}/assets/news/images/survey/project_size_nim_rust.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/project_size_nim_rust.png" alt="Nim project size for work users (Nim vs. Rust)" style="width:100%"/>
  </a>

In comparison to Rust the proportion of project sizes for full-time users is
vastly different. This is likely due to our small sample size. Project sizes for
part-time users between Rust and Nim are somewhat similar, with differences of
around 10% for each project size.

## Do you plan to try to use Nim at work?

  <a href="{{site.baseurl}}/assets/news/images/survey/planning_to_use_at_work.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/planning_to_use_at_work.png" alt="Planning to use Nim at work?" style="width:100%"/>
  </a>

It's also encouraging to see that over 50% of Nim users are planning to use
Nim at work! This is slightly more than Rust's 40% and should help Nim's
adoption into even more areas.

## Nim and its tools

In this section of the survey, we wanted to find out the tools that Nim
users are utilising when developing Nim applications.

### What editor(s) do you use when writing Nim?

Programmers are very specific when it comes to their editor of choice, because
of that it's good to know which editor is most popular among our community.



  <a href="{{site.baseurl}}/assets/news/images/survey/editors.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/editors.png" alt="Editors used by Nim users" style="width:100%"/>
  </a>

Looks like Vim is the winner with almost 30%. Followed by Sublime Text and
Emacs. Aporia, the Nim IDE, gets a respectable 15.5%. There was
also more than
17% of answers which included "Other" editors, such as: Notepad++, Geany, gedit,
and Kate.

### What operating system(s) do you compile for and run your Nim projects on?

This question gave us information about the most popular target operating
systems, as well as some of the more obscure ones. We have asked this question
to find out the platforms on which Nim applications run on most frequently.



  <a href="{{site.baseurl}}/assets/news/images/survey/target_os.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/target_os.png" alt="Target operating systems" style="width:100%"/>
  </a>

This question allowed multiple choices, so each percentage is out of the total
number of respondents for this question. For example, 80.7% of the
respondents selected "Linux" but only 26.6% selected OS X.

This makes Linux by far the most popular target for Nim applications.
Some "Other" targets included: BSD (OpenBSD, FreeBSD), iOS, Android, and
JavaScript.
It's great to see Nim being used on such a wide variety of platforms.

### What operating system(s) do you develop Nim projects on?

With this question, we wanted to know what operating systems are used for
development.



  <a href="{{site.baseurl}}/assets/news/images/survey/dev_os.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/dev_os.png" alt="Development operating systems" style="width:100%"/>
  </a>

This question also allowed multiple choices and ended up with very similar
results.

You can see that Linux is also the most popular developmental
platform for Nim. But it's more popular as a target platform.

### Which version(s) of Nim do you use for your applications?



  <a href="{{site.baseurl}}/assets/news/images/survey/nim_versions.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/nim_versions.png" alt="Version use" style="width:100%"/>
  </a>

At the time of this survey, version 0.14.2 was the latest stable release.
It's no wonder that it is the most commonly used release of Nim. It's good to
see that the older versions are not used as often. The high use of ``Git HEAD (devel)``
(nightly builds) isn't surprising, Nim is still evolving rapidly and our
release schedule is not regular or frequent.

Once we go past the 1.0 release, we expect to see much less use of the unstable
``devel`` branch.

### Has upgrading to a new version of the Nim compiler broken your code?



  <a href="{{site.baseurl}}/assets/news/images/survey/breakage.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/breakage.png" alt="Breakage" style="width:100%"/>
  </a>

Despite the unstable nature of Nim in the lead up to version 1.0, whenever
we make breaking changes we do our best to deprecate things and ensure that
old code continues to work for our users. Of course sometimes this is not
possible and other times it is simply easier to add a breaking change.

This question was asked to determine how much our user base is affected by
breaking changes between Nim versions. We decided to have three possible
answers for this question in order to give us an idea how frequent the
breakage was.

It's incredible to see that over 50% of our users have not experienced any
breakage after upgrading. We expect this number to increase significantly
after version 1.0 is released. Of the users that did experience breakage,
over 80% of them said that it was a rare occurrence.

In comparison to Rust, our results show that there was a higher percentage of
users experiencing breakage as a result of an upgrade. This is to be expected,
because Nim is still in its pre-1.0 period, whereas Rust 1.0 has been released
over a year ago now.

Unfortunately while we are still in this pre-1.0 period, releases will likely
introduce breaking changes as we refine certain aspects of Nim such as its
standard library, so the number of users experiencing breaking changes may
increase.

### If so, how much work did it take to fix it?



  <a href="{{site.baseurl}}/assets/news/images/survey/difficulty_fixing_breakage.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/difficulty_fixing_breakage.png" alt="difficulty fixing breakage" style="width:100%"/>
  </a>

Thankfully most of the breakage experienced by Nim users was very easy to fix.


### If you used Nimble, do you like it?



  <a href="{{site.baseurl}}/assets/news/images/survey/nimble_opinion.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/nimble_opinion.png" alt="Do you like Nimble?" style="width:100%"/>
  </a>

Nimble is the Nim package manager, a tool that is very important in Nim's
ecosystem as it allows developers to easily install dependencies for their
software.

The majority of respondents rated it as a 4, showing us that the majority does
like Nimble. With over 55% rating it a 4 or 5. This percentage isn't as
overwhelming as the 94.1% of users that rated Cargo a 4 or 5 in the Rust
survey. Based on these results I think that we definitely need to do a
better job with Nimble.

In our next survey, it might be a good idea to ask more questions about Nimble
to determine how exactly it can be improved.

### What aspects of Nim do you find most appealing?



  <a href="{{site.baseurl}}/assets/news/images/survey/nim_appeal.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/nim_appeal.png" alt="What aspects of Nim do you find most appealing?" style="width:100%"/>
  </a>

We were interested to know the features of Nim that appeal most to our users.
More than 80% of our respondents selected "Execution Speed" as one of the
features that appeal to them. With "Development Speed" and "Readability"
tying for second place and "Metaprogramming" at third place.

The options given to our respondents are rather predictable,
they do show us which of these features have the highest appeal though.
What's more interesting are the "Other" answers.

By far the most popular "Other" answer was related to Nim's compilation to C.
Many users mentioned that they like how easy it is to interface with C
libraries and the great portability that compiling to C offers.

### What aspects of Nim do you find most displeasing?



  <a href="{{site.baseurl}}/assets/news/images/survey/nim_displeasing.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/nim_displeasing.png" alt="What aspects of Nim do you find most displeasing?" style="width:100%"/>
  </a>

It was only natural to ask this question. The results are almost perfectly
opposite to the previous question's answers, with almost 50% of respondents
selecting "Debugging Tools"
as the most displeasing aspect of Nim. With "Documentation" and "Testing Tools"
in second and third place respectively. There is also a much larger number of
"Other" answers to this question.

The "Other" answers for this question vary a lot. Here is a selection of
them, ordered by frequency:

* Small community size.
* Lack of in-depth tutorials.
* Quality of error messages.
* Forward declarations and no cyclic imports.
* Bugs in the standard library.
* No good IDE.
* No REPL.
* No major version.
* Bugs in the compiler.
* Lack of libraries.
* Difficulty installing on Windows.
* Non-intuitive semantics of various constructs.
* Lack of immutable collections.
* Async/await not being production ready.
* Lack of shared collections for threads.
* No Haxe target.
* Memory safety.

We hope that we can improve these things with time. Many of these issues are
already being worked on, including the removal of the need for forward
declarations. Some of these issues like our small community size are difficult
to fix, but we will nonetheless do our best.


## Previous Nim users

For users that have used Nim before but decided against using it, we asked just
one specific question. The proportion of our respondents that answered it
was 24%.

### Why did you stop using Nim?



  <a href="{{site.baseurl}}/assets/news/images/survey/ex_nim.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/ex_nim.png" alt="I stopped using Nim because..." style="width:100%"/>
  </a>

Again, this question got a lot of "Other" answers. Apart from that, the
most popular reason for leaving Nim is that it is not stable. Followed by the
a lack of needed libraries and packages and the instability of the
standard library.

* Lack of IDE support.
* Style insensitive.
* Documentation.
* Dislike the syntax.
* Community is too small.
* Missing language features (for example RAII).
* No opportunities to use it at work.
* Messy standard library.

The first item, "Lack of IDE support", was mentioned by multiple respondents.
In the future we should look into ensuring that major IDEs have plugins which
enable easy Nim development.

Based on some of the "Other" answers, it seems that many of the respondents
have not used Nim for very long, for example many respondents complained about
installation issues which they would have run into before getting a chance to
use Nim. Because of this I would consider them not
ex-Nim users but developers that have not had a chance to try Nim fully.
Next time we should also ask how long the respondent has used Nim for to get a
better idea of whether they had a chance to use Nim for extended periods of
time.

## Non-Nim users

We also wanted to know the reasons why developers decided against using Nim.

### Why do you not use Nim?



  <a href="{{site.baseurl}}/assets/news/images/survey/non_user.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/non_user.png" alt="I don't use Nim because..." style="width:100%"/>
  </a>

The most common reason that people have for not using Nim is that it is
not yet ready for production. Thankfully this will improve with time.
IDE support is also a prominent factor just as we've seen in previous results.

There is also a lot of "Other" answers, let's have a look at a selection of
them. Some of the most prominent ones, in order of frequency, include:

* No time to use/learn it
* Syntax
* Documentation is incomplete
* Garbage Collection
* Prefer functional paradigm
* Small community
* Style insensitivity/Case insensitivity

One respondent made a very good suggestion: they said that the
"Do you use Nim?" question should have included "No, but I intend to" as
an answer. Definitely something we will do in the next survey. Indeed, many
respondents mentioned that they were planning on trying out Nim but that they
just have no time to do so, this is very encouraging!

## Learning Resources

We wanted to get an idea of how Nim users are learning Nim. Every respondent
answered this question, no matter what they answered for the "Do you use Nim?"
question.

### Which learning resources, if any, did you use to learn Nim?



  <a href="{{site.baseurl}}/assets/news/images/survey/learning_resources.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/learning_resources.png" alt="learning resources" style="width:100%"/>
  </a>

The idea behind this question was to understand which learning resources
were most popular among our user base. The
[Nim tutorial](http://nim-lang.org/docs/tut1.html) is by far the most
popular. In previous questions, we saw respondents mentioning that the Nim
tutorial does not go into enough detail about Nim. Thanks to this information
we can come to the conclusion that the tutorial needs to be improved
significantly to make sure that it gives our users the necessary information
to use Nim effectively.

Indeed, many users also use the
[Nim manual](http://nim-lang.org/docs/manual.html) to learn Nim.
This manual has been
written as a specification and so is not ideal for teaching Nim. Many of
the concepts in the Nim manual need to be explained in a lot more detail in
the Nim tutorial.

Of course, it's exciting to see our respondents using other materials to learn
Nim. In particular I am excited to see that over 15% of the respondents have
used
[Nim in Action](https://manning.com/books/nim-in-action?a_aid=niminaction&a_bid=78a27e81)
to learn Nim. I expect that more and more users will pick up the book after it
is fully published.

### Nim in Action

As the author of
[Nim in Action](https://manning.com/books/nim-in-action?a_aid=niminaction&a_bid=78a27e81),
I wanted to get some statistics surrounding
my book. With this in mind, I have created some questions relating to it.

#### Have you read Nim in Action?



  <a href="{{site.baseurl}}/assets/news/images/survey/book.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/book.png" alt="Have you read Nim in Action?" style="width:100%"/>
  </a>

It's good to see that over 50% of respondents have read the book or are at least
planning to read it. Keep in mind that this question was answered by all
respondents, not just Nim users.

.. container:: standout

  Are you interested in purchasing a copy of
  [Nim in Action](https://manning.com/books/nim-in-action?a_aid=niminaction&a_bid=78a27e81)?
  If so, you can use code ``wm090416lt`` to get 50% off the printed book today only!
  If you purchase it now you will get access to an early access copy of
  Nim in Action in eBook form and will be able to take part in the development
  of this book.

#### Did you enjoy Nim in Action?



  <a href="{{site.baseurl}}/assets/news/images/survey/book_opinion.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/book_opinion.png" alt="Did you enjoy Nim in Action?" style="width:100%"/>
  </a>

Of the people that read Nim in Action it's nice to see that almost 70% have
enjoyed it.

## Nim's future

### What improvements are needed before Nim v1.0 can be released?

We were interested to know what our users believe is needed before
Nim version 1.0 can be released.



  <a href="{{site.baseurl}}/assets/news/images/survey/10_needs.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/10_needs.png" alt="What is needed before 1.0 can be released?" style="width:100%"/>
  </a>

It appears that the standard library is the biggest concern. With more than half
of all respondents selecting "The standard library needs to reviewed and
any problems with it fixed". This is in fact something we are already planning
to address, so it's good to see that the majority agrees with us.

A large proportion of users also believes that the language is great as-is
and that we should focus on stabilising the compiler. This somewhat contradicts
the majority. But perhaps most of them thought that "The language" excludes the
standard library.

For this question, we decided to give our respondents a dedicated place to
give general feedback about what they feel is needed before v1.0 can be
released. We received over 200 responses to that. Many of these responses
reflect what we have already seen: that the documentation needs to improve,
that we need a good Nim IDE, stability for experimental features such as
concepts, the standard library needs to be cleaned up.

Unfortunately many respondents used this question to say what needs to be fixed
in Nim in general, not what is definitely necessary before 1.0 can be released.

## Community demographics

### What domain do you work in currently?



  <a href="{{site.baseurl}}/assets/news/images/survey/domains.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/domains.png" alt="Work domains" style="width:100%"/>
  </a>


Nim users are working in a wide variety of domains. It is encouraging to see
people from so many different backgrounds taking part in this survey.

### What programming languages are you most comfortable with?




  <a href="{{site.baseurl}}/assets/news/images/survey/languages.png">
    <img src="{{site.baseurl}}/assets/news/images/survey/languages.png" alt="Programming languages" style="width:100%"/>
  </a>

Python and C are the top two programming languages that our respondents are
most comfortable with. This is not altogether surprising.

## Last words

At the end of the survey we gave our respondents a chance to speak their mind
about anything they wish, with a simple question: "Anything else you'd like
to tell us?"

There was a lot of great feedback given in this question from people who
obviously really care deeply about Nim. There is too much to outline here,
but rest assurred that we will take it all into account and do our best to
act on it.

In addition to feedback, we were also overwhelmed by the amount of positive
comments in the answers to this
question. There was a lot of support from the community thanking us for our
work and determination.

I'll let some quotes speak for themselves:

<blockquote>You rock, seriously.</blockquote>
<blockquote>Nim rocks! Keep it up! Thank you very much!</blockquote>
<blockquote>You've made great progress on the language without any corporate backing, that is amazing. I wish Nim becomes one of the top used languages in a few years.</blockquote>
<blockquote>Nim is elegant and wonderful! Keep at it!</blockquote>

Our community is truly brilliant. We thank each and every one of you for
filling out this survey and hope that you will help us tackle some of the
challenges that face Nim.

This survey was a good place to give us feedback, but please don't wait for
the next one. We are always looking to hear more from you and we hope that you
will participate in discussions relating to this survey as well the future
of Nim.

Thanks for reading, and have a good day!
