package net.sf.amateras.nikocale.service;

import java.sql.SQLException;

import jp.sf.nikonikofw.persistence.jdbc.JdbcUtil;
import jp.sf.nikonikofw.persistence.jdbc.annotation.Column;
import net.sf.amateras.nikocale.entity.SystemInfo;

import org.apache.commons.lang.StringUtils;

public class SystemInfoService {
	
	public static SystemInfo getSystemInfo(){
		return JdbcUtil.getSingleResult(SystemInfo.class, "SELECT * FROM SYSTEM_INFO");
	}
	
	public static String getInformation() throws SQLException {
		// お知らせを取得
		StringValueBean record = JdbcUtil.getSingleResult(StringValueBean.class,
				"SELECT INFORMATION AS VALUE FROM SYSTEM_INFO", (Object[]) null);
		
		String information = record.value;
		
		if(StringUtils.isNotEmpty(information)){
			StringBuilder sb = new StringBuilder();
			sb.append("<div class=\"info\">");
			sb.append("<span class=\"info_header\">お知らせ</span>");
			sb.append("<div class=\"info_content\">");
			sb.append(information);
			sb.append("</div>");
			sb.append("</div>");
			
			return sb.toString();
		}
		
		return null;
	}
	
	public static class StringValueBean {
		@Column
		public String value;
	}
	
}
