package net.sf.amateras.nikocale.service;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.sf.nikonikofw.persistence.jdbc.JdbcUtil;
import net.sf.amateras.nikocale.entity.GroupCalendar;

public class GroupCalendarService {

	public static void saveCalendar(GroupCalendar cal) throws SQLException {
		if(cal.id == null){
			JdbcUtil.insert(cal);
		} else {
			JdbcUtil.update(cal);
		}
	}
	
	public static void deleteCalendar(Long id) throws SQLException {
		JdbcUtil.execute("DELETE FROM GROUP_CALENDAR WHERE ID = ?", id);
	}
	
	public static GroupCalendar getGroupCalendar(
			Long groupId, Integer year, Integer month, Integer day) throws SQLException {
		return JdbcUtil.getSingleResult(GroupCalendar.class,
				"SELECT * FROM GROUP_CALENDAR WHERE GROUP_ID=? AND YEAR=? AND MONTH=? AND DAY=?",
				groupId, year, month, day);
	}
	
	public static Map<Integer, GroupCalendar> getCalendar(
			Long groupId, Integer year, Integer month) throws SQLException {
		
		List<GroupCalendar> result = JdbcUtil.getResultList(GroupCalendar.class,
				"SELECT * FROM GROUP_CALENDAR " + 
				"WHERE GROUP_ID = ? AND YEAR = ? AND MONTH = ?",
				groupId, year, month);
		
		Map<Integer, GroupCalendar> calendar = new HashMap<Integer, GroupCalendar>();
		
		for(GroupCalendar entry: result){
			calendar.put(entry.day, entry);
		}
		
		return calendar;
	}

	
}
