package net.sf.amateras.nikocale.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.entity.GroupInfo;
import net.sf.amateras.nikocale.service.GroupService;

public class SavegroupAction implements IAction {

	@Request
	@Required
	public Long groupId;
	
	@Request(label="グループ名")
	@Required
	public String groupName;
	
	@Request
	public String description;
	
	@Request
	public String back;
	
	@Request
	public String delete;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		GroupInfo group = GroupService.getGroup(groupId);
		if(delete != null){
			GroupService.deleteGroup(group);
			
		} else {
			group.groupName = groupName;
			group.description = description;
			GroupService.updateGroup(group);
		}
		
		if(delete == null && "nikocale".equals(back)){
			response.sendRedirect("nikocale.do?groupId=" + groupId);
		} else {
			response.sendRedirect("index.do");
		}
		return null;
	}

}
