package net.sf.amateras.nikocale.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import net.sf.amateras.nikocale.service.EntryService;
import net.sf.amateras.nikocale.service.GroupService;
import net.sf.amateras.nikocale.service.SystemInfoService;

public class IndexAction implements IAction {

	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		request.setAttribute("title", "みんなのニコカレ");
		request.setAttribute("groups", GroupService.getGroups());
		request.setAttribute("information", SystemInfoService.getInformation());
		request.setAttribute("recent", EntryService.getRecentEntries(5));
		request.setAttribute("top", EntryService.getRanking(true));
		request.setAttribute("bottom", EntryService.getRanking(false));
		
		return "index.jsp";
	}
	
}
