package net.sf.amateras.nikocale.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.util.IOUtils;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.util.Utils;

/**
 * ユーザの画像を表示するアクションです。
 * 
 * @author Naoki Takezoe
 */
public class ImageAction implements IAction {
	
	@Request
	@Required
	public Long userId;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		File imageFile = new File(Utils.getImageDir(), userId + ".jpg");
		if(imageFile.exists()){
			response.setContentType("image/jpeg");
			
			OutputStream out = response.getOutputStream();
			IOUtils.copy(new FileInputStream(imageFile), out);
			
			out.flush();
			out.close();
		}
		
		return null;
	}

}
