package net.sf.amateras.nikocale.action;

import java.net.URLDecoder;
import java.util.List;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.entity.Comment;
import net.sf.amateras.nikocale.entity.Entry;
import net.sf.amateras.nikocale.entity.Member;
import net.sf.amateras.nikocale.exception.DataNotFoundException;
import net.sf.amateras.nikocale.service.CommentService;
import net.sf.amateras.nikocale.service.EntryService;
import net.sf.amateras.nikocale.service.GroupService;
import net.sf.amateras.nikocale.service.MemberService;
import net.sf.amateras.nikocale.util.Utils;

public class EntryAction extends AbstractNikocaleAction {

	@Request
	@Required
	public Long memberId;

	@Request
	@Required
	public Integer year;

	@Request
	@Required
	public Integer month;

	@Request
	@Required
	public Integer day;

	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		setDateAttributes(request);
		setCalendarAttribute(request);

		Cookie[] cookies = request.getCookies();
		if(cookies != null){
			for(Cookie cookie: cookies){
				if(cookie.getName().equals("NIKOCALE_NAME")){
					String name = URLDecoder.decode(cookie.getValue(), "UTF-8");
					request.setAttribute("name", name);
				}
			}
		}

		Member member = MemberService.getMember(memberId);
		if(member == null){
			throw new DataNotFoundException("ユーザが存在しません。");
		}
		request.setAttribute("member", member);
		request.setAttribute("entries", EntryService.getMemberEntries(memberId, year, month));
		request.setAttribute("memberGroups", GroupService.getMemberGroups(memberId));
		request.setAttribute("count", EntryService.getMemberEntryCount(memberId));
		request.setAttribute("firstDate", EntryService.getFirstDate(memberId));
		request.setAttribute("latestDate", EntryService.getLatestDate(memberId));
		request.setAttribute("point", EntryService.getMemberPoint(memberId));
		request.setAttribute("image", Utils.existImage(memberId));

		request.setAttribute("title", String.format(
				"%d年%d月%d日の%sさん", year, month, day, member.name));

		Entry entry = EntryService.getEntry(memberId, year, month, day);
		if(entry == null){
			throw new DataNotFoundException("データが存在しません。");
		}
		request.setAttribute("entry", entry);

		List<Comment> commentList = CommentService.getCommentList(entry.id);
		request.setAttribute("commentList", commentList);

		return "entry.jsp";
	}

}
