package net.sf.amateras.nikocale.action;

import java.io.File;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.entity.Member;
import net.sf.amateras.nikocale.exception.DataNotFoundException;
import net.sf.amateras.nikocale.service.GroupService;
import net.sf.amateras.nikocale.service.MemberService;
import net.sf.amateras.nikocale.util.Utils;

public class EdituserAction implements IAction {

	@Request
	@Required
	public Long memberId;
	
	@Request
	public Long groupId;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		Member member = MemberService.getMember(memberId);
		if(member == null){
			throw new DataNotFoundException("ユーザが存在しません。");
		}
		
		request.setAttribute("title", "ユーザの編集");
		request.setAttribute("member", member);
		request.setAttribute("groupMap", MemberService.getGroupMap(memberId));
		request.setAttribute("groupId", groupId);
		request.setAttribute("groups", GroupService.getGroups());
		
		// 画像ファイルの有無を調べる
		File imageFile = new File(Utils.getImageDir(), member.getId() + ".jpg");
		request.setAttribute("image", imageFile.exists());
		
		return "edituser.jsp";
	}

}
