package net.sf.amateras.nikocale.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.entity.Member;
import net.sf.amateras.nikocale.service.MemberService;

public class AdduserAction implements IAction {

	@Request
	public Long groupId;
	
	@Request(label="ユーザ名")
	@Required
	public String name;
	
	@Override
	public String execute(HttpServletRequest request, 
			HttpServletResponse response) throws Exception {
		
		Member member = new Member();
		member.name = name;
		Long memberId = MemberService.addMember(member);
		
		if(groupId != null){
			List<Long> groupIds = new ArrayList<Long>();
			groupIds.add(new Long(groupId));
			MemberService.updateGroupMember(memberId, groupIds);
			
			response.sendRedirect("nikocale.do?groupId=" + groupId);
			
		} else {
			response.sendRedirect("all.do");
			
		}
		return null;
	}

}
