<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/header.jsp" %>

<style type="text/css">
div.recent {
	border-top: 2px dotted gray;
	padding: 4px;
}

div.recent-message {
	padding-left: 20px;
}
</style>

${information}

<p>
  最近更新された20件分のニコカレを表示しています。
</p>

<c:forEach var="entry" items="${recent}">
  <div class="recent">
    <c:if test="${entry.status == 0}">
      <img src="images/good16.png">
    </c:if>
    <c:if test="${entry.status == 1}">
      <img src="images/normal16.png">
    </c:if>
    <c:if test="${entry.status == 2}">
      <img src="images/bad16.png">
    </c:if>
    <a href="entry.do?memberId=${entry.userId}&year=${entry.year}&month=${entry.month}&day=${entry.day}">${entry.year}年${entry.month}月${entry.day}日
    ${f:h(entry.memberName)}</a>
    <div class="recent-message">
      <c:if test="${!empty entry.message}">
        『${f:br(f:link(f:h(entry.message)))}』
      </c:if>
      <c:if test="${!empty entry.commentCount && entry.commentCount != 0}">
        <span style="color: red; font-size: 80%;">(${entry.commentCount}件のコメントがあります)</span>
      </c:if>
    </div>
  </div>
</c:forEach>

<%@include file="/footer.jsp" %>