<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/header.jsp" %>

<c:if test="${!empty error}">
  <div class="error">${f:h(error)}</div>
</c:if>

<form action="saveuser.do" method="POST" enctype="multipart/form-data">
  <table class="form">
  <tr>
    <th>お名前</th>
    <td><input type="text" name="name" size="40" value="${f:h(member.name)}"/></td>
  </tr>
  <tr>
    <th>プロフィール</th>
    <td><textarea rows="5" cols="80" name="profile">${f:h(member.profile)}</textarea></td>
  </tr>
  <tr>
    <th>画像</th>
    <td>
      <c:if test="${image}">
        <img src="${context}/image.do?userId=${member.id}">
        <input type="checkbox" name="deleteImage" value="1" id="deleteImage"><label for="deleteImage">画像を削除する</label><br>
      </c:if>
      <input type="file" size="60" name="image">
    </td>
  </tr>
  <tr>
    <th>グループ</th>
    <td>
      <c:forEach items="${groups}" var="group">
        <input id="group_${group.id}" type="checkbox" name="memberGroupId" value="${group.id}" ${!empty groupMap[group.id] ? 'checked' : ''}><label for="group_${group.id}">${f:h(group.groupName)}</label><br>
      </c:forEach>
    </td>
  </tr>
  </table>
  <input type="hidden" name="memberId" value="${member.id}">
  <input type="hidden" name="groupId" value="${groupId}">
  <input type="submit" name="send" value="保存">
  <input type="submit" name="delete" value="削除" onclick="return confirm('削除します。よろしいですか？');">
  <input type="button" value="戻る" onclick="history.back();">
</form>

<%@include file="/footer.jsp" %>