<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" isELIgnored="false"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://nikonikofw.sf.net/f" prefix="f" %>
<html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <script type="text/javascript" src="${context}/js/prototype.js"></script>
  <script type="text/javascript" src="${context}/js/nikocale.js"></script>
  <link rel="shortcut icon" href="${context}/favicon.ico" >
  <link rel="stylesheet" type="text/css" href="${context}/style.css">

  <script type="text/javascript">
  function submitForm(action){
    if(action == 'delete'){
      if(!confirm('削除します。よろしいですか？')){
        return;
      }
    }

    $('action').value = action;

    $('form').request({
        method: 'POST',
        onSuccess: success,
        onFailure: failure
    });
  }

  function success(response){
    if($('noAjax').value == '1'){
      if($('mode').value == 'member'){
        location.href = 'member.do?memberId=' + $('memberId').value;
      } else if($('mode').value == 'group'){
        location.href = 'nikocale.do?groupId=' + $('groupId').value;
      } else {
        location.href = 'all.do';
      }
    } else {
      var element = parent.parent.document.getElementById('${member.id}-${day}');
      if(element){
        element.innerHTML = response.responseText;
      } else {
        parent.parent.location.reload();
        return;
      }
      element = parent.parent.document.getElementById('${member.id}-${day}-cal');
      if(element){
        element.innerHTML = response.responseText;
      }

      var message = parent.parent.document.getElementById('${member.id}-${day}-message');
      if(message){
        if($('action').value == 'delete'){
          message.innerHTML = '';
        } else {
          var html = link(convertBr($('message').value.escapeHTML()))
            + ' <a href="${context}/entry.do?memberId=${member.id}&year=${year}&month=${month}&day=${day}"><img src="${context}/images/comment.png" border="0" title="コメントを書く"></a>';
          if('${entry.commentCount}' != 0){
            html = html + ' (${entry.commentCount})';
          }
          message.innerHTML = html;
        }
      }

      parent.parent.GB_hide();
    }
  }

  function failure(response){
    alert(response.responseText);
  }

  function link(value){
    return value.replace(/((http|https):\/\/[A-Za-z0-9\._~\/:\-?&=%;#]+)/, '<a href="$1">$1</a>');
  }
  </script>
  <title>${year}年${month}月${day}日の${f:h(member.name)}さん</title>
</head>
<body>
<div class="content">

<form action="save.do" method="POST" id="form" onsubmit="submitForm('save'); return false;">
  <table class="form">
  <tr>
    <th>お名前</th>
    <td>${f:h(member.name)}</td>
  </tr>
  <tr>
    <th>今日の気分</th>
    <td>
      <input type="radio" name="status" id="status_0" value="0" ${entry.status == 0 ? 'checked' : ''}/><label for="status_0"><img src="images/good16.png" title="ニコニコ"></label>
      <input type="radio" name="status" id="status_1" value="1" ${entry.status == 1 ? 'checked' : ''}/><label for="status_1"><img src="images/normal16.png" title="普通"></label>
      <input type="radio" name="status" id="status_2" value="2" ${entry.status == 2 ? 'checked' : ''}/><label for="status_2"><img src="images/bad16.png" title="ダメダメ"></label>
    </td>
  </tr>
  <tr>
    <th>メッセージ</th>
    <td>
      <c:if test="${setting_textarea == '1'}">
        <textarea name="message" id="message" style="width: 450px; height: 250px;">${f:h(entry.message)}</textarea>
      </c:if>
      <c:if test="${setting_textarea != 1}">
        <input type="text" name="message" id="message" size="80" value="${f:h(entry.message)}"/>
      </c:if>
    </td>
  </tr>
  </table>
  <input type="hidden" name="memberId" id="memberId" value="${member.id}">
  <input type="hidden" id="groupId" name="groupId" value="${groupId}">
  <input type="hidden" name="year" value="${year}">
  <input type="hidden" name="month" value="${month}">
  <input type="hidden" name="day" value="${day}">
  <input type="hidden" name="noAjax" id="noAjax" value="${f:h(setting_noAjax)}">
  <input type="hidden" name="mode" id="mode" value="${f:h(mode)}">
  <input type="hidden" name="action" id="action" value="">

  <input type="button" value="保存" onclick="submitForm('save');">
  <c:if test="${!empty entry.id}">
    <input type="button" name="delete" value="この日を削除" onclick="submitForm('delete');">
  </c:if>
  <c:if test="${setting_noAjax == '1'}">
    <input type="button" value="戻る" onclick="history.back();">
  </c:if>
</form>

</div>

</body>
</html>