package jp.sf.nikonikofw.validation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 文字数チェック用のアノテーションです。
 * 
 * @author Naoki Takezoe
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface MaxLength {
	
	int length();
	
	/**
	 * エラーメッセージ。
	 */
	String message() default "%sは%d文字以上で入力してください。";
	
}
