package jp.sf.nikonikofw.persistence.jdo;

import java.util.Collection;

import jp.sf.nikonikofw.Config;

/**
 * JDOの操作を簡単に行うためのユーティリティクラスです。
 * 
 * @author Naoki Takezoe
 */
public class JdoUtil {
	
	/**
	 * <code>JdoQuery</code>のインスタンスを生成します。
	 * 
	 * @param <T> エンティティの型
	 * @param entityClass エンティティの型
	 * @return <code>JdoQuery</code>のインスタンス
	 */
	public static <T> JdoQuery<T> from(Class<T> entityClass){
		return new JdoQuery<T>(entityClass);
	}
	
	/**
	 * エンティティをインサートします。
	 * 
	 * @param entity エンティティ
	 * @deprecated {@link #persistent(Object)}を使用してください。
	 */
	public static void insert(Object entity){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		manager.getPersistenceManager().makePersistent(entity);
	}
	
	/**
	 * エンティティを保存します。
	 * 
	 * @param entity 保存するエンティティ
	 */
	public static void persistent(Object entity){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		manager.getPersistenceManager().makePersistent(entity);
	}
	
	/**
	 * エンティティを削除します。
	 * 
	 * @param entity 削除するエンティティ
	 */
	public static void delete(Object entity){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		manager.getPersistenceManager().deletePersistent(entity);
	}
	
	/**
	 * 複数のエンティティをを削除します。
	 * 
	 * @param entities 削除するエンティティのコレクション
	 */
	public static void deleteAll(Collection<?> entities){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		manager.getPersistenceManager().deletePersistentAll(entities);
	}
	
	/**
	 * オブジェクトIDを指定してエンティティを取得します。
	 * 
	 * @param <T> エンティティの型
	 * @param entityClass エンティティの型
	 * @param id オブジェクトID
	 * @return エンティティ
	 */
	public static <T> T getObjectById(Class<T> entityClass,Object id){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		return manager.getPersistenceManager().getObjectById(entityClass, id);
	}
	

}
