package jp.sf.nikonikofw.persistence.jdbc;

/**
 * データベースのテーブル名やカラム名と、
 * Javaのクラス名やフィールド名の変換を行うオブジェクトのインターフェースです。
 * 
 * @author Naoki Takezoe
 */
public interface INaming {
	
	/**
	 * Java名をデータベース名に変換します。
	 * 
	 * @param javaName Java名
	 * @return データベース名
	 */
	public String toDatabaseName(String javaName);
	
	/**
	 * データベース名をJava名に変換します。
	 * 
	 * @param databaseName データベース名
	 * @return Java名
	 */
	public String toJavaName(String databaseName);
	
}
