package jp.sf.nikonikofw.authentication;

/**
 * <code>IAuthenticationMananger</code>のダミー実装です。
 * <p>
 * 認証処理が不要な場合に使用します。
 * <tt>framework.properties</tt>で<code>authenticationManager</code>を省略した場合にはこの実装が使用されます。
 * 
 * @author Naoki Takezoe
 */
public class NullAuthenticationManager implements IAuthenticationMananger {

	/**
	 * 常に<code>null</code>を返します。
	 */
	@Override
	public Object getUserInfo() {
		return null;
	}

	/**
	 * 常にfalseを返します。
	 */
	@Override
	public boolean isAdmin() {
		return false;
	}

	/**
	 * 常にfalseを返します。
	 */
	@Override
	public boolean isLogin() {
		return false;
	}

	/**
	 * 常に<code>UnsupportedOperationException</code>をスローします。
	 */
	@Override
	public void login(Object obj) {
		throw new UnsupportedOperationException();
	}

	/**
	 * 常に<code>UnsupportedOperationException</code>をスローします。
	 */
	@Override
	public void logout() {
		throw new UnsupportedOperationException();
	}

}
