package jp.sf.nikonikofw.authentication;

/**
 * 
 * 
 * @author Naoki Takezoe
 */
public interface IAuthenticationMananger {
	
	/**
	 * ログインしているかどうかを判定します。
	 * 
	 * @return ログインしている場合true、していない場合false
	 */
	public boolean isLogin();
	
	/**
	 * 管理者としてログインしているかどうかを判定します。
	 * 
	 * @return 管理者としてログインしている場合true、そうでない場合false
	 */
	public boolean isAdmin();
	
	/**
	 * ログインユーザの情報を格納したオブジェクトを返却します。
	 * ログインしていない場合はnullが返ります。
	 * 
	 * @return ログインユーザの情報を格納したオブジェクト
	 */
	public Object getUserInfo();
	
	/**
	 * ログインします。
	 * 
	 * @param obj ログインユーザの情報を格納したオブジェクト
	 */
	public void login(Object obj);
	
	/**
	 * ログアウトします。
	 */
	public void logout();
	
}
